/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.enhance.Enhancer;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.ModelException;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.SchemaBuilderFromEntities;
import net.lecousin.reactive.data.relational.schema.SchemaException;
import net.lecousin.reactive.data.relational.schema.Table;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatement;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatements;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.Entity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractBasicTest
extends AbstractLcReactiveDataRelationalTest {
    @Override
    protected Collection<Class<?>> usedEntities() {
        return new LinkedList();
    }

    protected abstract Class<? extends RelationalDatabaseSchemaDialect> expectedDialect();

    @Test
    public void testDialect() {
        Assertions.assertEquals(this.expectedDialect(), this.lcClient.getSchemaDialect().getClass());
        Assertions.assertEquals(this.expectedDialect(), RelationalDatabaseSchemaDialect.getDialect((R2dbcDialect)this.lcClient.getDialect()).getClass());
        Assertions.assertTrue((boolean)this.lcClient.getSchemaDialect().isCompatible(this.lcClient.getDialect()));
    }

    @Test
    public void testEnhanceAgain() throws Exception {
        Collection<Class<?>> entities = this.getAllCompatibleEntities();
        Enhancer.enhance(Arrays.asList(entities.iterator().next().getName()));
        Enhancer.enhance(Arrays.asList(entities.iterator().next().getName()));
    }

    @Test
    public void testEnhanceNonEntityClass() {
        try {
            Enhancer.enhance(Arrays.asList(this.getClass().getName()));
            throw new AssertionError((Object)"Error expected");
        }
        catch (ModelException modelException) {
            return;
        }
    }

    @Test
    public void testGetStateWithoutEntityType() throws Exception {
        Entity entity = new Entity();
        LcReactiveDataRelationalClient client = (LcReactiveDataRelationalClient)Mockito.mock(LcReactiveDataRelationalClient.class);
        MappingContext mappingContext = (MappingContext)Mockito.mock(MappingContext.class);
        RelationalPersistentEntity entityType = (RelationalPersistentEntity)Mockito.mock(RelationalPersistentEntity.class);
        Mockito.when((Object)client.getMappingContext()).thenReturn((Object)mappingContext);
        Mockito.when((Object)mappingContext.getRequiredPersistentEntity(entity.getClass())).thenReturn((Object)entityType);
        EntityState.get((Object)entity, (LcReactiveDataRelationalClient)client);
    }

    @Test
    public void testGetEntityStateError() throws Exception {
        Entity entity = new Entity();
        try {
            EntityState.get((Object)entity, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPrintSchema() {
        RelationalDatabaseSchema schema = new SchemaBuilderFromEntities(this.lcClient).build(this.getAllCompatibleEntities());
        this.lcClient.getSchemaDialect().createSchemaContent(schema).print(System.out);
    }

    @Test
    public void testSchema() {
        RelationalDatabaseSchema schema = new SchemaBuilderFromEntities(this.lcClient).build(this.getAllCompatibleEntities());
        try {
            schema.getTable("Toto");
            throw new AssertionError();
        }
        catch (NoSuchElementException noSuchElementException) {
            Table table = schema.getTable("basic");
            table.getColumn("str");
            try {
                table.getColumn("toto");
                throw new AssertionError();
            }
            catch (NoSuchElementException noSuchElementException2) {
                return;
            }
        }
    }

    @Test
    public void testInvalidSchemaStatement() {
        SchemaStatement statement = new SchemaStatement("THIS IS INVALID");
        SchemaStatements statements = new SchemaStatements();
        statements.add(statement);
        try {
            statements.execute(this.lcClient).block();
            throw new AssertionError();
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testSchemaDialect() {
        RelationalDatabaseSchema schema = new SchemaBuilderFromEntities(this.lcClient).build(this.getAllCompatibleEntities());
        Table table = schema.getTable("basic");
        Column col = table.getColumn("str");
        try {
            this.lcClient.getSchemaDialect().getColumnType(col, this.getClass(), null);
            throw new AssertionError();
        }
        catch (SchemaException schemaException) {
            return;
        }
    }
}

