/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.util.Pair;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.binding.BindMarker;
import org.springframework.r2dbc.core.binding.BindMarkers;
import org.springframework.r2dbc.core.binding.BindTarget;
import org.springframework.util.Assert;

public class SqlQuery<T> {
    private T query;
    private LcReactiveDataRelationalClient client;
    private BindMarkers markers;
    private List<Pair<BindMarker, Object>> bindings = new LinkedList<Pair<BindMarker, Object>>();

    public SqlQuery(LcReactiveDataRelationalClient client) {
        this.client = client;
        this.markers = client.getDialect().getBindMarkersFactory().create();
    }

    public LcReactiveDataRelationalClient getClient() {
        return this.client;
    }

    public T getQuery() {
        return this.query;
    }

    public void setQuery(T query) {
        this.query = query;
    }

    public Expression marker(Object value) {
        BindMarker marker = this.markers.next();
        this.bindings.add((Pair<BindMarker, Object>)Pair.of((Object)marker, (Object)value));
        return SQL.bindMarker((String)marker.getPlaceholder());
    }

    protected String finalizeQuery(String query) {
        return query;
    }

    public DatabaseClient.GenericExecuteSpec execute() {
        PreparedOperation operation = new PreparedOperation<T>(){

            public T getSource() {
                return SqlQuery.this.query;
            }

            public void bindTo(BindTarget target) {
                for (Pair<BindMarker, Object> binding : SqlQuery.this.bindings) {
                    ((BindMarker)binding.getFirst()).bind(target, binding.getSecond());
                }
            }

            public String toQuery() {
                SqlRenderer renderer;
                Assert.notNull(SqlQuery.this.query, (String)"Query must be set");
                RenderContext renderContext = SqlQuery.this.client.getDataAccess().getStatementMapper().getRenderContext();
                SqlRenderer sqlRenderer = renderer = renderContext != null ? SqlRenderer.create((RenderContext)renderContext) : SqlRenderer.create();
                if (SqlQuery.this.query instanceof Select) {
                    return SqlQuery.this.finalizeQuery(renderer.render((Select)SqlQuery.this.query));
                }
                if (SqlQuery.this.query instanceof Insert) {
                    return SqlQuery.this.finalizeQuery(renderer.render((Insert)SqlQuery.this.query));
                }
                if (SqlQuery.this.query instanceof Update) {
                    return SqlQuery.this.finalizeQuery(renderer.render((Update)SqlQuery.this.query));
                }
                if (SqlQuery.this.query instanceof Delete) {
                    return SqlQuery.this.finalizeQuery(renderer.render((Delete)SqlQuery.this.query));
                }
                throw new IllegalArgumentException("Unexpected query type: " + SqlQuery.this.query.getClass().getName());
            }
        };
        return this.client.getSpringClient().sql((Supplier)operation);
    }
}

