/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.mapping.LcEntityReader;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

public class SelectQuery<T> {
    TableReference from;
    List<TableReference> joins = new LinkedList<TableReference>();
    Map<String, TableReference> tableAliases = new HashMap<String, TableReference>();
    Criteria where = null;
    long offset = 0L;
    long limit = -1L;
    List<Tuple3<String, String, Boolean>> orderBy = new LinkedList<Tuple3<String, String, Boolean>>();

    private SelectQuery(Class<T> type, String alias) {
        this.from = new TableReference(null, null, type, alias);
        this.tableAliases.put(alias, this.from);
    }

    public static <T> SelectQuery<T> from(Class<T> type, String alias) {
        return new SelectQuery<T>(type, alias);
    }

    public SelectQuery<T> join(String entityName, String propertyName, String alias) {
        TableReference source = this.tableAliases.get(entityName);
        TableReference table = new TableReference(source, propertyName, null, alias);
        this.joins.add(table);
        this.tableAliases.put(table.alias, table);
        return this;
    }

    public SelectQuery<T> where(Criteria criteria) {
        this.where = this.where == null ? criteria : this.where.and(criteria);
        return this;
    }

    public SelectQuery<T> limit(long start, long nb) {
        this.offset = start;
        this.limit = nb;
        return this;
    }

    public SelectQuery<T> orderBy(String entityName, String propertyName, boolean ascending) {
        this.orderBy.add((Tuple3<String, String, Boolean>)Tuples.of((Object)entityName, (Object)propertyName, (Object)ascending));
        return this;
    }

    public Flux<T> execute(LcReactiveDataRelationalClient client) {
        return client.execute(this, null);
    }

    public Flux<T> execute(LcReactiveDataRelationalClient client, LcEntityReader reader) {
        return client.execute(this, reader);
    }

    public Mono<Long> executeCount(LcReactiveDataRelationalClient client) {
        return client.executeCount(this);
    }

    void setJoinsTargetType(LcMappingR2dbcConverter mapper) {
        for (int i = 0; i < this.joins.size(); ++i) {
            TableReference join = this.joins.get(i);
            if (join.targetType != null) continue;
            RelationalPersistentEntity joinSourceEntity = (RelationalPersistentEntity)mapper.getMappingContext().getRequiredPersistentEntity(join.source.targetType);
            RelationalPersistentProperty property = (RelationalPersistentProperty)joinSourceEntity.getPersistentProperty(join.propertyName);
            if (property != null) {
                join.targetType = property.getActualType();
                continue;
            }
            LcEntityTypeInfo sourceInfo = LcEntityTypeInfo.get(join.source.targetType);
            Field f = sourceInfo.getForeignTableFieldForProperty(join.propertyName);
            if (f != null) {
                if (ModelUtils.isCollection(f)) {
                    join.targetType = ModelUtils.getCollectionType(f);
                    continue;
                }
                join.targetType = f.getType();
                continue;
            }
            LcEntityTypeInfo.JoinTableInfo joinInfo = sourceInfo.getJoinTable(join.propertyName);
            if (joinInfo != null) {
                TableReference newJoin;
                join.source = newJoin = new TableReference(join.source, joinInfo.getJoinForeignTable().getField().getName(), ModelUtils.getCollectionType(joinInfo.getJoinForeignTable().getField()), join.source.alias + "__join__" + join.alias);
                join.propertyName = joinInfo.getJoinTargetFieldName();
                join.targetType = ModelUtils.getCollectionType(joinInfo.getField());
                this.tableAliases.put(newJoin.alias, newJoin);
                this.joins.add(i, newJoin);
                continue;
            }
            throw new ModelAccessException("Cannot join on property " + join.source.targetType.getSimpleName() + "#" + join.propertyName);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SELECT FROM ").append(this.from.targetType.getSimpleName()).append(" AS ").append(this.from.alias);
        for (TableReference tableReference : this.joins) {
            s.append(" JOIN ");
            if (tableReference.targetType != null) {
                s.append(tableReference.targetType.getSimpleName()).append(" AS ");
            }
            s.append(tableReference.alias);
        }
        if (this.where != null) {
            s.append(" WHERE ").append(this.where.toString());
        }
        if (this.limit > 0L) {
            s.append(" LIMIT ").append(this.offset).append(',').append(this.limit);
        }
        if (!this.orderBy.isEmpty()) {
            s.append(" ORDER BY ");
            for (Tuple3 tuple3 : this.orderBy) {
                s.append((String)tuple3.getT1()).append('.').append((String)tuple3.getT2()).append((Boolean)tuple3.getT3() != false ? " ASC" : " DESC");
            }
        }
        return s.toString();
    }

    static class TableReference {
        TableReference source;
        String propertyName;
        Class<?> targetType;
        String alias;

        private TableReference(TableReference source, String propertyName, Class<?> targetType, String alias) {
            this.source = source;
            this.propertyName = propertyName;
            this.targetType = targetType;
            this.alias = alias;
        }
    }
}

