/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.annotations.JoinTable;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import org.springframework.data.mapping.MappingException;
import org.springframework.lang.Nullable;

public class LcEntityTypeInfo {
    private static final Map<Class<?>, LcEntityTypeInfo> cache = new HashMap();
    private static final String ATTRIBUTE1 = "entity1";
    private static final String ATTRIBUTE2 = "entity2";
    private Class<?> type;
    private Field stateField;
    private Map<String, ForeignTableInfo> foreignTables = new HashMap<String, ForeignTableInfo>();
    private Map<String, JoinTableInfo> joinTables = new HashMap<String, JoinTableInfo>();

    public static void setClasses(Collection<Class<?>> classes) throws ModelException {
        for (Class<?> cl : classes) {
            cache.put(cl, new LcEntityTypeInfo(cl));
        }
    }

    public static LcEntityTypeInfo get(Class<?> clazz) {
        LcEntityTypeInfo info = cache.get(clazz);
        if (info == null) {
            throw new ModelAccessException("Unknown entity class " + clazz.getName() + ", known classes are: " + cache.keySet());
        }
        return info;
    }

    public static Collection<Class<?>> getClasses() {
        return cache.keySet();
    }

    public static Collection<Class<?>> addGeneratedJoinTables(Collection<Class<?>> classes) {
        HashSet result = new HashSet(classes);
        for (Class<?> c : classes) {
            LcEntityTypeInfo info = LcEntityTypeInfo.get(c);
            for (JoinTableInfo joinTable : info.joinTables.values()) {
                Field field = joinTable.joinForeignTable.field;
                Class<?> type = ModelUtils.isCollection(field) ? ModelUtils.getCollectionType(field) : field.getType();
                if (type == null) continue;
                result.add(type);
            }
        }
        return result;
    }

    private LcEntityTypeInfo(Class<?> clazz) throws ModelException {
        this.type = clazz;
        try {
            this.stateField = clazz.getDeclaredField("_lcState");
            this.stateField.setAccessible(true);
        }
        catch (Exception e) {
            throw new ModelException("Unable to access to state field for entity class " + clazz.getName());
        }
        List<Field> fields = ModelUtils.getAllFields(clazz);
        for (Field f : fields) {
            ForeignTable ft = f.getAnnotation(ForeignTable.class);
            if (ft == null) continue;
            this.foreignTables.put(f.getName(), new ForeignTableInfo(f, ft));
            f.setAccessible(true);
        }
        for (Field f : fields) {
            JoinTable jt = f.getAnnotation(JoinTable.class);
            if (jt == null) continue;
            JoinTableInfo info = new JoinTableInfo();
            info.field = f;
            info.annotation = jt;
            info.joinForeignTable = this.foreignTables.get(f.getName() + "_join");
            if (info.joinForeignTable == null) {
                throw new ModelAccessException("@JoinTable without corresponding @ForeignTable");
            }
            if (info.joinForeignTable.annotation.joinKey().equals(ATTRIBUTE1)) {
                info.joinSourceFieldName = ATTRIBUTE1;
                info.joinTargetFieldName = ATTRIBUTE2;
            } else {
                info.joinSourceFieldName = ATTRIBUTE2;
                info.joinTargetFieldName = ATTRIBUTE1;
            }
            this.joinTables.put(f.getName(), info);
            f.setAccessible(true);
        }
    }

    public Field getStateField() {
        return this.stateField;
    }

    @Nullable
    public Field getForeignTableFieldForJoinKey(String joinKey, Class<?> targetType) {
        ForeignTableInfo i = this.getForeignTableWithFieldForJoinKey(joinKey, targetType);
        return i != null ? i.getField() : null;
    }

    public Field getRequiredForeignTableFieldForJoinKey(String joinKey, Class<?> targetType) {
        return this.getRequiredForeignTableWithFieldForJoinKey(joinKey, targetType).getField();
    }

    @Nullable
    public ForeignTableInfo getForeignTableWithFieldForJoinKey(String joinKey, Class<?> targetType) {
        for (Map.Entry<String, ForeignTableInfo> e : this.foreignTables.entrySet()) {
            Field field;
            Class<?> fieldType;
            if (!e.getValue().getAnnotation().joinKey().equals(joinKey) || !targetType.equals(fieldType = ModelUtils.isCollection(field = e.getValue().getField()) ? ModelUtils.getCollectionType(field) : field.getType())) continue;
            return e.getValue();
        }
        return null;
    }

    private String missingForeignTable(String expected, String expectedOn) {
        return "Missing @ForeignTable " + expected + " '" + expectedOn + "' in class '" + this.type.getSimpleName() + "'";
    }

    public ForeignTableInfo getRequiredForeignTableWithFieldForJoinKey(String joinKey, Class<?> targetType) {
        ForeignTableInfo i = this.getForeignTableWithFieldForJoinKey(joinKey, targetType);
        if (i == null) {
            throw new MappingException(this.missingForeignTable("field with join key", joinKey));
        }
        return i;
    }

    @Nullable
    public Field getForeignTableFieldForProperty(String propertyName) {
        ForeignTableInfo i = this.foreignTables.get(propertyName);
        return i != null ? i.getField() : null;
    }

    public Field getRequiredForeignTableFieldForProperty(String propertyName) {
        ForeignTableInfo i = this.foreignTables.get(propertyName);
        if (i == null) {
            throw new MappingException(this.missingForeignTable("on property", propertyName));
        }
        return i.getField();
    }

    @Nullable
    public ForeignTable getForeignTableForProperty(String propertyName) {
        ForeignTableInfo i = this.foreignTables.get(propertyName);
        return i != null ? i.getAnnotation() : null;
    }

    public ForeignTable getRequiredForeignTableForProperty(String propertyName) {
        ForeignTableInfo i = this.foreignTables.get(propertyName);
        if (i == null) {
            throw new MappingException(this.missingForeignTable("on property", propertyName));
        }
        return i.getAnnotation();
    }

    public static boolean isForeignTableField(Field field) {
        LcEntityTypeInfo ti = cache.get(field.getDeclaringClass());
        if (ti == null) {
            return false;
        }
        for (ForeignTableInfo i : ti.foreignTables.values()) {
            if (!i.getField().equals(field)) continue;
            return true;
        }
        return false;
    }

    public Collection<ForeignTableInfo> getForeignTables() {
        return this.foreignTables.values();
    }

    @Nullable
    public JoinTableInfo getJoinTable(String propertyName) {
        return this.joinTables.get(propertyName);
    }

    public Collection<JoinTableInfo> getJoinTables() {
        return this.joinTables.values();
    }

    public <T> Collection<T> getJoinTableElementsForJoinTableClass(Object instance, Class<T> joinTableClass) {
        for (JoinTableInfo jti : this.joinTables.values()) {
            if (!ModelUtils.getCollectionType(jti.joinForeignTable.field).equals(joinTableClass)) continue;
            try {
                return (Collection)jti.joinForeignTable.field.get(instance);
            }
            catch (Exception e) {
                throw new ModelAccessException("Error accessing join table elements " + joinTableClass.getName() + " from " + instance, e);
            }
        }
        return null;
    }

    public static class JoinTableInfo {
        private Field field;
        private JoinTable annotation;
        private ForeignTableInfo joinForeignTable;
        private String joinSourceFieldName;
        private String joinTargetFieldName;

        public Field getField() {
            return this.field;
        }

        public JoinTable getAnnotation() {
            return this.annotation;
        }

        public ForeignTableInfo getJoinForeignTable() {
            return this.joinForeignTable;
        }

        public String getJoinSourceFieldName() {
            return this.joinSourceFieldName;
        }

        public String getJoinTargetFieldName() {
            return this.joinTargetFieldName;
        }
    }

    public static class ForeignTableInfo {
        private Field field;
        private ForeignTable annotation;

        private ForeignTableInfo(Field field, ForeignTable annotation) {
            this.field = field;
            this.annotation = annotation;
        }

        public Field getField() {
            return this.field;
        }

        public ForeignTable getAnnotation() {
            return this.annotation;
        }
    }
}

