/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.configuration;

import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.mapping.LcReactiveDataAccessStrategy;
import net.lecousin.reactive.data.relational.repository.LcR2dbcEntityTemplate;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.dialect.DialectResolver;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.R2dbcMappingContext;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.r2dbc.core.DatabaseClient;

public abstract class LcR2dbcEntityOperationsBuilder {
    protected LcR2dbcEntityTemplate buildEntityOperations(ConnectionFactory connectionFactory) {
        R2dbcDialect dialect = this.getDialect(connectionFactory);
        R2dbcCustomConversions customConversions = this.buildR2dbcCustomConversions(dialect);
        R2dbcMappingContext mappingContext = this.buildMappingContext();
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        LcMappingR2dbcConverter converter = new LcMappingR2dbcConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, (CustomConversions)customConversions);
        LcReactiveDataAccessStrategy dataAccessStrategy = new LcReactiveDataAccessStrategy(dialect, converter);
        DatabaseClient client = this.buildDatabaseClient(connectionFactory, dialect);
        LcReactiveDataRelationalClient lcClient = new LcReactiveDataRelationalClient(client, (MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, this.getLcDialect(dialect), dataAccessStrategy, converter);
        return new LcR2dbcEntityTemplate(lcClient);
    }

    protected R2dbcDialect getDialect(ConnectionFactory connectionFactory) {
        return DialectResolver.getDialect((ConnectionFactory)connectionFactory);
    }

    protected RelationalDatabaseSchemaDialect getLcDialect(R2dbcDialect dialect) {
        return RelationalDatabaseSchemaDialect.getDialect(dialect);
    }

    protected R2dbcMappingContext buildMappingContext() {
        return new R2dbcMappingContext(NamingStrategy.INSTANCE);
    }

    protected R2dbcCustomConversions buildR2dbcCustomConversions(R2dbcDialect dialect) {
        return new R2dbcCustomConversions(this.getStoreConversions(dialect), this.getCustomConverters());
    }

    protected List<Object> getCustomConverters() {
        return Collections.emptyList();
    }

    protected CustomConversions.StoreConversions getStoreConversions(R2dbcDialect dialect) {
        ArrayList converters = new ArrayList(dialect.getConverters());
        converters.addAll(R2dbcCustomConversions.STORE_CONVERTERS);
        return CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), converters);
    }

    protected DatabaseClient buildDatabaseClient(ConnectionFactory connectionFactory, R2dbcDialect dialect) {
        return DatabaseClient.builder().connectionFactory(connectionFactory).bindMarkers(dialect.getBindMarkersFactory()).build();
    }
}

