/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.tests;

import java.lang.reflect.Field;
import java.util.Arrays;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.data.mapping.MappingException;

class TestModelErrors {
    TestModelErrors() {
    }

    @Test
    void test() throws Exception {
        Assertions.assertThrows(ModelAccessException.class, () -> LcEntityTypeInfo.get(this.getClass()));
        Assertions.assertThrows(ModelException.class, () -> LcEntityTypeInfo.setClasses(Arrays.asList(this.getClass())));
        LcEntityTypeInfo.setClasses(Arrays.asList(NonEnhancedEntity.class));
        LcEntityTypeInfo ti = LcEntityTypeInfo.get(NonEnhancedEntity.class);
        Assertions.assertThrows(MappingException.class, () -> ti.getRequiredForeignTableFieldForJoinKey("test", this.getClass()));
        Assertions.assertThrows(MappingException.class, () -> ti.getRequiredForeignTableFieldForProperty("test"));
        Assertions.assertThrows(MappingException.class, () -> ti.getRequiredForeignTableForProperty("test"));
        Assertions.assertNull((Object)ti.getForeignTableFieldForJoinKey("test", this.getClass()));
        Assertions.assertNull((Object)ti.getForeignTableFieldForProperty("test"));
        Assertions.assertNull((Object)ti.getForeignTableForProperty("test"));
        Assertions.assertNull((Object)ti.getJoinTable("test"));
        Assertions.assertNull((Object)ti.getJoinTableElementsForJoinTableClass((Object)"test", this.getClass()));
        Assertions.assertNull((Object)ModelUtils.getAsCollection((Object)this));
        Assertions.assertNull((Object)ModelUtils.getCollectionType((Field)NonEnhancedEntity.class.getDeclaredField("_lcState")));
        Assertions.assertThrows(MappingException.class, () -> ModelUtils.getRequiredCollectionType((Field)NonEnhancedEntity.class.getDeclaredField("_lcState")));
    }

    public static class NonEnhancedEntity {
        private EntityState _lcState;
    }
}

