/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.enhance;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.data.relational.core.mapping.Table;

public class ClassPathScanningEntities {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathScanningEntities.class);

    private ClassPathScanningEntities() {
    }

    public static Set<String> scan() throws IOException {
        long startTime = System.currentTimeMillis();
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        Resource[] classResources = resourceResolver.getResources("classpath*:**/*.class");
        SimpleMetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();
        String annotationName = Table.class.getName();
        HashSet<String> classes = new HashSet<String>();
        for (Resource classResource : classResources) {
            try {
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(classResource);
                AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
                if (!annotationMetadata.hasAnnotation(annotationName)) continue;
                classes.add(annotationMetadata.getClassName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        LOGGER.info("{} entity classes found in {} ms.", (Object)classes.size(), (Object)(System.currentTimeMillis() - startTime));
        return classes;
    }
}

