/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.onetoonemodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity1;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity1Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity2;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity2Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity3;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity3Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity1;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity2;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractTestOneToOneModel
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private MyEntity1Repository repo1;
    @Autowired
    private MyEntity2Repository repo2;
    @Autowired
    private MyEntity3Repository repo3;

    @Override
    protected Collection<Class<?>> usedEntities() {
        return Arrays.asList(MyEntity1.class, MyEntity2.class, MyEntity3.class, MySubEntity1.class, MySubEntity2.class, MySubEntity3.class);
    }

    @Test
    public void testEntity1WithoutSubEntity() {
        MyEntity1 entity = new MyEntity1();
        entity.setValue("test");
        this.repo1.save(entity).block();
        List list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        entity.setValue("modified");
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"modified", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        Assertions.assertNull((Object)entity.lazyGetSubEntity().block());
        Assertions.assertNull((Object)entity.lazyGetSubEntity().block());
        this.repo1.deleteAll(list).block();
        Assertions.assertEquals((int)0, (int)((List)this.repo1.findAll().collectList().block()).size());
    }

    @Test
    public void testEntity1WithSubEntity() {
        MyEntity1 entity = new MyEntity1();
        entity.setValue("test");
        MySubEntity1 subEntity = new MySubEntity1();
        subEntity.setSubValue("sub test");
        entity.setSubEntity(subEntity);
        subEntity.setParent(entity);
        this.repo1.save(entity).block();
        List list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertTrue((subEntity == entity.lazyGetSubEntity().block() ? 1 : 0) != 0);
        list = (List)this.repo1.findByValue("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo1.findByValue("test").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        entity.setValue("test 2");
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        subEntity.setSubValue("sub test 2");
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test 2", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test 2", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        subEntity = new MySubEntity1();
        subEntity.setSubValue("new one");
        entity.setSubEntity(subEntity);
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"new one", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"new one", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo1.delete(entity).block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MyEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MySubEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testEntity2WithoutSubEntity() {
        MyEntity2 entity = new MyEntity2();
        entity.setValue("test");
        this.repo2.save(entity).block();
        List list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        entity.setValue("modified");
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"modified", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        this.repo2.deleteAll(list).block();
        Assertions.assertEquals((int)0, (int)((List)this.repo2.findAll().collectList().block()).size());
    }

    @Test
    public void testEntity2WithSubEntity() {
        MyEntity2 entity = new MyEntity2();
        entity.setValue("test");
        MySubEntity2 subEntity = new MySubEntity2();
        subEntity.setSubValue("sub test");
        entity.setSubEntity(subEntity);
        subEntity.setParent(entity);
        this.repo2.save(entity).block();
        List list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertNull((Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)((MySubEntity2)entity.lazyGetSubEntity().block()).getSubValue());
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertNull((Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().lazyGetSubValue().block());
        entity.setValue("test 2");
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        entity.getSubEntity().setSubValue("sub test 2");
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"sub test 2", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        subEntity = new MySubEntity2();
        subEntity.setSubValue("new one");
        entity.setSubEntity(subEntity);
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"new one", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo2.delete(entity).block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MyEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MySubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testEntity3WithSubEntity() {
        MyEntity3 entity = new MyEntity3();
        entity.setValue("test");
        MySubEntity3 subEntity = new MySubEntity3();
        subEntity.setSubValue("sub test");
        entity.setSubEntity(subEntity);
        subEntity.setParent(entity);
        this.repo3.save(entity).block();
        List list = (List)this.repo3.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity3)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        entity.lazyGetSubEntity().block();
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        this.repo3.delete(entity).block();
        list = (List)SelectQuery.from(MyEntity3.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        List subList = (List)SelectQuery.from(MySubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)subList.size());
        Assertions.assertNull((Object)((MySubEntity3)subList.get(0)).getParent());
        entity = new MyEntity3();
        entity.setValue("second");
        entity.setSubEntity((MySubEntity3)subList.get(0));
        ((MySubEntity3)subList.get(0)).setParent(entity);
        this.repo3.save(entity).block();
        list = (List)this.repo3.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertNull((Object)((MyEntity3)list.get(0)).getSubEntity());
        Assertions.assertNotNull((Object)((MyEntity3)list.get(0)).lazyGetSubEntity().block());
        Assertions.assertNotNull((Object)((MyEntity3)list.get(0)).getSubEntity());
        subList = (List)SelectQuery.from(MySubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)subList.size());
        Assertions.assertEquals((Long)((MySubEntity3)subList.get(0)).getId(), (Long)((MyEntity3)list.get(0)).getSubEntity().getId());
    }
}

