/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcEntityReader;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.PropertiesSource;
import net.lecousin.reactive.data.relational.model.PropertiesSourceMap;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.criteria.CriteriaSqlBuilder;
import net.lecousin.reactive.data.relational.query.criteria.CriteriaVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class SelectExecution<T> {
    private static final Log logger = LogFactory.getLog(SelectExecution.class);
    private SelectQuery<T> query;
    private LcReactiveDataRelationalClient client;
    private LcEntityReader reader;
    private T currentRoot = null;
    private Object currentRootId = null;

    public SelectExecution(SelectQuery<T> query, LcReactiveDataRelationalClient client, @Nullable LcEntityReader reader) {
        this.query = query;
        this.client = client;
        this.reader = reader != null ? reader : new LcEntityReader(null, client.getMapper());
    }

    public Flux<T> execute() {
        return Mono.fromCallable(this::needsPreSelectIds).flatMapMany(needsPreSelect -> needsPreSelect != false ? this.executeWithPreSelect() : this.executeWithoutPreSelect()).checkpoint(this.query.toString());
    }

    private boolean needsPreSelectIds() {
        this.query.setJoinsTargetType(this.client.getMapper());
        if (!this.hasJoinMany()) {
            return false;
        }
        if (this.query.limit > 0L) {
            return true;
        }
        return this.hasConditionOnManyEntity();
    }

    private boolean hasJoinMany() {
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.isMany(join)) continue;
            return true;
        }
        return false;
    }

    private boolean isMany(SelectQuery.TableReference table) {
        if (table.source == null) {
            return false;
        }
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(table.source.targetType);
        try {
            Field field = entity.getType().getDeclaredField(table.propertyName);
            return ModelUtils.isCollection(field);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isManyFromRoot(SelectQuery.TableReference table) {
        while (table.source != null) {
            if (this.isMany(table)) {
                return true;
            }
            table = table.source;
        }
        return false;
    }

    private boolean hasConditionOnManyEntity() {
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference table = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (SelectExecution.this.isManyFromRoot(table)) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && SelectExecution.this.isManyFromRoot(table = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private static boolean isSourceFor(SelectQuery.TableReference t1, SelectQuery.TableReference t2) {
        while (t2 != null) {
            if (t1 == t2) {
                return true;
            }
            t2 = t2.source;
        }
        return false;
    }

    private boolean needsTableForPreSelect(final SelectQuery.TableReference table) {
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference t = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (SelectExecution.isSourceFor(table, t)) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && SelectExecution.isSourceFor(table, t = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private Flux<T> executeWithPreSelect() {
        SelectMapping mapping = this.buildSelectMapping();
        return this.buildDistinctRootIdSql(mapping).execute().fetch().all().map(row -> row.values().iterator().next()).buffer(100).flatMap(ids -> {
            String idPropertyName = ((RelationalPersistentProperty)mapping.entitiesByAlias.get(this.query.from.alias).getIdProperty()).getName();
            Flux fromDb = this.buildFinalSql(mapping, Criteria.property(this.query.from.alias, idPropertyName).in((Collection<?>)ids), false).execute().fetch().all();
            return Flux.create(sink -> fromDb.doOnComplete(() -> this.handleRow(null, (FluxSink<T>)sink, mapping)).subscribe(row -> this.handleRow((Map<String, Object>)row, (FluxSink<T>)sink, mapping))).collectList().flatMapMany(list -> {
                ArrayList orderedList = new ArrayList(list.size());
                ArrayList rawList = new ArrayList(list);
                RelationalPersistentEntity<?> entityType = mapping.entitiesByAlias.get(this.query.from.alias);
                block0: for (Object id : ids) {
                    Iterator it = rawList.iterator();
                    while (it.hasNext()) {
                        Object entity = it.next();
                        Object entityId = ModelUtils.getRequiredId(entity, entityType, null);
                        if (!entityId.equals(id)) continue;
                        it.remove();
                        orderedList.add(entity);
                        continue block0;
                    }
                }
                return Flux.fromIterable(orderedList);
            });
        });
    }

    private Flux<T> executeWithoutPreSelect() {
        SelectMapping mapping = this.buildSelectMapping();
        Flux fromDb = this.buildFinalSql(mapping, this.query.where, true).execute().fetch().all();
        return Flux.create(sink -> fromDb.doOnComplete(() -> this.handleRow(null, (FluxSink<T>)sink, mapping)).subscribe(row -> this.handleRow((Map<String, Object>)row, (FluxSink<T>)sink, mapping)));
    }

    private SelectMapping buildSelectMapping() {
        SelectMapping mapping = new SelectMapping();
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        HashMap<String, String> fieldAliases = new HashMap<String, String>();
        mapping.fieldAliasesByTableAlias.put(this.query.from.alias, fieldAliases);
        mapping.entitiesByAlias.put(this.query.from.alias, entity);
        mapping.tableByAlias.put(this.query.from.alias, Table.create((SqlIdentifier)entity.getTableName()).as(this.query.from.alias));
        for (RelationalPersistentProperty property : entity) {
            String alias = mapping.generateAlias();
            mapping.fields.add(new SelectField(this.query.from.alias, property, alias));
            fieldAliases.put(property.getName(), alias);
        }
        for (SelectQuery.TableReference join : this.query.joins) {
            RelationalPersistentEntity joinEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(join.targetType);
            fieldAliases = new HashMap();
            mapping.fieldAliasesByTableAlias.put(join.alias, fieldAliases);
            mapping.entitiesByAlias.put(join.alias, joinEntity);
            mapping.tableByAlias.put(join.alias, Table.create((SqlIdentifier)joinEntity.getTableName()).as(join.alias));
            for (RelationalPersistentProperty property : joinEntity) {
                String alias = mapping.generateAlias();
                mapping.fields.add(new SelectField(join.alias, property, alias));
                fieldAliases.put(property.getName(), alias);
            }
        }
        return mapping;
    }

    private SqlQuery<Select> buildFinalSql(SelectMapping mapping, Criteria criteria, boolean applyLimitAndOrderBy) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        ArrayList<Column> selectFields = new ArrayList<Column>(mapping.fields.size());
        for (SelectField selectField : mapping.fields) {
            selectFields.add(selectField.toSql());
        }
        SelectBuilder.SelectFromAndJoin select = Select.builder().select(selectFields).from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        if (applyLimitAndOrderBy) {
            select = this.addLimit((SelectBuilder.BuildSelect)select);
            select = this.addOrderBy((SelectBuilder.BuildSelect)select);
        }
        for (SelectQuery.TableReference join : this.query.joins) {
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> sqlQuery = new SqlQuery<Select>(this.client);
        if (criteria != null) {
            select = ((SelectBuilder.SelectWhere)select).where(criteria.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, sqlQuery)));
        }
        if (entity.hasIdProperty()) {
            select = ((SelectBuilder.SelectOrdered)select).orderBy(new Column[]{Column.aliased((String)((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName(), (Table)mapping.tableByAlias.get(this.query.from.alias), (String)mapping.fieldAliasesByTableAlias.get(this.query.from.alias).get(((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName()))});
        }
        sqlQuery.setQuery(select.build());
        return sqlQuery;
    }

    private SelectBuilder.BuildSelect addLimit(SelectBuilder.BuildSelect select) {
        if (this.query.limit > 0L) {
            return ((SelectBuilder.SelectFromAndJoin)select).limitOffset(this.query.limit, this.query.offset);
        }
        return select;
    }

    private SelectBuilder.BuildSelect addOrderBy(SelectBuilder.BuildSelect select) {
        if (!this.query.orderBy.isEmpty()) {
            ArrayList<OrderByField> list = new ArrayList<OrderByField>(this.query.orderBy.size());
            for (Tuple2<String, Boolean> orderBy : this.query.orderBy) {
                RelationalPersistentEntity e = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
                RelationalPersistentProperty p = (RelationalPersistentProperty)e.getRequiredPersistentProperty((String)orderBy.getT1());
                OrderByField o = OrderByField.from((Column)Column.create((SqlIdentifier)p.getColumnName(), (Table)Table.create((SqlIdentifier)e.getTableName()).as(this.query.from.alias)), (Sort.Direction)((Boolean)orderBy.getT2() != false ? Sort.Direction.ASC : Sort.Direction.DESC));
                list.add(o);
            }
            return ((SelectBuilder.SelectFromAndOrderBy)select).orderBy(list);
        }
        return select;
    }

    private SqlQuery<Select> buildDistinctRootIdSql(SelectMapping mapping) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        SelectBuilder.SelectFromAndJoin select = Select.builder().select((Expression)Column.create((SqlIdentifier)entity.getIdColumn(), (Table)mapping.tableByAlias.get(this.query.from.alias))).distinct().from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        select = this.addLimit((SelectBuilder.BuildSelect)select);
        select = this.addOrderBy((SelectBuilder.BuildSelect)select);
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.needsTableForPreSelect(join)) continue;
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> q = new SqlQuery<Select>(this.client);
        if (this.query.where != null) {
            select = ((SelectBuilder.SelectWhere)select).where(this.query.where.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, q)));
        }
        q.setQuery(select.build());
        return q;
    }

    private SelectBuilder.BuildSelect join(SelectBuilder.BuildSelect select, SelectQuery.TableReference join, SelectMapping mapping) {
        RelationalPersistentEntity sourceEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(join.source.targetType);
        RelationalPersistentEntity targetEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(join.targetType);
        RelationalPersistentProperty property = (RelationalPersistentProperty)sourceEntity.getPersistentProperty(join.propertyName);
        if (property != null) {
            Table joinTargetTable = mapping.tableByAlias.get(join.alias);
            Column joinTarget = Column.create((SqlIdentifier)targetEntity.getIdColumn(), (Table)joinTargetTable);
            Table joinSourceTable = mapping.tableByAlias.get(join.source.alias);
            Column joinSource = Column.create((SqlIdentifier)property.getColumnName(), (Table)joinSourceTable);
            return ((SelectBuilder.SelectJoin)select).leftOuterJoin((TableLike)joinTargetTable).on((Expression)joinTarget).equals((Expression)joinSource);
        }
        ForeignTable ft = LcEntityTypeInfo.get(join.source.targetType).getRequiredForeignTableForProperty(join.propertyName);
        property = (RelationalPersistentProperty)targetEntity.getRequiredPersistentProperty(ft.joinKey());
        Table joinTargetTable = mapping.tableByAlias.get(join.alias);
        Column joinTarget = Column.create((SqlIdentifier)property.getColumnName(), (Table)joinTargetTable);
        Table joinSourceTable = mapping.tableByAlias.get(join.source.alias);
        Column joinSource = Column.create((SqlIdentifier)sourceEntity.getIdColumn(), (Table)joinSourceTable);
        return ((SelectBuilder.SelectJoin)select).leftOuterJoin((TableLike)joinTargetTable).on((Expression)joinTarget).equals((Expression)joinSource);
    }

    private void handleRow(Map<String, Object> row, FluxSink<T> sink, SelectMapping mapping) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result row = " + row));
        }
        if (row == null) {
            if (this.currentRoot != null) {
                this.endOfRoot();
                sink.next(this.currentRoot);
            }
            sink.complete();
            return;
        }
        RelationalPersistentEntity rootEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(this.query.from.targetType);
        PropertiesSourceMap source = new PropertiesSourceMap(row, mapping.fieldAliasesByTableAlias.get(this.query.from.alias));
        Object rootId = ModelUtils.getId(rootEntity, source);
        if (this.currentRoot != null) {
            if (rootId != null && !this.currentRootId.equals(rootId)) {
                this.endOfRoot();
                sink.next(this.currentRoot);
                this.currentRoot = this.reader.read(this.query.from.targetType, (PropertiesSource)source);
                this.currentRootId = rootId;
            }
        } else {
            this.currentRoot = this.reader.read(this.query.from.targetType, (PropertiesSource)source);
            this.currentRootId = rootId;
        }
        this.fillLinkedEntities(this.currentRoot, EntityState.get(this.currentRoot, this.client, rootEntity), this.query.from, row, mapping, this.reader);
    }

    private void fillLinkedEntities(Object parent, EntityState parentState, SelectQuery.TableReference parentTable, Map<String, Object> row, SelectMapping mapping, LcEntityReader reader) {
        for (SelectQuery.TableReference join : this.query.joins) {
            if (join.source != parentTable) continue;
            try {
                this.fillLinkedEntity(join, parent, parentState, row, mapping, reader);
            }
            catch (Exception e) {
                throw new MappingException("Error mapping result for entity " + join.targetType.getName(), (Throwable)e);
            }
        }
    }

    private <J> void fillLinkedEntity(SelectQuery.TableReference join, Object parent, EntityState parentState, Map<String, Object> row, SelectMapping mapping, LcEntityReader reader) throws ReflectiveOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read join " + join.targetType.getSimpleName() + " as " + join.alias + " from " + parent.getClass().getSimpleName()));
        }
        Field field = parent.getClass().getDeclaredField(join.propertyName);
        field.setAccessible(true);
        boolean isCollection = ModelUtils.isCollection(field);
        Class<?> type = isCollection ? ModelUtils.getRequiredCollectionType(field) : field.getType();
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(type);
        PropertiesSourceMap source = new PropertiesSourceMap(row, mapping.fieldAliasesByTableAlias.get(join.alias));
        Object id = ModelUtils.getId(entity, source);
        if (id == null) {
            if (isCollection) {
                field.set(parent, CollectionFactory.createCollection(field.getType(), ModelUtils.getCollectionType(field), (int)0));
            }
            return;
        }
        Object instance = reader.read(join.targetType, (PropertiesSource)source);
        if (isCollection) {
            ModelUtils.addToCollectionField(field, parent, instance);
        } else if (LcEntityTypeInfo.isForeignTableField(field)) {
            parentState.setForeignTableField(parent, field, instance, true);
        } else {
            parentState.setPersistedField(parent, field, instance, true);
        }
        this.fillLinkedEntities(instance, EntityState.get(instance, this.client, entity), join, row, mapping, reader);
    }

    private void endOfRoot() {
        this.signalLoadedForeignTables(this.currentRoot, this.query.from);
    }

    private void signalLoadedForeignTables(Object parent, SelectQuery.TableReference parentTable) {
        for (SelectQuery.TableReference join : this.query.joins) {
            if (join.source != parentTable) continue;
            try {
                this.signalLoadedForeignTable(parent, join);
            }
            catch (Exception e) {
                throw new MappingException("Error mapping result for entity " + join.targetType.getName(), (Throwable)e);
            }
        }
    }

    private void signalLoadedForeignTable(Object parent, SelectQuery.TableReference join) throws ReflectiveOperationException {
        Field field = parent.getClass().getDeclaredField(join.propertyName);
        field.setAccessible(true);
        Object instance = field.get(parent);
        if (field.isAnnotationPresent(ForeignTable.class)) {
            EntityState.get(parent, this.client).foreignTableLoaded(field, instance);
        }
        if (instance != null) {
            boolean isCollection = ModelUtils.isCollection(field);
            if (isCollection) {
                for (Object element : ModelUtils.getAsCollection(instance)) {
                    this.signalLoadedForeignTables(element, join);
                }
            } else {
                this.signalLoadedForeignTables(instance, join);
            }
        }
    }

    private static class SelectField {
        private String tableAlias;
        private RelationalPersistentProperty property;
        private String fieldAlias;

        public SelectField(String tableAlias, RelationalPersistentProperty property, String fieldAlias) {
            this.tableAlias = tableAlias;
            this.property = property;
            this.fieldAlias = fieldAlias;
        }

        public Column toSql() {
            return Column.create((SqlIdentifier)this.property.getColumnName(), (Table)Table.create((SqlIdentifier)this.property.getOwner().getTableName()).as(this.tableAlias)).as(this.fieldAlias);
        }
    }

    private static class SelectMapping {
        private Map<String, RelationalPersistentEntity<?>> entitiesByAlias = new HashMap();
        private Map<String, Table> tableByAlias = new HashMap<String, Table>();
        private Map<String, Map<String, String>> fieldAliasesByTableAlias = new HashMap<String, Map<String, String>>();
        private List<SelectField> fields = new LinkedList<SelectField>();
        private int aliasCounter = 0;

        private SelectMapping() {
        }

        private String generateAlias() {
            int num = this.aliasCounter++;
            return "f" + StringUtils.leftPad((String)Integer.toString(num), (int)4, (char)'0');
        }
    }
}

