/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.enhance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.annotations.JoinTable;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

public final class Enhancer {
    private static final Log logger = LogFactory.getLog(Enhancer.class);
    public static final String STATE_FIELD_NAME = "_lcState";
    public static final String JOIN_TABLE_ATTRIBUTE_PREFIX = "entity";
    private static final String DEFAULT_VALUE_ANNOTATION_ATTRIBUTE = "value";
    private ClassPool classPool;
    private Map<String, CtClass> classes;
    private Map<CtClass, Map<String, JoinTableInfo>> joinTableFields = new HashMap<CtClass, Map<String, JoinTableInfo>>();

    private Enhancer() {
        this.classPool = ClassPool.getDefault();
    }

    public static void enhance(Collection<String> entityClasses) throws ModelException {
        new Enhancer().enhanceClasses(entityClasses);
    }

    private void enhanceClasses(Collection<String> entityClasses) throws ModelException {
        logger.info((Object)("Enhancing " + entityClasses.size() + " entity classes"));
        this.loadClasses(entityClasses);
        this.processJoinTables();
        this.addStateAttribute();
        this.enhancePersistentFields();
        this.enhanceLazyMethods();
        for (Map.Entry<CtClass, Map<String, JoinTableInfo>> classEntry : this.joinTableFields.entrySet()) {
            for (Map.Entry<String, JoinTableInfo> propertyEntry : classEntry.getValue().entrySet()) {
                try {
                    Enhancer.processJoinTableAccessors(classEntry.getKey(), propertyEntry.getKey(), propertyEntry.getValue());
                }
                catch (Exception e) {
                    throw new ModelException("Error enhancing join table accessors for " + classEntry.getKey().getName() + "#" + propertyEntry.getKey(), e);
                }
            }
        }
        ArrayList result = new ArrayList(this.classes.size());
        for (CtClass cl : this.classes.values()) {
            try {
                Class<?> neighbor = null;
                try {
                    neighbor = Enhancer.class.getClassLoader().loadClass(cl.getPackageName() + ".package-info");
                }
                catch (Exception e) {
                    // empty catch block
                }
                Class newClass = neighbor != null ? cl.toClass(neighbor) : cl.toClass();
                result.add(newClass);
            }
            catch (Exception e) {
                throw new ModelException("Unable to load enhanced class " + cl.getName() + " into JVM", e);
            }
        }
        LcEntityTypeInfo.setClasses(result);
    }

    private void loadClasses(Collection<String> entityClasses) throws ModelException {
        this.classes = new HashMap<String, CtClass>();
        for (String className : entityClasses) {
            try {
                CtClass cl = this.classPool.get(className);
                if (!cl.hasAnnotation(Table.class)) {
                    throw new ModelException("Class is not an entity (no @Table annotation): " + className);
                }
                if (Enhancer.hasField(cl, STATE_FIELD_NAME)) {
                    logger.warn((Object)("Entity already enhanced: " + className));
                    return;
                }
                cl.defrost();
                this.classes.put(className, cl);
            }
            catch (ModelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException("Error loading class " + className, e);
            }
        }
    }

    private static boolean isPersistent(CtField field) {
        if (field.hasAnnotation(Transient.class) || field.hasAnnotation(Autowired.class) || field.hasAnnotation(Value.class)) {
            return false;
        }
        return field.hasAnnotation(Id.class) || field.hasAnnotation(Column.class) || field.hasAnnotation(ColumnDefinition.class) || field.hasAnnotation(Version.class) || field.hasAnnotation(ForeignKey.class);
    }

    private static boolean hasField(CtClass cl, String name) {
        try {
            cl.getDeclaredField(name);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private void addStateAttribute() throws ModelException {
        for (CtClass cl : this.classes.values()) {
            try {
                this.addStateAttribute(cl);
            }
            catch (Exception e) {
                throw new ModelException("Unable to add state attribute to class " + cl.getName(), e);
            }
        }
    }

    private void addStateAttribute(CtClass cl) throws CannotCompileException, NotFoundException {
        CtField f = new CtField(this.classPool.get("net.lecousin.reactive.data.relational.enhance.EntityState"), STATE_FIELD_NAME, cl);
        cl.addField(f);
        ConstPool cpool = cl.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(cpool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation(Transient.class.getName(), cpool);
        attr.addAnnotation(annot);
        f.getFieldInfo().addAttribute((AttributeInfo)attr);
    }

    private void enhancePersistentFields() throws ModelException {
        for (CtClass cl : this.classes.values()) {
            try {
                Enhancer.enhancePersistentFields(cl);
            }
            catch (Exception e) {
                throw new ModelException("Error enhancing entity class " + cl.getName(), e);
            }
        }
    }

    private static void enhancePersistentFields(CtClass cl) throws CannotCompileException {
        for (CtField field : cl.getDeclaredFields()) {
            if (!Enhancer.isPersistent(field)) continue;
            String accessorSuffix = Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
            try {
                CtMethod accessor = cl.getDeclaredMethod("set" + accessorSuffix);
                Enhancer.enhanceSetter(field, accessor);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private static void enhanceSetter(CtField field, CtMethod setter) throws CannotCompileException {
        setter.insertBefore("if ($0._lcState != null) { $0._lcState.fieldSet(\"" + field.getName() + "\", $1); }");
    }

    private void processJoinTables() throws ModelException {
        LinkedList<Tuple4<CtClass, CtField, JoinTable, CtClass>> joins = new LinkedList<Tuple4<CtClass, CtField, JoinTable, CtClass>>();
        CtClass clSet = null;
        try {
            clSet = this.classPool.get(Set.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (CtClass cl : this.classes.values()) {
            for (CtField field : cl.getDeclaredFields()) {
                if (!field.hasAnnotation(JoinTable.class)) continue;
                try {
                    JoinTable jt = (JoinTable)field.getAnnotation(JoinTable.class);
                    CtClass type = field.getType();
                    if (!type.subtypeOf(clSet)) {
                        throw new ModelException("Attribute " + cl.getName() + "#" + field.getName() + " annotated with @JoinTable must be a Set");
                    }
                    SignatureAttribute.ObjectType ot = SignatureAttribute.toFieldSignature((String)field.getGenericSignature());
                    if (!(ot instanceof SignatureAttribute.ClassType)) {
                        throw new ModelException("Unexpected type " + ot + " for @JoinTable field, must be a Set with specified type: " + cl.getName() + "#" + field.getName());
                    }
                    SignatureAttribute.ClassType ct = (SignatureAttribute.ClassType)ot;
                    if (ct.getTypeArguments().length != 1) {
                        throw new ModelException("Unexpected type for @JoinTable field, must be a Set with 1 type argument: " + cl.getName() + "#" + field.getName());
                    }
                    ot = ct.getTypeArguments()[0].getType();
                    if (!(ot instanceof SignatureAttribute.ClassType)) {
                        throw new ModelException("Unexpected collection element type " + ot + " for @JoinTable field: " + cl.getName() + "#" + field.getName());
                    }
                    ct = (SignatureAttribute.ClassType)ot;
                    CtClass target = this.classes.get(ct.getName());
                    if (target == null) {
                        throw new ModelException("Unexpected collection element type " + ot + " for @JoinTable field: " + cl.getName() + "#" + field.getName());
                    }
                    joins.add((Tuple4<CtClass, CtField, JoinTable, CtClass>)Tuples.of((Object)cl, (Object)field, (Object)jt, (Object)target));
                }
                catch (ModelException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ModelException("Error getting @JoinTable field info for " + cl.getName() + "#" + field.getName(), e);
                }
            }
        }
        while (!joins.isEmpty()) {
            Tuple4 t = (Tuple4)joins.removeFirst();
            try {
                this.createJoinTable((Tuple4<CtClass, CtField, JoinTable, CtClass>)t, joins);
            }
            catch (ModelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException("Error generating join table entity from " + ((CtClass)t.getT1()).getName() + "#" + ((CtField)t.getT2()).getName(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createJoinTable(Tuple4<CtClass, CtField, JoinTable, CtClass> t, LinkedList<Tuple4<CtClass, CtField, JoinTable, CtClass>> joins) throws ModelException, ReflectiveOperationException, CannotCompileException, NotFoundException {
        Object joinClassName;
        void var5_8;
        Object tableName;
        CtClass class1;
        LinkedList<Tuple4> targetJoins = new LinkedList<Tuple4>();
        for (Tuple4 tuple4 : joins) {
            if (!((CtClass)tuple4.getT1()).equals(t.getT4()) || !((JoinTable)tuple4.getT3()).tableName().equals(((JoinTable)t.getT3()).tableName()) || ((JoinTable)tuple4.getT3()).joinProperty().length() > 0 && !((JoinTable)tuple4.getT3()).joinProperty().equals(((CtField)t.getT2()).getName()) || ((JoinTable)t.getT3()).joinProperty().length() > 0 && !((JoinTable)t.getT3()).joinProperty().equals(((CtField)tuple4.getT2()).getName())) continue;
            targetJoins.add(tuple4);
        }
        if (targetJoins.size() > 1) {
            throw new ModelException("@JoinTable on field " + ((CtClass)t.getT1()).getName() + "#" + ((CtField)t.getT2()).getName() + " is ambiguous");
        }
        CtField field1 = null;
        CtField field2 = null;
        String columnName1 = "";
        String columnName2 = "";
        if (((CtClass)t.getT1()).getName().compareTo(((CtClass)t.getT4()).getName()) < 0) {
            class1 = (CtClass)t.getT1();
            CtClass ctClass = (CtClass)t.getT4();
            field1 = (CtField)t.getT2();
            columnName1 = ((JoinTable)t.getT3()).columnName();
        } else {
            class1 = (CtClass)t.getT4();
            CtClass ctClass = (CtClass)t.getT1();
            field2 = (CtField)t.getT2();
            columnName2 = ((JoinTable)t.getT3()).columnName();
        }
        if (targetJoins.isEmpty()) {
            if (((JoinTable)t.getT3()).joinProperty().length() > 0) {
                throw new ModelException("@JoinTable on field " + ((CtClass)t.getT1()).getName() + "#" + ((CtField)t.getT2()).getName() + " refers to a property (" + ((JoinTable)t.getT3()).joinProperty() + ") that does not exist on " + ((CtClass)t.getT4()).getName());
            }
            tableName = ((JoinTable)t.getT3()).tableName();
        } else {
            Tuple4 tt = (Tuple4)targetJoins.get(0);
            joins.remove(tt);
            tableName = ((JoinTable)tt.getT3()).tableName();
            if (class1.equals(tt.getT1())) {
                field1 = (CtField)tt.getT2();
                columnName1 = ((JoinTable)tt.getT3()).columnName();
            } else {
                field2 = (CtField)tt.getT2();
                columnName2 = ((JoinTable)tt.getT3()).columnName();
            }
        }
        if (((String)tableName).isEmpty()) {
            Table t1 = (Table)class1.getAnnotation(Table.class);
            Table t2 = (Table)var5_8.getAnnotation(Table.class);
            String name1 = t1.value();
            String name2 = t2.value();
            if (name1.isEmpty()) {
                name1 = class1.getSimpleName();
            }
            if (name2.isEmpty()) {
                name2 = var5_8.getSimpleName();
            }
            tableName = name1 + "_" + name2 + "_JOIN";
        }
        joinClassName = (joinClassName = class1.getPackageName()) != null ? (String)joinClassName + ".JoinEntity_" + class1.getSimpleName() + "_" + var5_8.getSimpleName() : "JoinEntity_" + class1.getSimpleName() + "_" + var5_8.getSimpleName();
        logger.info((Object)("Create join table class " + (String)joinClassName + " with table name " + (String)tableName));
        CtClass joinClass = this.classPool.makeClass((String)joinClassName);
        ClassFile joinClassFile = joinClass.getClassFile();
        ConstPool constPool = joinClassFile.getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation(Table.class.getName(), constPool);
        annot.addMemberValue(DEFAULT_VALUE_ANNOTATION_ATTRIBUTE, (MemberValue)new StringMemberValue((String)tableName, constPool));
        attr.addAnnotation(annot);
        joinClassFile.addAttribute((AttributeInfo)attr);
        Enhancer.createJoinTableField(joinClass, "entity1", class1, columnName1, constPool);
        Enhancer.createJoinTableField(joinClass, "entity2", (CtClass)var5_8, columnName2, constPool);
        if (field1 != null) {
            this.createJoinField(class1, field1, (String)joinClassName, 1);
        }
        if (field2 != null) {
            this.createJoinField((CtClass)var5_8, field2, (String)joinClassName, 2);
        }
        this.classes.put((String)joinClassName, joinClass);
    }

    private static void createJoinTableField(CtClass joinClass, String fieldName, CtClass targetType, String columnName, ConstPool constPool) throws CannotCompileException {
        CtField field = new CtField(targetType, fieldName, joinClass);
        joinClass.addField(field);
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation(ForeignKey.class.getName(), constPool);
        annot.addMemberValue("optional", (MemberValue)new BooleanMemberValue(false, constPool));
        attr.addAnnotation(annot);
        if (columnName.length() > 0) {
            annot = new Annotation(Column.class.getName(), constPool);
            annot.addMemberValue(DEFAULT_VALUE_ANNOTATION_ATTRIBUTE, (MemberValue)new StringMemberValue(columnName, constPool));
            attr.addAnnotation(annot);
        }
        field.getFieldInfo().addAttribute((AttributeInfo)attr);
    }

    private void createJoinField(CtClass cl, CtField joinField, String joinClassName, int linkNumber) throws CannotCompileException, NotFoundException {
        ClassFile classFile = cl.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        CtField field = new CtField(this.classPool.get(Collection.class.getName()), joinField.getName() + "_join", cl);
        field.setGenericSignature(new SignatureAttribute.ClassType(Collection.class.getName(), new SignatureAttribute.TypeArgument[]{new SignatureAttribute.TypeArgument((SignatureAttribute.ObjectType)new SignatureAttribute.ClassType(joinClassName))}).encode());
        cl.addField(field);
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation(ForeignTable.class.getName(), constPool);
        annot.addMemberValue("joinKey", (MemberValue)new StringMemberValue(JOIN_TABLE_ATTRIBUTE_PREFIX + linkNumber, constPool));
        attr.addAnnotation(annot);
        field.getFieldInfo().addAttribute((AttributeInfo)attr);
        JoinTableInfo info = new JoinTableInfo();
        info.joinClassName = joinClassName;
        info.linkNumber = linkNumber;
        this.joinTableFields.computeIfAbsent(cl, c -> new HashMap()).put(joinField.getName(), info);
    }

    private void enhanceLazyMethods() throws ModelException {
        for (CtClass cl : this.classes.values()) {
            try {
                this.enhanceLazyMethods(cl);
            }
            catch (Exception e) {
                throw new ModelException("Error enhancing entity class " + cl.getName(), e);
            }
        }
    }

    private void enhanceLazyMethods(CtClass cl) throws ReflectiveOperationException, CannotCompileException, NotFoundException {
        boolean hasLoadEntity = false;
        for (CtMethod method : cl.getMethods()) {
            if (method.getName().equals("entityLoaded") && method.getParameterTypes().length == 0 && method.getReturnType().getName().equals("boolean")) {
                method.setBody("return $0._lcState != null && $0._lcState.isLoaded();");
                continue;
            }
            if (!method.getName().equals("loadEntity") || method.getParameterTypes().length != 0 || !method.getReturnType().getName().equals(Mono.class.getName())) continue;
            method.setBody("return $0._lcState.load($0);");
            hasLoadEntity = true;
        }
        if (!hasLoadEntity) {
            CtMethod m = CtNewMethod.make((String)"public reactor.core.publisher.Mono loadEntity() { return $0._lcState.load($0); }", (CtClass)cl);
            cl.addMethod(m);
        }
        this.enhanceLazyGetMethods(cl);
    }

    private void enhanceLazyGetMethods(CtClass cl) throws ReflectiveOperationException, CannotCompileException, NotFoundException {
        for (CtMethod method : cl.getMethods()) {
            if (!method.getName().startsWith("lazyGet")) continue;
            Object propertyName = method.getName().substring(7);
            CtField field = cl.getField((String)(propertyName = Character.toLowerCase(((String)propertyName).charAt(0)) + ((String)propertyName).substring(1)));
            ForeignTable ft = (ForeignTable)field.getAnnotation(ForeignTable.class);
            if (ft != null) {
                if (field.getType().isArray() || field.getType().subtypeOf(this.classPool.get(Collection.class.getName()))) {
                    method.setBody("return $0._lcState.lazyGetForeignTableCollectionField($0, \"" + (String)propertyName + "\", \"" + ft.joinKey() + "\");");
                    continue;
                }
                method.setBody("return $0._lcState.lazyGetForeignTableField($0, \"" + (String)propertyName + "\", \"" + ft.joinKey() + "\");");
                continue;
            }
            JoinTable jt = (JoinTable)field.getAnnotation(JoinTable.class);
            if (jt != null) {
                JoinTableInfo info = this.joinTableFields.get(cl).get(propertyName);
                method.setBody("return $0._lcState.lazyGetJoinTableField($0, \"" + (String)propertyName + "\", " + info.linkNumber + ");");
                continue;
            }
            ForeignKey fk = (ForeignKey)field.getAnnotation(ForeignKey.class);
            if (fk != null) {
                method.setBody("return $0.get" + method.getName().substring(7) + "() != null ? $0.get" + method.getName().substring(7) + "().loadEntity() : reactor.core.publisher.Mono.empty();");
                continue;
            }
            method.setBody("return $0.loadEntity().map($0._lcState.getFieldMapper($0, \"" + (String)propertyName + "\"));");
        }
    }

    private static void processJoinTableAccessors(CtClass cl, String propertyName, JoinTableInfo joinTable) throws CannotCompileException {
        CtMethod accessor2;
        String accessorSuffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            accessor2 = cl.getDeclaredMethod("get" + accessorSuffix);
            Enhancer.enhanceJoinTableGetter(cl.getDeclaredField(propertyName), accessor2, joinTable);
        }
        catch (NotFoundException accessor2) {
            // empty catch block
        }
        try {
            accessor2 = cl.getDeclaredMethod("set" + accessorSuffix);
            Enhancer.enhanceJoinTableSetter(cl.getDeclaredField(propertyName), accessor2, joinTable);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private static void enhanceJoinTableGetter(CtField field, CtMethod getter, JoinTableInfo joinTable) throws CannotCompileException {
        StringBuilder body = new StringBuilder();
        body.append('{');
        body.append("if ($0.").append(field.getName()).append(" != null) return $0.").append(field.getName()).append(';');
        body.append("if ($0.").append(field.getName()).append("_join != null) return $0.").append(field.getName()).append(" = new net.lecousin.reactive.data.relational.model.JoinTableCollectionToTargetCollection($0, $0.").append(field.getName()).append("_join, \"").append(joinTable.joinClassName).append("\", ").append(joinTable.linkNumber).append(");");
        body.append("return null;");
        body.append('}');
        getter.setBody(body.toString());
    }

    private static void enhanceJoinTableSetter(CtField field, CtMethod setter, JoinTableInfo joinTable) throws CannotCompileException {
        StringBuilder body = new StringBuilder();
        body.append('{');
        body.append("$0.").append(field.getName()).append("_join = new net.lecousin.reactive.data.relational.model.JoinTableCollectionFromTargetCollection($0, $0.").append(field.getName()).append("_join, $1, \"").append(joinTable.joinClassName).append("\", ").append(joinTable.linkNumber).append(");");
        body.append("$0.").append(field.getName()).append(" = $1;");
        body.append('}');
        setter.setBody(body.toString());
    }

    private static class JoinTableInfo {
        private String joinClassName;
        private int linkNumber;

        private JoinTableInfo() {
        }
    }
}

