/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.annotations.GeneratedValue;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcEntityWriter;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractInstanceProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class SaveProcessor
extends AbstractInstanceProcessor<SaveRequest> {
    SaveProcessor() {
    }

    @Override
    protected <T> SaveRequest createRequest(T instance, EntityState state, RelationalPersistentEntity<T> entity, PersistentPropertyAccessor<T> accessor) {
        return new SaveRequest(entity, instance, state, accessor);
    }

    @Override
    protected boolean doProcess(Operation op, SaveRequest request) {
        return true;
    }

    @Override
    protected void processForeignKey(Operation op, SaveRequest request, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation, @Nullable Field foreignTableField, @Nullable ForeignTable foreignTableAnnotation) {
        Object value = request.accessor.getProperty((PersistentProperty)fkProperty);
        Object originalValue = request.state.getPersistedValue(fkProperty.getName());
        if (!Objects.equals(originalValue, value) && originalValue != null) {
            if (foreignTableAnnotation != null) {
                SaveProcessor.removeForeignTableLink(op, request, foreignTableField, originalValue);
            }
            if (foreignTableAnnotation != null && !foreignTableAnnotation.optional() || fkAnnotation.cascadeDelete()) {
                op.addToDelete(originalValue, null, null, null);
            }
        }
        if (value != null) {
            SaveRequest save = op.addToSave(value, null, null, null);
            if (!save.state.isPersisted()) {
                request.dependsOn(save);
            }
        }
    }

    private static void removeForeignTableLink(Operation op, SaveRequest request, Field foreignTableField, Object originalValue) {
        try {
            if (ModelUtils.isCollection(foreignTableField)) {
                ModelUtils.removeFromCollectionField(foreignTableField, originalValue, request.instance);
            } else {
                EntityState foreignState = EntityState.get(originalValue, op.lcClient);
                foreignState.setForeignTableField(originalValue, foreignTableField, null, false);
            }
        }
        catch (Exception e) {
            throw new ModelAccessException("Unable to remove link for removed entity", e);
        }
    }

    @Override
    protected <T> void processForeignTableField(Operation op, SaveRequest request, Field foreignTableField, ForeignTable foreignTableAnnotation, @Nullable MutableObject<?> foreignFieldValue, boolean isCollection, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        if (foreignFieldValue == null) {
            return;
        }
        if (ModelUtils.isCollection(foreignTableField)) {
            SaveProcessor.processForeignTableFieldCollection(op, request, foreignTableField, foreignFieldValue, foreignEntity, fkProperty, fkAnnotation);
        } else {
            SaveProcessor.processForeignTableFieldSimple(op, request, foreignTableField, foreignFieldValue, foreignEntity, fkProperty, fkAnnotation);
        }
    }

    private static <T> void processForeignTableFieldCollection(Operation op, SaveRequest request, Field foreignTableField, MutableObject<?> foreignFieldValue, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        ArrayList value = foreignFieldValue.getValue();
        Object originalValue = request.state.getPersistedValue(foreignTableField.getName());
        if (value == null) {
            if (originalValue == null) {
                return;
            }
            value = new ArrayList(0);
        }
        LinkedList<Object> deletedElements = new LinkedList<Object>();
        if (originalValue != null) {
            deletedElements.addAll(ModelUtils.getAsCollection(originalValue));
        }
        deletedElements.removeAll(ModelUtils.getAsCollection(value));
        if (!deletedElements.isEmpty()) {
            SaveProcessor.deletedElements(op, deletedElements, foreignEntity, fkProperty, fkAnnotation);
        }
        for (Object element : ModelUtils.getAsCollection(value)) {
            SaveRequest save = op.addToSave(element, foreignEntity, null, null);
            save.state.setPersistedField(element, fkProperty.getField(), request.instance, false);
        }
    }

    private static <T> void deletedElements(Operation op, List<Object> deletedElements, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        if (!fkAnnotation.optional() || fkAnnotation.onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.DELETE)) {
            for (Object element : deletedElements) {
                op.addToDelete(element, foreignEntity, null, null);
            }
        } else {
            for (Object element : deletedElements) {
                SaveRequest save = op.addToSave(element, foreignEntity, null, null);
                save.state.setPersistedField(element, fkProperty.getField(), null, false);
            }
        }
    }

    private static <T> void processForeignTableFieldSimple(Operation op, SaveRequest request, Field foreignTableField, MutableObject<?> foreignFieldValue, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        SaveRequest save;
        Object value = foreignFieldValue.getValue();
        Object originalValue = request.state.getPersistedValue(foreignTableField.getName());
        if (!Objects.equals(originalValue, value) && originalValue != null) {
            if (!fkAnnotation.optional() || fkAnnotation.onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.DELETE)) {
                op.addToDelete(originalValue, foreignEntity, null, null);
            } else {
                save = op.addToSave(originalValue, foreignEntity, null, null);
                save.state.setPersistedField(originalValue, fkProperty.getField(), null, false);
            }
        }
        if (value != null) {
            save = op.addToSave(value, foreignEntity, null, null);
            save.state.setPersistedField(value, fkProperty.getField(), request.instance, false);
        }
    }

    @Override
    protected Mono<Void> doRequests(Operation op, RelationalPersistentEntity<?> entityType, List<SaveRequest> requests) {
        LinkedList<Mono<Object>> statements = new LinkedList<Mono<Object>>();
        for (SaveRequest request : requests) {
            if (!request.state.isPersisted()) {
                statements.add(SaveProcessor.doInsert(op, request));
                continue;
            }
            statements.add(SaveProcessor.doUpdate(op, request));
        }
        return Mono.when(statements);
    }

    private static Mono<Object> doInsert(Operation op, SaveRequest request) {
        return Mono.fromCallable(() -> {
            SqlQuery<Insert> query = new SqlQuery<Insert>(op.lcClient);
            LinkedList<RelationalPersistentProperty> generated = new LinkedList<RelationalPersistentProperty>();
            OutboundRow row = new OutboundRow();
            LcEntityWriter writer = new LcEntityWriter(op.lcClient.getMapper());
            long currentDate = System.currentTimeMillis();
            for (RelationalPersistentProperty property : request.entityType) {
                if (property.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue gv = (GeneratedValue)property.getRequiredAnnotation(GeneratedValue.class);
                    if (GeneratedValue.Strategy.RANDOM_UUID.equals((Object)gv.strategy()) && !op.lcClient.getSchemaDialect().supportsUuidGeneration()) {
                        UUID uuid = UUID.randomUUID();
                        request.accessor.setProperty((PersistentProperty)property, (Object)uuid);
                        writer.writeProperty(row, property, request.accessor);
                        continue;
                    }
                    generated.add(property);
                    continue;
                }
                if (property.isTransient()) continue;
                if (request.entityType.isVersionProperty((PersistentProperty)property)) {
                    request.accessor.setProperty((PersistentProperty)property, op.lcClient.getMapper().getConversionService().convert((Object)1L, property.getType()));
                } else if (property.isAnnotationPresent(CreatedDate.class) || property.isAnnotationPresent(LastModifiedDate.class)) {
                    request.accessor.setProperty((PersistentProperty)property, SaveProcessor.getDateValue(currentDate, property.getType()));
                }
                writer.writeProperty(row, property, request.accessor);
            }
            query.setQuery(SaveProcessor.createInsertQuery(query, row, request.entityType.getTableName(), generated));
            return query.execute().filter(statement -> statement.returnGeneratedValues(new String[0])).map((r, meta) -> {
                int index = 0;
                for (RelationalPersistentProperty property : generated) {
                    request.accessor.setProperty((PersistentProperty)property, op.lcClient.getSchemaDialect().convertFromDataBase(r.get(index++), property.getType()));
                }
                request.state.loaded(request.instance);
                return request.instance;
            });
        }).flatMap(RowsFetchSpec::first);
    }

    private static Insert createInsertQuery(SqlQuery<Insert> query, OutboundRow row, SqlIdentifier tableName, List<RelationalPersistentProperty> generated) {
        Table table = Table.create((SqlIdentifier)tableName);
        ArrayList<Column> columns = new ArrayList<Column>(row.size());
        ArrayList<Object> values = new ArrayList<Object>(row.size());
        for (RelationalPersistentProperty property : generated) {
            GeneratedValue gv = (GeneratedValue)property.getRequiredAnnotation(GeneratedValue.class);
            if (!gv.strategy().equals((Object)GeneratedValue.Strategy.SEQUENCE)) continue;
            columns.add(Column.create((SqlIdentifier)property.getColumnName(), (Table)table));
            values.add(SimpleFunction.create((String)query.getClient().getSchemaDialect().sequenceNextValueFunctionName(), Arrays.asList(SQL.literalOf((CharSequence)gv.sequence()))));
        }
        for (Map.Entry entry : row.entrySet()) {
            columns.add(Column.create((SqlIdentifier)((SqlIdentifier)entry.getKey()), (Table)table));
            if (((Parameter)entry.getValue()).getValue() == null) {
                values.add(SQL.nullLiteral());
                continue;
            }
            values.add(query.marker(((Parameter)entry.getValue()).getValue()));
        }
        return Insert.builder().into(table).columns(columns).values(values).build();
    }

    private static Mono<Object> doUpdate(Operation op, SaveRequest request) {
        return Mono.fromCallable(() -> SaveProcessor.createUpdateRequest(op, request)).flatMap(updatedRows -> updatedRows != null ? updatedRows.thenReturn(request.instance).doOnSuccess(e -> SaveProcessor.entityUpdated(op, request)) : Mono.just((Object)request.instance));
    }

    private static Mono<Integer> createUpdateRequest(Operation op, SaveRequest request) {
        LcEntityWriter writer;
        OutboundRow row;
        LinkedList<AssignValue> assignments;
        SqlQuery<Update> query = new SqlQuery<Update>(op.lcClient);
        Table table = Table.create((SqlIdentifier)request.entityType.getTableName());
        if (!SaveProcessor.prepareUpdate(request, table, assignments = new LinkedList<AssignValue>(), row = new OutboundRow(), writer = new LcEntityWriter(op.lcClient.getMapper()), query)) {
            return null;
        }
        for (Map.Entry entry : row.entrySet()) {
            assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)((SqlIdentifier)entry.getKey()), (Table)table), (Expression)(((Parameter)entry.getValue()).getValue() != null ? query.marker(((Parameter)entry.getValue()).getValue()) : SQL.nullLiteral())));
        }
        Condition criteria = ModelUtils.getConditionOnId(query, request.entityType, request.accessor, op.lcClient.getMappingContext());
        if (request.entityType.hasVersionProperty()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)request.entityType.getRequiredVersionProperty();
            Object value = request.accessor.getProperty((PersistentProperty)property);
            Assert.notNull((Object)value, (String)"Version must not be null");
            long currentVersion = ((Number)value).longValue();
            criteria = criteria.and((Condition)Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)query.marker(currentVersion)));
        }
        query.setQuery(Update.builder().table(table).set(assignments).where(criteria).build());
        Mono rowsUpdated = query.execute().fetch().rowsUpdated();
        if (request.entityType.hasVersionProperty()) {
            rowsUpdated = rowsUpdated.flatMap(updatedRows -> {
                if (updatedRows == 0) {
                    return Mono.error((Throwable)new OptimisticLockingFailureException("Version does not match"));
                }
                return Mono.just((Object)updatedRows);
            });
        }
        return rowsUpdated;
    }

    private static boolean prepareUpdate(SaveRequest request, Table table, List<AssignValue> assignments, OutboundRow row, LcEntityWriter writer, SqlQuery<Update> query) {
        boolean hasUpdate = false;
        HashMap propertiesToSetIfUpdate = new HashMap();
        long currentDate = System.currentTimeMillis();
        for (RelationalPersistentProperty property : request.entityType) {
            if (request.entityType.isVersionProperty((PersistentProperty)property)) {
                Object value = request.accessor.getProperty((PersistentProperty)property);
                Assert.notNull((Object)value, (String)("Version must not be null (property " + property.getName() + " on " + request.entityType.getType().getSimpleName() + ")"));
                long currentVersion = ((Number)value).longValue();
                assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)query.marker(currentVersion + 1L)));
                continue;
            }
            if (property.isAnnotationPresent(LastModifiedDate.class)) {
                propertiesToSetIfUpdate.put(property, SaveProcessor.getDateValue(currentDate, property.getType()));
                continue;
            }
            if (!request.state.isFieldModified(property.getName())) continue;
            if (ModelUtils.isUpdatable(property)) {
                writer.writeProperty(row, property, request.accessor);
                hasUpdate = true;
                continue;
            }
            request.state.restorePersistedValue(request.instance, property.getField());
        }
        if (hasUpdate) {
            for (Map.Entry e : propertiesToSetIfUpdate.entrySet()) {
                request.accessor.setProperty((PersistentProperty)e.getKey(), e.getValue());
                writer.writeProperty(row, (RelationalPersistentProperty)e.getKey(), request.accessor);
            }
        }
        return hasUpdate;
    }

    private static void entityUpdated(Operation op, SaveRequest request) {
        request.state.load(request.instance);
        if (request.entityType.hasVersionProperty()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)request.entityType.getRequiredVersionProperty();
            Object version = request.accessor.getProperty((PersistentProperty)property);
            Assert.notNull((Object)version, (String)"Version must not be null");
            request.accessor.setProperty((PersistentProperty)property, op.lcClient.getMapper().getConversionService().convert((Object)(((Number)version).longValue() + 1L), property.getType()));
        }
    }

    private static <T> T getDateValue(long timestamp, Class<T> type) {
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (T)Long.valueOf(timestamp);
        }
        if (type.isAssignableFrom(Instant.class)) {
            return (T)Instant.ofEpochMilli(timestamp);
        }
        if (type.isAssignableFrom(LocalDate.class)) {
            return (T)LocalDate.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(LocalTime.class)) {
            return (T)LocalTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(OffsetTime.class)) {
            return (T)OffsetTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(LocalDateTime.class)) {
            return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        if (type.isAssignableFrom(ZonedDateTime.class)) {
            return (T)ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        }
        return null;
    }

    static class SaveRequest
    extends AbstractInstanceProcessor.Request {
        <T> SaveRequest(RelationalPersistentEntity<T> entityType, T instance, EntityState state, PersistentPropertyAccessor<T> accessor) {
            super(entityType, instance, state, accessor);
            if (!this.state.isLoaded() && this.state.isPersisted()) {
                this.toProcess = false;
            }
        }
    }
}

