/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.configuration;

import io.r2dbc.spi.ConnectionFactory;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.mapping.LcReactiveDataAccessStrategy;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.config.AbstractR2dbcConfiguration;
import org.springframework.data.r2dbc.convert.MappingR2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.mapping.R2dbcMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Configuration
public abstract class LcReactiveDataRelationalConfiguration
extends AbstractR2dbcConfiguration {
    private static final String CONNECTION_FACTORY_BEAN_NAME = "connectionFactory";
    @Nullable
    protected ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
        super.setApplicationContext(applicationContext);
    }

    @Bean
    public LcReactiveDataRelationalClient lcClient() {
        return new LcReactiveDataRelationalClient();
    }

    @Bean
    public abstract RelationalDatabaseSchemaDialect schemaDialect();

    @Bean
    public LcReactiveDataAccessStrategy reactiveDataAccessStrategy(R2dbcConverter converter) {
        return new LcReactiveDataAccessStrategy(this.getDialect(this.getConnectionFactory()), (LcMappingR2dbcConverter)converter);
    }

    public MappingR2dbcConverter r2dbcConverter(R2dbcMappingContext mappingContext, R2dbcCustomConversions r2dbcCustomConversions) {
        return new LcMappingR2dbcConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, (CustomConversions)r2dbcCustomConversions, this.getClient());
    }

    public ConnectionFactory connectionFactory() {
        return null;
    }

    private ConnectionFactory getConnectionFactory() {
        String[] beanNamesForType;
        Assert.notNull((Object)this.context, (String)"ApplicationContext is not yet initialized");
        for (String beanName : beanNamesForType = this.context.getBeanNamesForType(ConnectionFactory.class)) {
            if (!beanName.equals(CONNECTION_FACTORY_BEAN_NAME)) continue;
            return (ConnectionFactory)this.context.getBean(CONNECTION_FACTORY_BEAN_NAME, ConnectionFactory.class);
        }
        ConnectionFactory factory = this.connectionFactory();
        if (factory == null) {
            throw new RuntimeException("No r2dbc connection factory defined");
        }
        return factory;
    }

    private LcReactiveDataRelationalClient getClient() {
        try {
            return (LcReactiveDataRelationalClient)this.context.getBean(LcReactiveDataRelationalClient.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return this.lcClient();
        }
    }
}

