/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.PostConstruct;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcEntityReader;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.mapping.LcReactiveDataAccessStrategy;
import net.lecousin.reactive.data.relational.model.EntityCache;
import net.lecousin.reactive.data.relational.model.LcEntityTypeInfo;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.SelectExecution;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.SchemaBuilderFromEntities;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class LcReactiveDataRelationalClient {
    public static final Log logger = LogFactory.getLog(LcReactiveDataRelationalClient.class);
    private static final String QUERY_ENTITY_NAME = "entity";
    @Autowired
    private MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;
    @Autowired
    private DatabaseClient client;
    @Autowired
    private RelationalDatabaseSchemaDialect schemaDialect;
    @Autowired
    private LcReactiveDataAccessStrategy dataAccess;
    private LcMappingR2dbcConverter mapper;

    @PostConstruct
    public void init() {
        for (Class<?> type : LcEntityTypeInfo.getClasses()) {
            this.mappingContext.getPersistentEntity(type);
        }
    }

    public LcMappingR2dbcConverter getMapper() {
        return this.mapper;
    }

    public void setMapper(LcMappingR2dbcConverter mapper) {
        this.mapper = mapper;
    }

    public DatabaseClient getSpringClient() {
        return this.client;
    }

    public MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public LcReactiveDataAccessStrategy getDataAccess() {
        return this.dataAccess;
    }

    public RelationalDatabaseSchemaDialect getSchemaDialect() {
        return this.schemaDialect;
    }

    public R2dbcDialect getDialect() {
        return this.dataAccess.getDialect();
    }

    public Mono<Void> dropSchemaContent(RelationalDatabaseSchema schema) {
        return this.schemaDialect.dropSchemaContent(schema).execute(this);
    }

    public Mono<Void> createSchemaContent(RelationalDatabaseSchema schema) {
        return this.schemaDialect.createSchemaContent(schema).execute(this);
    }

    public Mono<Void> dropCreateSchemaContent(RelationalDatabaseSchema schema) {
        return this.dropSchemaContent(schema).then(this.createSchemaContent(schema));
    }

    public RelationalDatabaseSchema buildSchemaFromEntities() {
        return this.buildSchemaFromEntities(LcEntityTypeInfo.getClasses());
    }

    public RelationalDatabaseSchema buildSchemaFromEntities(Collection<Class<?>> classes) {
        return new SchemaBuilderFromEntities(this).build(classes);
    }

    public <T> Mono<T> save(T entity) {
        try {
            RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
            Operation op = new Operation(this);
            op.addToSave(entity, entityType, null, null);
            return op.execute().thenReturn(entity);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Flux<T> save(Iterable<T> entities) {
        try {
            Iterator<T> it = entities.iterator();
            if (!it.hasNext()) {
                return Flux.empty();
            }
            T instance = it.next();
            RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(instance.getClass());
            Operation op = new Operation(this);
            op.addToSave(instance, entityType, null, null);
            while (it.hasNext()) {
                op.addToSave(it.next(), entityType, null, null);
            }
            return op.execute().thenMany((Publisher)Flux.fromIterable(entities));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    public <T> Flux<T> save(Publisher<T> publisher) {
        Operation op = new Operation(this);
        LinkedList list = new LinkedList();
        return Flux.from(publisher).doOnNext(instance -> {
            op.addToSave(instance, null, null, null);
            list.add(instance);
        }).then(Mono.fromCallable(op::execute)).flatMap(m -> m).thenReturn(list).flatMapMany(Flux::fromIterable);
    }

    public Mono<Void> saveAll(Iterable<Object> entities) {
        Iterator<Object> it = entities.iterator();
        if (!it.hasNext()) {
            return Mono.empty();
        }
        Operation op = new Operation(this);
        do {
            op.addToSave(it.next(), null, null, null);
        } while (it.hasNext());
        return op.execute();
    }

    public Mono<Void> saveAll(Object ... entities) {
        return this.saveAll(Arrays.asList(entities));
    }

    public <T> Mono<T> lazyLoad(T entity) {
        return this.lazyLoad(entity, (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass()));
    }

    public <T> Mono<T> lazyLoad(T entity, RelationalPersistentEntity<?> entityType) {
        return this.lazyLoad(entity, EntityState.get(entity, this, entityType), entityType);
    }

    public <T> Mono<T> lazyLoad(T entity, EntityState state, RelationalPersistentEntity<?> entityType) {
        return Mono.fromCallable(() -> state.loading(() -> this.doLoading(entity, entityType))).flatMap(result -> result);
    }

    private <T> Mono<T> doLoading(T entity, RelationalPersistentEntity<?> entityType) {
        PersistentPropertyAccessor accessor = entityType.getPropertyAccessor(entity);
        Object id = ModelUtils.getId(entityType, accessor, this.mappingContext);
        EntityCache cache = new EntityCache();
        cache.setById(entity.getClass(), id, entity);
        return SelectQuery.from(entity.getClass(), QUERY_ENTITY_NAME).where(ModelUtils.getCriteriaOnId(QUERY_ENTITY_NAME, entityType, accessor, this.mappingContext)).limit(0L, 1L).execute(this, new LcEntityReader(cache, this.getMapper())).next();
    }

    public <T> Flux<T> lazyLoad(Iterable<T> entities, RelationalPersistentEntity<?> entityType) {
        LinkedList alreadyLoading = new LinkedList();
        LinkedList<T> toLoad = new LinkedList<T>();
        for (T entity : entities) {
            EntityState state = EntityState.get(entity, this, entityType);
            Mono loading = state.getLoading();
            if (loading != null) {
                alreadyLoading.add(loading);
                continue;
            }
            toLoad.add(entity);
        }
        Flux loading = this.doLoading((Iterable<T>)toLoad, entityType).cache();
        for (Object entity : toLoad) {
            EntityState state = EntityState.get(entity, this, entityType);
            alreadyLoading.add(state.loading(() -> loading.filter(e -> e == entity).next()));
        }
        return Flux.merge(alreadyLoading);
    }

    private <T> Flux<T> doLoading(Iterable<T> entities, RelationalPersistentEntity<?> entityType) {
        Iterator<T> it = entities.iterator();
        if (!it.hasNext()) {
            return Flux.empty();
        }
        T entity = it.next();
        if (!it.hasNext()) {
            return Flux.from(this.doLoading(entity, entityType));
        }
        EntityCache cache = new EntityCache();
        Criteria criteria = null;
        while (true) {
            PersistentPropertyAccessor accessor = entityType.getPropertyAccessor(entity);
            Object id = ModelUtils.getId(entityType, accessor, this.mappingContext);
            cache.setById(entity.getClass(), id, entity);
            Criteria entityCriteria = ModelUtils.getCriteriaOnId(QUERY_ENTITY_NAME, entityType, accessor, this.mappingContext);
            Criteria criteria2 = criteria = criteria != null ? criteria.or(entityCriteria) : entityCriteria;
            if (!it.hasNext()) break;
            entity = it.next();
        }
        return SelectQuery.from(entity.getClass(), QUERY_ENTITY_NAME).where(criteria).execute(this, new LcEntityReader(cache, this.getMapper()));
    }

    public <T> Flux<T> execute(SelectQuery<T> query, @Nullable LcEntityReader reader) {
        return new SelectExecution<T>(query, this, reader).execute();
    }

    public <T> Mono<Void> delete(T entity) {
        try {
            RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(entity.getClass());
            Operation op = new Operation(this);
            op.addToDelete(entity, entityType, null, null);
            return op.execute();
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Mono<Void> delete(Iterable<T> entities) {
        try {
            Iterator<T> it = entities.iterator();
            if (!it.hasNext()) {
                return Mono.empty();
            }
            T instance = it.next();
            RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(instance.getClass());
            Operation op = new Operation(this);
            op.addToDelete(instance, entityType, null, null);
            while (it.hasNext()) {
                op.addToDelete(it.next(), entityType, null, null);
            }
            return op.execute();
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Mono<Void> delete(Publisher<T> publisher) {
        Operation op = new Operation(this);
        return Flux.from(publisher).doOnNext(instance -> op.addToDelete(instance, null, null, null)).then(Mono.fromCallable(op::execute)).flatMap(m -> m);
    }
}

