/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema.dialect;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SchemaStatement {
    private String sql;
    private Set<SchemaStatement> dependencies = new HashSet<SchemaStatement>();
    private Set<SchemaStatement> doNotExecuteTogether = new HashSet<SchemaStatement>();

    public SchemaStatement(String sql) {
        this.sql = sql;
    }

    public void addDependency(SchemaStatement dependsOn) {
        this.dependencies.add(dependsOn);
    }

    public void removeDependency(SchemaStatement statement) {
        this.dependencies.remove(statement);
    }

    public boolean hasDependency() {
        return !this.dependencies.isEmpty();
    }

    public void doNotExecuteTogether(SchemaStatement statement) {
        this.doNotExecuteTogether.add(statement);
    }

    public boolean canExecuteWith(List<SchemaStatement> statements) {
        return this.doNotExecuteTogether.stream().noneMatch(statements::contains);
    }

    public String getSql() {
        return this.sql;
    }
}

