/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.IsNull;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import reactor.core.publisher.Mono;

class DeleteWithoutLoading
extends AbstractProcessor<Request> {
    private Map<RelationalPersistentEntity<?>, List<Request>> requests = new HashMap();

    DeleteWithoutLoading() {
    }

    Request addRequest(RelationalPersistentEntity<?> entity, RelationalPersistentProperty whereProperty, Object whereValue) {
        List list = this.requests.computeIfAbsent(entity, e -> new LinkedList());
        for (Request r : list) {
            if (!r.whereProperty.equals(whereProperty) || !Objects.equals(r.whereValue, whereValue)) continue;
            return r;
        }
        Request r = new Request(entity, whereProperty, whereValue);
        list.add(r);
        return r;
    }

    @Override
    protected Mono<Void> executeRequests(Operation op) {
        LinkedList<Mono> calls = new LinkedList<Mono>();
        for (Map.Entry<RelationalPersistentEntity<?>, List<Request>> entity : this.requests.entrySet()) {
            LinkedList<Request> ready = new LinkedList<Request>();
            for (Request r : entity.getValue()) {
                if (!this.canExecuteRequest(r)) continue;
                ready.add(r);
            }
            if (ready.isEmpty()) continue;
            SqlQuery<Delete> query = new SqlQuery<Delete>(op.lcClient);
            Table table = Table.create((SqlIdentifier)entity.getKey().getTableName());
            Condition condition = DeleteWithoutLoading.createCondition(entity.getKey(), table, ready, query);
            query.setQuery(Delete.builder().from(table).where(condition).build());
            calls.add(query.execute().then().doOnSuccess(v -> ready.forEach(r -> {
                r.executed = true;
            })));
        }
        if (calls.isEmpty()) {
            return null;
        }
        return Mono.when(calls);
    }

    private static Condition createCondition(RelationalPersistentEntity<?> entityType, Table table, List<Request> ready, SqlQuery<Delete> query) {
        IsNull condition = null;
        Iterator<Request> it = ready.iterator();
        do {
            Request r = it.next();
            Column col = Column.create((SqlIdentifier)r.whereProperty.getColumnName(), (Table)table);
            IsNull c = r.whereValue != null ? Conditions.isEqual((Expression)col, (Expression)query.marker(r.whereValue)) : Conditions.isNull((Expression)col);
            Object object = condition = condition != null ? condition.or((Condition)c) : c;
            if (!LcReactiveDataRelationalClient.logger.isDebugEnabled()) continue;
            LcReactiveDataRelationalClient.logger.debug((Object)("Delete " + entityType.getType().getName() + " where " + r.whereProperty.getName() + " = " + r.whereValue));
        } while (it.hasNext());
        return condition;
    }

    static class Request
    extends AbstractProcessor.Request {
        RelationalPersistentProperty whereProperty;
        Object whereValue;

        Request(RelationalPersistentEntity<?> entityType, RelationalPersistentProperty whereProperty, Object whereValue) {
            super(entityType);
            this.whereProperty = whereProperty;
            this.whereValue = whereValue;
        }
    }
}

