/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import reactor.core.publisher.Mono;

abstract class AbstractProcessor<R extends Request> {
    AbstractProcessor() {
    }

    protected abstract Mono<Void> executeRequests(Operation var1);

    protected boolean canExecuteRequest(R request) {
        if (!((Request)request).canExecute()) {
            return false;
        }
        Iterator<Request> it = ((Request)request).dependencies.iterator();
        while (it.hasNext()) {
            Request dependency = it.next();
            if (!dependency.isDone()) continue;
            it.remove();
        }
        return ((Request)request).dependencies.isEmpty();
    }

    protected Mono<Void> doOperations(Operation op) {
        return this.executeRequests(op);
    }

    static abstract class Request {
        RelationalPersistentEntity<?> entityType;
        boolean executed = false;
        Set<Request> dependencies = new HashSet<Request>();

        <T> Request(RelationalPersistentEntity<T> entityType) {
            this.entityType = entityType;
        }

        void dependsOn(Request dependency) {
            if (dependency.dependencies.contains(this)) {
                throw new IllegalStateException("Cyclic dependency between requests");
            }
            this.dependencies.add(dependency);
        }

        protected boolean canExecute() {
            return !this.executed;
        }

        protected boolean isDone() {
            return this.executed;
        }
    }
}

