/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.mapping.LcEntityReader;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class SelectQuery<T> {
    TableReference from;
    List<TableReference> joins = new LinkedList<TableReference>();
    Map<String, TableReference> tableAliases = new HashMap<String, TableReference>();
    Criteria where = null;
    long offset = 0L;
    long limit = -1L;
    List<Tuple2<String, Boolean>> orderBy = new LinkedList<Tuple2<String, Boolean>>();

    private SelectQuery(Class<T> type, String alias) {
        this.from = new TableReference(null, null, type, alias);
        this.tableAliases.put(alias, this.from);
    }

    public static <T> SelectQuery<T> from(Class<T> type, String alias) {
        return new SelectQuery<T>(type, alias);
    }

    public SelectQuery<T> join(String entityName, String propertyName, String alias) {
        TableReference source = this.tableAliases.get(entityName);
        TableReference table = new TableReference(source, propertyName, null, alias);
        this.joins.add(table);
        this.tableAliases.put(table.alias, table);
        return this;
    }

    public SelectQuery<T> where(Criteria criteria) {
        this.where = this.where == null ? criteria : this.where.and(criteria);
        return this;
    }

    public SelectQuery<T> limit(long start, long nb) {
        this.offset = start;
        this.limit = nb;
        return this;
    }

    public SelectQuery<T> orderBy(String rootPropertyName, boolean ascending) {
        this.orderBy.add((Tuple2<String, Boolean>)Tuples.of((Object)rootPropertyName, (Object)ascending));
        return this;
    }

    public Flux<T> execute(LcReactiveDataRelationalClient client) {
        return client.execute(this, null);
    }

    public Flux<T> execute(LcReactiveDataRelationalClient client, LcEntityReader reader) {
        return client.execute(this, reader);
    }

    void setJoinsTargetType(LcMappingR2dbcConverter mapper) {
        for (TableReference join : this.joins) {
            if (join.targetType != null) continue;
            RelationalPersistentEntity joinSourceEntity = (RelationalPersistentEntity)mapper.getMappingContext().getRequiredPersistentEntity(join.source.targetType);
            RelationalPersistentProperty property = (RelationalPersistentProperty)joinSourceEntity.getPersistentProperty(join.propertyName);
            if (property != null) {
                join.targetType = property.getActualType();
                continue;
            }
            Field f = ModelUtils.getRequiredForeignTableFieldForProperty(join.source.targetType, join.propertyName);
            if (ModelUtils.isCollection(f)) {
                join.targetType = ModelUtils.getCollectionType(f);
                continue;
            }
            join.targetType = f.getType();
        }
    }

    static class TableReference {
        TableReference source;
        String propertyName;
        Class<?> targetType;
        String alias;

        private TableReference(TableReference source, String propertyName, Class<?> targetType, String alias) {
            this.source = source;
            this.propertyName = propertyName;
            this.targetType = targetType;
            this.alias = alias;
        }
    }
}

