/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.onetomanymodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.onetomanymodel.RootEntity;
import net.lecousin.reactive.data.relational.test.onetomanymodel.RootEntityRepository;
import net.lecousin.reactive.data.relational.test.onetomanymodel.SubEntity;
import net.lecousin.reactive.data.relational.test.onetomanymodel.SubEntity2;
import net.lecousin.reactive.data.relational.test.onetomanymodel.SubEntity3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractTestOneToManyModel
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private RootEntityRepository repo;

    @Override
    protected Collection<Class<?>> usedEntities() {
        return Arrays.asList(RootEntity.class, SubEntity.class, SubEntity2.class, SubEntity3.class);
    }

    @Test
    public void testListEmpty() {
        RootEntity root = new RootEntity();
        root.setValue("empty");
        root.setList(new LinkedList<SubEntity>());
        root = (RootEntity)this.repo.save(root).block();
        Assertions.assertEquals((Object)"empty", (Object)root.getValue());
        Assertions.assertTrue((root.getList() == null || root.getList().isEmpty() ? 1 : 0) != 0);
        List list = (List)this.repo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"empty", (Object)root.getValue());
        Assertions.assertTrue((root.getList() == null || root.getList().isEmpty() ? 1 : 0) != 0);
        list = (List)this.repo.findByValueWithSubEntity("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo.findByValueWithSubEntity("empty").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"empty", (Object)root.getValue());
        Assertions.assertTrue((root.getList() == null || root.getList().isEmpty() ? 1 : 0) != 0);
        this.repo.deleteAll((Iterable)this.repo.findAll().collectList().block()).block();
        Assertions.assertEquals((int)0, (int)((List)this.repo.findAll().collectList().block()).size());
    }

    @Test
    public void testOneSubElement() {
        RootEntity root = new RootEntity();
        root.setValue("one");
        root.setList(new LinkedList<SubEntity>());
        SubEntity sub = new SubEntity();
        sub.setSubValue("sub1");
        root.getList().add(sub);
        root = (RootEntity)this.repo.save(root).block();
        Assertions.assertEquals((Object)"one", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)1, (int)root.getList().size());
        Assertions.assertEquals((Object)"sub1", (Object)root.getList().get(0).getSubValue());
        Assertions.assertEquals((Object)root, (Object)root.getList().get(0).getParent());
        List list = (List)this.repo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"one", (Object)root.getValue());
        Assertions.assertNull(root.getList());
        List<SubEntity> children = (List<SubEntity>)root.lazyGetList().collectList().block();
        Assertions.assertNotNull((Object)children);
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals((Object)"sub1", (Object)((SubEntity)children.get(0)).getSubValue());
        children = root.getList();
        Assertions.assertNotNull(children);
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertEquals((Object)"sub1", (Object)children.get(0).getSubValue());
        root.lazyGetList().collectList().block();
        list = (List)this.repo.findByValueWithSubEntity("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo.findByValueWithSubEntity("one").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"one", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)1, (int)root.getList().size());
        Assertions.assertEquals((Object)"sub1", (Object)root.getList().get(0).getSubValue());
        Assertions.assertEquals((Object)root, (Object)root.getList().get(0).getParent());
        list = (List)this.repo.findBySubValue("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo.findBySubValue("sub1").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"one", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)1, (int)root.getList().size());
        Assertions.assertEquals((Object)"sub1", (Object)root.getList().get(0).getSubValue());
        Assertions.assertEquals((Object)root, (Object)root.getList().get(0).getParent());
        this.repo.deleteAll((Iterable)this.repo.findAll().collectList().block()).block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testZeroToSeveralSubElements() {
        RootEntity root = new RootEntity();
        root.setValue("zero");
        this.repo.save(root).block();
        root = new RootEntity();
        root.setValue("one");
        root.setList(new LinkedList<SubEntity>());
        SubEntity sub = new SubEntity();
        sub.setSubValue("sub1.1");
        root.getList().add(sub);
        this.repo.save(root).block();
        root = new RootEntity();
        root.setValue("two");
        root.setList(new LinkedList<SubEntity>());
        sub = new SubEntity();
        sub.setSubValue("sub2.1");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("sub2.2");
        root.getList().add(sub);
        this.repo.save(root).block();
        root = new RootEntity();
        root.setValue("five");
        root.setList(new LinkedList<SubEntity>());
        sub = new SubEntity();
        sub.setSubValue("sub5.1");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("sub5.2");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("sub5.3");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("sub5.4");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("sub5.5");
        root.getList().add(sub);
        this.repo.save(root).block();
        List list = (List)this.repo.findAll().collectList().block();
        Assertions.assertEquals((int)4, (int)list.size());
        LinkedList<String> expected = new LinkedList<String>();
        expected.addAll(Arrays.asList("zero", "one", "two", "five"));
        for (RootEntity r : list) {
            LinkedList<String> expectedSub;
            Assertions.assertTrue((boolean)expected.remove(r.getValue()));
            Assertions.assertNull(r.getList());
            List<SubEntity> children = (List<SubEntity>)r.lazyGetList().collectList().block();
            Assertions.assertNotNull((Object)children);
            if ("zero".equals(r.getValue())) {
                Assertions.assertEquals((int)0, (int)children.size());
            } else if ("one".equals(r.getValue())) {
                Assertions.assertEquals((int)1, (int)children.size());
                Assertions.assertEquals((Object)"sub1.1", (Object)children.get(0).getSubValue());
            } else if ("two".equals(r.getValue())) {
                Assertions.assertEquals((int)2, (int)children.size());
                expectedSub = new LinkedList<String>();
                expectedSub.addAll(Arrays.asList("sub2.1", "sub2.2"));
                for (SubEntity s : children) {
                    Assertions.assertTrue((boolean)expectedSub.remove(s.getSubValue()));
                }
            } else if ("five".equals(r.getValue())) {
                Assertions.assertEquals((int)5, (int)children.size());
                expectedSub = new LinkedList();
                expectedSub.addAll(Arrays.asList("sub5.1", "sub5.2", "sub5.3", "sub5.4", "sub5.5"));
                for (SubEntity s : children) {
                    Assertions.assertTrue((boolean)expectedSub.remove(s.getSubValue()));
                }
            }
            children = root.getList();
            Assertions.assertNotNull(children);
        }
        list = (List)this.repo.findByValueWithSubEntity("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo.findByValueWithSubEntity("zero").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"zero", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)0, (int)root.getList().size());
        list = (List)this.repo.findByValueWithSubEntity("one").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"one", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)1, (int)root.getList().size());
        Assertions.assertEquals((Object)"sub1.1", (Object)root.getList().get(0).getSubValue());
        Assertions.assertEquals((Object)root, (Object)root.getList().get(0).getParent());
        list = (List)this.repo.findByValueWithSubEntity("two").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"two", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)2, (int)root.getList().size());
        LinkedList<String> expectedSub = new LinkedList<String>();
        expectedSub.addAll(Arrays.asList("sub2.1", "sub2.2"));
        for (SubEntity s : root.getList()) {
            Assertions.assertTrue((boolean)expectedSub.remove(s.getSubValue()));
            Assertions.assertEquals((Object)root, (Object)s.getParent());
        }
        list = (List)this.repo.findByValueWithSubEntity("five").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"five", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)5, (int)root.getList().size());
        expectedSub = new LinkedList();
        expectedSub.addAll(Arrays.asList("sub5.1", "sub5.2", "sub5.3", "sub5.4", "sub5.5"));
        for (SubEntity s : root.getList()) {
            Assertions.assertTrue((boolean)expectedSub.remove(s.getSubValue()));
            Assertions.assertEquals((Object)root, (Object)s.getParent());
        }
        list = (List)this.repo.findBySubValue("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo.findBySubValue("sub1.1").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"one", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)1, (int)root.getList().size());
        Assertions.assertEquals((Object)"sub1.1", (Object)root.getList().get(0).getSubValue());
        Assertions.assertEquals((Object)root, (Object)root.getList().get(0).getParent());
        list = (List)this.repo.findBySubValue("sub2.1").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"two", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)2, (int)root.getList().size());
        expectedSub = new LinkedList();
        expectedSub.addAll(Arrays.asList("sub2.1", "sub2.2"));
        for (SubEntity s : root.getList()) {
            Assertions.assertTrue((boolean)expectedSub.remove(s.getSubValue()));
            Assertions.assertEquals((Object)root, (Object)s.getParent());
        }
        list = (List)this.repo.findBySubValue("sub5.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"five", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)5, (int)root.getList().size());
        expectedSub = new LinkedList();
        expectedSub.addAll(Arrays.asList("sub5.1", "sub5.2", "sub5.3", "sub5.4", "sub5.5"));
        for (SubEntity s : root.getList()) {
            Assertions.assertTrue((boolean)expectedSub.remove(s.getSubValue()));
            Assertions.assertEquals((Object)root, (Object)s.getParent());
        }
        list = (List)this.repo.findBySubValueStartsWith("sub5", 0L, 10L).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        root = (RootEntity)list.get(0);
        Assertions.assertEquals((Object)"five", (Object)root.getValue());
        Assertions.assertNotNull(root.getList());
        Assertions.assertEquals((int)5, (int)root.getList().size());
        expectedSub = new LinkedList();
        expectedSub.addAll(Arrays.asList("sub5.1", "sub5.2", "sub5.3", "sub5.4", "sub5.5"));
        for (SubEntity s : root.getList()) {
            Assertions.assertTrue((boolean)expectedSub.remove(s.getSubValue()));
            Assertions.assertEquals((Object)root, (Object)s.getParent());
        }
        list = (List)this.repo.findBySubValueStartsWith("sub", 0L, 10L).collectList().block();
        Assertions.assertEquals((int)3, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 0L, 1L).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 0L, 2L).collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 0L, 3L).collectList().block();
        Assertions.assertEquals((int)3, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 1L, 1L).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 1L, 2L).collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 1L, 3L).collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 2L, 1L).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 2L, 2L).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        list = (List)this.repo.findBySubValueStartsWith("sub", 3L, 1L).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        Assertions.assertEquals((int)4, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)8, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo.deleteAll((Iterable)this.repo.findByValueWithSubEntity("two").collectList().block()).block();
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)6, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo.deleteAll((Iterable)this.repo.findByValueWithSubEntity("zero").collectList().block()).block();
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)6, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo.deleteAll((Iterable)this.repo.findByValueWithSubEntity("five").collectList().block()).block();
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo.deleteAll((Iterable)this.repo.findByValueWithSubEntity("one").collectList().block()).block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testHavingSubValueEqualsToValue() {
        RootEntity root = new RootEntity();
        root.setValue("zero");
        this.repo.save(root).block();
        root = new RootEntity();
        root.setValue("one");
        root.setList(new LinkedList<SubEntity>());
        SubEntity sub = new SubEntity();
        sub.setSubValue("one");
        root.getList().add(sub);
        this.repo.save(root).block();
        root = new RootEntity();
        root.setValue("two");
        root.setList(new LinkedList<SubEntity>());
        sub = new SubEntity();
        sub.setSubValue("one");
        root.getList().add(sub);
        this.repo.save(root).block();
        root = new RootEntity();
        root.setValue("three");
        root.setList(new LinkedList<SubEntity>());
        sub = new SubEntity();
        sub.setSubValue("one");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("two");
        root.getList().add(sub);
        this.repo.save(root).block();
        root = new RootEntity();
        root.setValue("four");
        root.setList(new LinkedList<SubEntity>());
        sub = new SubEntity();
        sub.setSubValue("one");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("two");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("three");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("four");
        root.getList().add(sub);
        sub = new SubEntity();
        sub.setSubValue("five");
        root.getList().add(sub);
        this.repo.save(root).block();
        List list = (List)this.repo.havingSubValueEqualsToValue().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        RootEntity r1 = (RootEntity)list.get(0);
        RootEntity r2 = (RootEntity)list.get(1);
        if ("one".equals(r1.getValue())) {
            Assertions.assertEquals((int)1, (int)r1.getList().size());
            Assertions.assertEquals((Object)"four", (Object)r2.getValue());
            Assertions.assertEquals((int)5, (int)r2.getList().size());
        } else if ("four".equals(r1.getValue())) {
            Assertions.assertEquals((int)5, (int)r1.getList().size());
            Assertions.assertEquals((Object)"one", (Object)r2.getValue());
            Assertions.assertEquals((int)1, (int)r2.getList().size());
        } else {
            throw new AssertionError((Object)("Unexpected value " + r1.getValue()));
        }
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)9, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo.deleteAll((Publisher)this.repo.findBySubValue("two")).block();
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo.deleteAll().block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testMultipleSubElements() {
        RootEntity root1 = new RootEntity();
        root1.setValue("one");
        RootEntity root2 = new RootEntity();
        root2.setValue("two");
        SubEntity sub1_1 = new SubEntity();
        sub1_1.setSubValue("1.1");
        SubEntity sub1_2 = new SubEntity();
        sub1_2.setSubValue("1.2");
        SubEntity sub1_3 = new SubEntity();
        sub1_3.setSubValue("1.3");
        SubEntity2 sub2_1 = new SubEntity2("2.1");
        SubEntity2 sub2_2 = new SubEntity2("2.2");
        SubEntity2 sub2_3 = new SubEntity2("2.3");
        SubEntity3 sub3_1 = new SubEntity3();
        sub3_1.setSubValue("3.1");
        SubEntity3 sub3_2 = new SubEntity3();
        sub3_2.setSubValue("3.2");
        SubEntity3 sub3_3 = new SubEntity3();
        sub3_3.setSubValue("3.3");
        root1.setList(Arrays.asList(sub1_1, sub1_2));
        root2.setList(Arrays.asList(sub1_3));
        root1.setList2(Arrays.asList(sub2_1, sub2_2));
        root2.setList2(Arrays.asList(sub2_3));
        root1.setList3(Arrays.asList(sub3_1, sub3_2));
        root2.setList3(Arrays.asList(sub3_3));
        this.repo.saveAll(Arrays.asList(root1, root2)).collectList().block();
        List list = (List)this.repo.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertNull(((RootEntity)list.get(0)).getList());
        Assertions.assertNull(((RootEntity)list.get(0)).getList2());
        Assertions.assertNull(((RootEntity)list.get(0)).getList3());
        Assertions.assertNull(((RootEntity)list.get(1)).getList());
        Assertions.assertNull(((RootEntity)list.get(1)).getList2());
        Assertions.assertNull(((RootEntity)list.get(1)).getList3());
        if ("one".equals(((RootEntity)list.get(0)).getValue())) {
            root1 = (RootEntity)list.get(0);
            root2 = (RootEntity)list.get(1);
        } else {
            root1 = (RootEntity)list.get(1);
            root2 = (RootEntity)list.get(0);
        }
        Assertions.assertEquals((int)2, (int)((List)root1.lazyGetList().collectList().block()).size());
        Assertions.assertEquals((int)2, (int)((List)root1.lazyGetList2().collectList().block()).size());
        Assertions.assertEquals((int)2, (int)((List)root1.lazyGetList3().collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)root2.lazyGetList().collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)root2.lazyGetList2().collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)root2.lazyGetList3().collectList().block()).size());
        for (SubEntity subEntity : root1.getList()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity.getParent());
        }
        for (SubEntity subEntity : root2.getList()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity.getParent());
        }
        for (SubEntity2 subEntity2 : root1.getList2()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity2.getParent());
        }
        for (SubEntity2 subEntity2 : root2.getList2()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity2.getParent());
        }
        for (SubEntity3 subEntity3 : root1.getList3()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity3.getParent());
        }
        for (SubEntity3 subEntity3 : root2.getList3()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity3.getParent());
        }
        Assertions.assertEquals((long)1L, (Long)root1.getList3().stream().filter(s -> "3.1".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)1L, (Long)root1.getList3().stream().filter(s -> "3.2".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)1L, (Long)root2.getList3().stream().filter(s -> "3.3".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(SubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(SubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        list = (List)this.repo.findAllFull().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList2());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList3());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList2());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList3());
        if ("one".equals(((RootEntity)list.get(0)).getValue())) {
            root1 = (RootEntity)list.get(0);
            root2 = (RootEntity)list.get(1);
        } else {
            root1 = (RootEntity)list.get(1);
            root2 = (RootEntity)list.get(0);
        }
        Assertions.assertEquals((int)2, (int)root1.getList().size());
        Assertions.assertEquals((int)2, (int)root1.getList2().size());
        Assertions.assertEquals((int)2, (int)root1.getList3().size());
        Assertions.assertEquals((int)1, (int)root2.getList().size());
        Assertions.assertEquals((int)1, (int)root2.getList2().size());
        Assertions.assertEquals((int)1, (int)root2.getList3().size());
        for (SubEntity subEntity : root1.getList()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity.getParent());
        }
        for (SubEntity subEntity : root2.getList()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity.getParent());
        }
        for (SubEntity2 subEntity2 : root1.getList2()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity2.getParent());
        }
        for (SubEntity2 subEntity2 : root2.getList2()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity2.getParent());
        }
        for (SubEntity3 subEntity3 : root1.getList3()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity3.getParent());
        }
        for (SubEntity3 subEntity3 : root2.getList3()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity3.getParent());
        }
        Assertions.assertEquals((long)1L, (Long)root1.getList3().stream().filter(s -> "3.1".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)1L, (Long)root1.getList3().stream().filter(s -> "3.2".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)1L, (Long)root2.getList3().stream().filter(s -> "3.3".equals(s.getSubValue())).findFirst().get().getVersion());
        root1.getList3().stream().filter(s -> "3.2".equals(s.getSubValue())).findFirst().get().setSubValue("3.2bis");
        this.repo.saveAll(Arrays.asList(root1, root2)).collectList().block();
        list = (List)this.repo.findAllFull().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList2());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList3());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList2());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList3());
        if ("one".equals(((RootEntity)list.get(0)).getValue())) {
            root1 = (RootEntity)list.get(0);
            root2 = (RootEntity)list.get(1);
        } else {
            root1 = (RootEntity)list.get(1);
            root2 = (RootEntity)list.get(0);
        }
        Assertions.assertEquals((int)2, (int)root1.getList().size());
        Assertions.assertEquals((int)2, (int)root1.getList2().size());
        Assertions.assertEquals((int)2, (int)root1.getList3().size());
        Assertions.assertEquals((int)1, (int)root2.getList().size());
        Assertions.assertEquals((int)1, (int)root2.getList2().size());
        Assertions.assertEquals((int)1, (int)root2.getList3().size());
        Assertions.assertEquals((long)1L, (Long)root1.getList3().stream().filter(s -> "3.1".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)2L, (Long)root1.getList3().stream().filter(s -> "3.2bis".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)1L, (Long)root2.getList3().stream().filter(s -> "3.3".equals(s.getSubValue())).findFirst().get().getVersion());
        root1.getList3().stream().filter(s -> "3.2bis".equals(s.getSubValue())).findFirst().get().setSubValue("3.2");
        this.repo.saveAll(Arrays.asList(root1, root2)).collectList().block();
        list = (List)this.repo.findAllFull().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList2());
        Assertions.assertNotNull(((RootEntity)list.get(0)).getList3());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList2());
        Assertions.assertNotNull(((RootEntity)list.get(1)).getList3());
        if ("one".equals(((RootEntity)list.get(0)).getValue())) {
            root1 = (RootEntity)list.get(0);
            root2 = (RootEntity)list.get(1);
        } else {
            root1 = (RootEntity)list.get(1);
            root2 = (RootEntity)list.get(0);
        }
        Assertions.assertEquals((int)2, (int)root1.getList().size());
        Assertions.assertEquals((int)2, (int)root1.getList2().size());
        Assertions.assertEquals((int)2, (int)root1.getList3().size());
        Assertions.assertEquals((int)1, (int)root2.getList().size());
        Assertions.assertEquals((int)1, (int)root2.getList2().size());
        Assertions.assertEquals((int)1, (int)root2.getList3().size());
        Assertions.assertEquals((long)1L, (Long)root1.getList3().stream().filter(s -> "3.1".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)3L, (Long)root1.getList3().stream().filter(s -> "3.2".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)1L, (Long)root2.getList3().stream().filter(s -> "3.3".equals(s.getSubValue())).findFirst().get().getVersion());
        sub1_1 = root1.getList().stream().filter(s -> "1.1".equals(s.getSubValue())).findFirst().get();
        Assertions.assertTrue((boolean)root1.getList().remove(sub1_1));
        sub2_2 = root1.getList2().stream().filter(s -> "2.2".equals(s.getSubValue())).findFirst().get();
        Assertions.assertTrue((boolean)root1.getList2().remove(sub2_2));
        sub3_3 = root2.getList3().stream().filter(s -> "3.3".equals(s.getSubValue())).findFirst().get();
        Assertions.assertTrue((boolean)root2.getList3().remove(sub3_3));
        this.repo.saveAll(Arrays.asList(root1, root2)).collectList().block();
        list = (List)this.repo.findAllFull().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        if ("one".equals(((RootEntity)list.get(0)).getValue())) {
            root1 = (RootEntity)list.get(0);
            root2 = (RootEntity)list.get(1);
        } else {
            root1 = (RootEntity)list.get(1);
            root2 = (RootEntity)list.get(0);
        }
        Assertions.assertEquals((int)1, (int)root1.getList().size());
        Assertions.assertEquals((int)1, (int)root1.getList2().size());
        Assertions.assertEquals((int)2, (int)root1.getList3().size());
        Assertions.assertEquals((int)1, (int)root2.getList().size());
        Assertions.assertEquals((int)1, (int)root2.getList2().size());
        Assertions.assertEquals((int)0, (int)root2.getList3().size());
        root2.getList().add(sub1_1);
        root2.getList2().add(sub2_2);
        root1.getList3().add(sub3_3);
        this.repo.saveAll(Arrays.asList(root1, root2)).collectList().block();
        list = (List)this.repo.findAllFull().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        if ("one".equals(((RootEntity)list.get(0)).getValue())) {
            root1 = (RootEntity)list.get(0);
            root2 = (RootEntity)list.get(1);
        } else {
            root1 = (RootEntity)list.get(1);
            root2 = (RootEntity)list.get(0);
        }
        Assertions.assertEquals((int)1, (int)root1.getList().size());
        Assertions.assertEquals((int)1, (int)root1.getList2().size());
        Assertions.assertEquals((int)3, (int)root1.getList3().size());
        Assertions.assertEquals((int)2, (int)root2.getList().size());
        Assertions.assertEquals((int)2, (int)root2.getList2().size());
        Assertions.assertEquals((int)0, (int)root2.getList3().size());
        for (SubEntity subEntity : root1.getList()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity.getParent());
        }
        for (SubEntity subEntity : root2.getList()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity.getParent());
        }
        for (SubEntity2 subEntity2 : root1.getList2()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity2.getParent());
        }
        for (SubEntity2 subEntity2 : root2.getList2()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity2.getParent());
        }
        for (SubEntity3 subEntity3 : root1.getList3()) {
            Assertions.assertEquals((Object)root1, (Object)subEntity3.getParent());
        }
        for (SubEntity3 subEntity3 : root2.getList3()) {
            Assertions.assertEquals((Object)root2, (Object)subEntity3.getParent());
        }
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(SubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(SubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((long)1L, (Long)root1.getList3().stream().filter(s -> "3.1".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)3L, (Long)root1.getList3().stream().filter(s -> "3.2".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)3L, (Long)root1.getList3().stream().filter(s -> "3.3".equals(s.getSubValue())).findFirst().get().getVersion());
        sub1_2 = root1.getList().stream().filter(s -> "1.2".equals(s.getSubValue())).findFirst().get();
        root1.getList().remove(sub1_2);
        sub1_1 = root2.getList().stream().filter(s -> "1.1".equals(s.getSubValue())).findFirst().get();
        root2.getList().remove(sub1_1);
        sub2_1 = root1.getList2().stream().filter(s -> "2.1".equals(s.getSubValue())).findFirst().get();
        root1.getList2().remove(sub2_1);
        sub2_3 = root2.getList2().stream().filter(s -> "2.3".equals(s.getSubValue())).findFirst().get();
        root2.getList2().remove(sub2_3);
        sub3_1 = root1.getList3().stream().filter(s -> "3.1".equals(s.getSubValue())).findFirst().get();
        root1.getList3().remove(sub3_1);
        this.repo.saveAll(Arrays.asList(root1, root2)).collectList().block();
        list = (List)this.repo.findAllFull().collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
        if ("one".equals(((RootEntity)list.get(0)).getValue())) {
            root1 = (RootEntity)list.get(0);
            root2 = (RootEntity)list.get(1);
        } else {
            root1 = (RootEntity)list.get(1);
            root2 = (RootEntity)list.get(0);
        }
        Assertions.assertEquals((int)0, (int)root1.getList().size());
        Assertions.assertEquals((int)0, (int)root1.getList2().size());
        Assertions.assertEquals((int)2, (int)root1.getList3().size());
        Assertions.assertEquals((int)1, (int)root2.getList().size());
        Assertions.assertEquals((int)1, (int)root2.getList2().size());
        Assertions.assertEquals((int)0, (int)root2.getList3().size());
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(SubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        List list3 = (List)SelectQuery.from(SubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)3, (int)list3.size());
        Assertions.assertEquals((long)2L, (Long)list3.stream().filter(s -> "3.1".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)3L, (Long)list3.stream().filter(s -> "3.2".equals(s.getSubValue())).findFirst().get().getVersion());
        Assertions.assertEquals((long)3L, (Long)list3.stream().filter(s -> "3.3".equals(s.getSubValue())).findFirst().get().getVersion());
    }

    @Test
    public void testDeleteWithLazyCollection() {
        RootEntity root1 = new RootEntity();
        root1.setValue("one");
        RootEntity root2 = new RootEntity();
        root2.setValue("two");
        SubEntity sub1_1 = new SubEntity();
        sub1_1.setSubValue("1.1");
        SubEntity sub1_2 = new SubEntity();
        sub1_2.setSubValue("1.2");
        SubEntity2 sub2_1 = new SubEntity2("2.1");
        SubEntity2 sub2_2 = new SubEntity2("2.2");
        SubEntity3 sub3_1 = new SubEntity3();
        sub3_1.setSubValue("3.1");
        SubEntity3 sub3_2 = new SubEntity3();
        sub3_2.setSubValue("3.2");
        root1.setList(Arrays.asList(sub1_1, sub1_2));
        root1.setList2(Arrays.asList(sub2_1));
        root1.setList3(Arrays.asList(sub3_1));
        root2.setList2(Arrays.asList(sub2_2));
        root2.setList3(Arrays.asList(sub3_2));
        this.repo.saveAll(Arrays.asList(root1, root2)).collectList().block();
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(SubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(SubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        root1 = (RootEntity)this.repo.findByValue("one").blockFirst();
        Assertions.assertNull(root1.getList());
        this.repo.delete(root1).block();
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(RootEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(SubEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(SubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)2, (int)((List)SelectQuery.from(SubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testConditions() {
        RootEntity root1 = new RootEntity();
        root1.setValue("one");
        RootEntity root2 = new RootEntity();
        root2.setValue("two");
        RootEntity root3 = new RootEntity();
        root3.setValue("abocd");
        SubEntity sub1_1 = new SubEntity();
        sub1_1.setSubValue("1.1");
        SubEntity sub1_2 = new SubEntity();
        sub1_2.setSubValue("1.2");
        SubEntity sub1_3 = new SubEntity();
        sub1_3.setSubValue("1.3");
        SubEntity2 sub2_1 = new SubEntity2("2.1");
        SubEntity2 sub2_2 = new SubEntity2("2.2");
        SubEntity3 sub3_1 = new SubEntity3();
        sub3_1.setSubValue("3.1");
        SubEntity3 sub3_2 = new SubEntity3();
        sub3_2.setSubValue("3.2");
        SubEntity3 sub3_3 = new SubEntity3();
        sub3_3.setSubValue("3.3");
        root1.setList(Arrays.asList(sub1_1));
        root1.setList2(Arrays.asList(sub2_1));
        root1.setList3(Arrays.asList(sub3_1));
        root2.setList(Arrays.asList(sub1_3));
        root2.setList2(Arrays.asList(sub2_2));
        root2.setList3(Arrays.asList(sub3_2));
        root3.setList(Arrays.asList(sub1_2));
        root3.setList3(Arrays.asList(sub3_3));
        this.repo.saveAll(Arrays.asList(root1, root2, root3)).collectList().block();
        List subs = (List)SelectQuery.from(SubEntity.class, (String)"sub1").join("sub1", "parent", "root").join("root", "list3", "sub3").where(Criteria.property((String)"sub3", (String)"subValue").isNotNull().and(Criteria.property((String)"root", (String)"value").like((Object)"%o%")).and(Criteria.property((String)"sub1", (String)"subValue").like((Object)"%.2").or(Criteria.property((String)"sub3", (String)"subValue").is((Object)"3.1")))).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)2, (int)subs.size());
        Assertions.assertTrue((boolean)subs.stream().anyMatch(sub -> "1.1".equals(sub.getSubValue())));
        Assertions.assertTrue((boolean)subs.stream().anyMatch(sub -> "1.2".equals(sub.getSubValue())));
    }

    @Test
    public void testOrderBy() {
        RootEntity root1 = new RootEntity();
        root1.setValue("root1");
        RootEntity root2 = new RootEntity();
        root2.setValue("root2");
        RootEntity root3 = new RootEntity();
        root3.setValue("root3");
        SubEntity sub1_1 = new SubEntity();
        sub1_1.setSubValue("1.1");
        SubEntity sub1_2 = new SubEntity();
        sub1_2.setSubValue("1.2");
        SubEntity sub1_3 = new SubEntity();
        sub1_3.setSubValue("1.3");
        root1.setList(Arrays.asList(sub1_1, sub1_2, sub1_3));
        SubEntity sub2_1 = new SubEntity();
        sub2_1.setSubValue("2.1");
        SubEntity sub2_2 = new SubEntity();
        sub2_2.setSubValue("2.2");
        SubEntity sub2_3 = new SubEntity();
        sub2_3.setSubValue("2.3");
        root2.setList(Arrays.asList(sub2_1, sub2_2, sub2_3));
        SubEntity sub3_1 = new SubEntity();
        sub3_1.setSubValue("3.1");
        SubEntity sub3_2 = new SubEntity();
        sub3_2.setSubValue("3.2");
        SubEntity sub3_3 = new SubEntity();
        sub3_3.setSubValue("3.3");
        root3.setList(Arrays.asList(sub3_1, sub3_2, sub3_3));
        this.repo.saveAll(Arrays.asList(root1, root2, root3)).blockLast();
        List list = (List)SelectQuery.from(RootEntity.class, (String)"root").join("root", "list", "sub").orderBy("value", true).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)"root1", (Object)((RootEntity)list.get(0)).getValue());
        Assertions.assertEquals((Object)"root2", (Object)((RootEntity)list.get(1)).getValue());
        Assertions.assertEquals((Object)"root3", (Object)((RootEntity)list.get(2)).getValue());
        list = (List)SelectQuery.from(RootEntity.class, (String)"root").join("root", "list", "sub").orderBy("value", false).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)"root3", (Object)((RootEntity)list.get(0)).getValue());
        Assertions.assertEquals((Object)"root2", (Object)((RootEntity)list.get(1)).getValue());
        Assertions.assertEquals((Object)"root1", (Object)((RootEntity)list.get(2)).getValue());
    }
}

