/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.GeneratedValue;
import net.lecousin.reactive.data.relational.annotations.Indexes;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.Index;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.Sequence;
import net.lecousin.reactive.data.relational.schema.Table;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SchemaBuilderFromEntities {
    protected LcReactiveDataRelationalClient client;
    protected RelationalDatabaseSchema schema = new RelationalDatabaseSchema();

    public SchemaBuilderFromEntities(LcReactiveDataRelationalClient client) {
        this.client = client;
    }

    public RelationalDatabaseSchema getSchema() {
        return this.schema;
    }

    public RelationalDatabaseSchema build(Collection<Class<?>> entities) {
        for (Class<?> entity : entities) {
            this.schema.add(this.buildTable(entity));
            this.addSequences(entity);
        }
        for (Class<?> entity : entities) {
            this.addForeignKeys(entity);
        }
        return this.schema;
    }

    protected String getTableName(RelationalPersistentEntity<?> entityType) {
        return entityType.getTableName().toSql(this.client.getDialect().getIdentifierProcessing());
    }

    protected String getColumnName(RelationalPersistentProperty property) {
        return property.getColumnName().toSql(this.client.getDialect().getIdentifierProcessing());
    }

    protected Table buildTable(Class<?> entity) {
        Indexes indexesAnnotation;
        RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(entity);
        Table table = new Table(this.getTableName(entityType));
        for (RelationalPersistentProperty property : entityType) {
            try {
                table.add(this.buildColumn(property));
            }
            catch (Exception e) {
                throw new MappingException("Error building schema for entity " + entityType.getName() + " on property " + property.getName(), (Throwable)e);
            }
        }
        CompositeId compositeId = (CompositeId)entityType.findAnnotation(CompositeId.class);
        if (compositeId != null) {
            Index index = new Index(compositeId.indexName());
            index.setUnique(true);
            for (String propertyName : compositeId.properties()) {
                RelationalPersistentProperty property = (RelationalPersistentProperty)entityType.getRequiredPersistentProperty(propertyName);
                index.addColumn(property.getColumnName().toSql(this.client.getDialect().getIdentifierProcessing()));
            }
            table.add(index);
        }
        LinkedList<net.lecousin.reactive.data.relational.annotations.Index> indexes = new LinkedList<net.lecousin.reactive.data.relational.annotations.Index>();
        net.lecousin.reactive.data.relational.annotations.Index indexAnnotation = (net.lecousin.reactive.data.relational.annotations.Index)entityType.findAnnotation(net.lecousin.reactive.data.relational.annotations.Index.class);
        if (indexAnnotation != null) {
            indexes.add(indexAnnotation);
        }
        if ((indexesAnnotation = (Indexes)entityType.findAnnotation(Indexes.class)) != null) {
            Collections.addAll(indexes, indexesAnnotation.value());
        }
        for (net.lecousin.reactive.data.relational.annotations.Index i : indexes) {
            Index index = new Index(i.name());
            index.setUnique(i.unique());
            for (String propertyName : i.properties()) {
                RelationalPersistentProperty property = (RelationalPersistentProperty)entityType.getRequiredPersistentProperty(propertyName);
                index.addColumn(this.getColumnName(property));
            }
            table.add(index);
        }
        return table;
    }

    protected Column buildColumn(RelationalPersistentProperty property) {
        Column col = new Column(property.getColumnName().toSql(this.client.getDialect().getIdentifierProcessing()));
        if (property.isAnnotationPresent(Id.class)) {
            col.setPrimaryKey(true);
        }
        col.setNullable(ModelUtils.isNullable(property));
        GeneratedValue generated = (GeneratedValue)property.findAnnotation(GeneratedValue.class);
        if (generated != null) {
            if (GeneratedValue.Strategy.AUTO_INCREMENT.equals((Object)generated.strategy())) {
                col.setAutoIncrement(true);
            } else if (GeneratedValue.Strategy.RANDOM_UUID.equals((Object)generated.strategy())) {
                col.setRandomUuid(true);
            }
        }
        Class type = property.getType();
        if (property.isAnnotationPresent(ForeignKey.class)) {
            RelationalPersistentEntity entity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(type);
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty();
            type = idProperty.getType();
        }
        ColumnDefinition def = (ColumnDefinition)property.findAnnotation(ColumnDefinition.class);
        col.setType(this.client.getSchemaDialect().getColumnType(col, type, def));
        return col;
    }

    protected void addForeignKeys(Class<?> entity) {
        RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(entity);
        Iterator keys = entityType.getPersistentProperties(ForeignKey.class).iterator();
        if (!keys.hasNext()) {
            return;
        }
        Table table = this.schema.getTable(this.getTableName(entityType));
        do {
            RelationalPersistentProperty fkProperty = (RelationalPersistentProperty)keys.next();
            Column fkColumn = table.getColumn(this.getColumnName(fkProperty));
            RelationalPersistentEntity foreignType = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(fkProperty.getType());
            RelationalPersistentProperty foreignId = (RelationalPersistentProperty)foreignType.getRequiredIdProperty();
            Table foreignTable = this.schema.getTable(this.getTableName(foreignType));
            Column foreignColumn = foreignTable.getColumn(this.getColumnName(foreignId));
            fkColumn.setForeignKeyReferences((Pair<Table, Column>)Pair.of((Object)foreignTable, (Object)foreignColumn));
        } while (keys.hasNext());
    }

    protected void addSequences(Class<?> entity) {
        RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(entity);
        for (RelationalPersistentProperty property : entityType.getPersistentProperties(GeneratedValue.class)) {
            GeneratedValue annotation = (GeneratedValue)property.getRequiredAnnotation(GeneratedValue.class);
            if (!annotation.strategy().equals((Object)GeneratedValue.Strategy.SEQUENCE)) continue;
            Assert.isTrue((boolean)StringUtils.hasText((String)annotation.sequence()), (String)"Sequence name must be specified");
            try {
                this.schema.getSequence(annotation.sequence());
            }
            catch (NoSuchElementException e) {
                this.schema.add(new Sequence(annotation.sequence()));
            }
        }
    }
}

