/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.enhance;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.enhance.Enhancer;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.CollectionFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EntityState {
    private LcReactiveDataRelationalClient client;
    private RelationalPersistentEntity<?> entityType;
    private boolean persisted = false;
    private boolean loaded = false;
    private Mono<?> loading = null;
    private Map<String, Object> persistedValues = new HashMap<String, Object>();
    private Set<String> modifiedFields = new HashSet<String>();
    private Set<String> foreignTablesLoaded = new HashSet<String>();

    public EntityState(LcReactiveDataRelationalClient client, RelationalPersistentEntity<?> entityType) {
        this.client = client;
        this.entityType = entityType;
    }

    public static EntityState get(Object entity, LcReactiveDataRelationalClient client) {
        return EntityState.get(entity, client, null);
    }

    public static EntityState get(Object entity, LcReactiveDataRelationalClient client, @Nullable RelationalPersistentEntity<?> entityType) {
        try {
            Field fieldInfo = Enhancer.entities.get(entity.getClass());
            EntityState state = (EntityState)fieldInfo.get(entity);
            if (state == null) {
                RelationalPersistentEntity type = entityType == null ? (RelationalPersistentEntity)client.getMappingContext().getRequiredPersistentEntity(entity.getClass()) : entityType;
                state = new EntityState(client, type);
                fieldInfo.set(entity, state);
            }
            return state;
        }
        catch (Exception e) {
            throw new ModelAccessException("Unexpected error accessing entity state for " + entity, e);
        }
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public boolean isFieldModified(String name) {
        return this.modifiedFields.contains(name);
    }

    @Nullable
    public Object getPersistedValue(String fieldName) {
        return this.persistedValues.get(fieldName);
    }

    public void deleted() {
        this.persisted = false;
        this.loaded = false;
        this.loading = null;
        this.persistedValues.clear();
        this.modifiedFields.clear();
        this.foreignTablesLoaded.clear();
    }

    public void lazyLoaded() {
        this.persisted = true;
        this.loaded = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public synchronized <T> Mono<T> loading(Supplier<Mono<T>> doLoading) {
        if (this.loading != null) {
            return this.loading;
        }
        this.loading = doLoading.get().doOnSuccess(entity -> {
            this.loading = null;
            this.loaded(entity);
        }).cache();
        return this.loading;
    }

    @Nullable
    public <T> Mono<T> getLoading() {
        return this.loading;
    }

    public <T> void loaded(T entity) {
        this.persisted = true;
        this.loaded = true;
        this.updatePersistedValues(entity);
    }

    private void updatePersistedValues(Object entity) {
        this.modifiedFields.clear();
        this.persistedValues.clear();
        for (Field f : entity.getClass().getDeclaredFields()) {
            if ("_lcState".equals(f.getName()) || f.isAnnotationPresent(Transient.class) || f.isAnnotationPresent(Autowired.class) || f.isAnnotationPresent(Value.class)) continue;
            f.setAccessible(true);
            try {
                this.savePersistedValue(f, f.get(entity));
            }
            catch (Exception e) {
                throw new ModelAccessException("Error saving value for field " + f.getName(), e);
            }
        }
    }

    private void savePersistedValue(Field field, Object value) {
        if (value != null && ModelUtils.isCollection(field)) {
            LinkedList list = new LinkedList();
            list.addAll(ModelUtils.getAsCollection(value));
            this.persistedValues.put(field.getName(), list);
        } else {
            this.persistedValues.put(field.getName(), value);
        }
    }

    public <T> Mono<T> load(T entity) {
        return this.client.lazyLoad(entity, this, this.entityType);
    }

    public void fieldSet(String fieldName, Object newValue) {
        if (Objects.equals(newValue, this.persistedValues.get(fieldName))) {
            this.modifiedFields.remove(fieldName);
            return;
        }
        this.modifiedFields.add(fieldName);
    }

    public void fieldSet(String fieldName, boolean newValue) {
        this.fieldSet(fieldName, (Object)newValue);
    }

    public void fieldSet(String fieldName, byte newValue) {
        this.fieldSet(fieldName, (Object)newValue);
    }

    public void fieldSet(String fieldName, short newValue) {
        this.fieldSet(fieldName, (Object)newValue);
    }

    public void fieldSet(String fieldName, int newValue) {
        this.fieldSet(fieldName, (Object)newValue);
    }

    public void fieldSet(String fieldName, long newValue) {
        this.fieldSet(fieldName, (Object)newValue);
    }

    public void fieldSet(String fieldName, float newValue) {
        this.fieldSet(fieldName, Float.valueOf(newValue));
    }

    public void fieldSet(String fieldName, double newValue) {
        this.fieldSet(fieldName, (Object)newValue);
    }

    public void fieldSet(String fieldName, char newValue) {
        this.fieldSet(fieldName, Character.valueOf(newValue));
    }

    public void setPersistedField(Object instance, Field field, Object value, boolean saved) {
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new ModelAccessException("Error setting field " + field.getName() + " on " + instance, e);
        }
        if (Objects.equals(value, this.persistedValues.get(field.getName()))) {
            this.modifiedFields.remove(field.getName());
        } else if (saved) {
            this.modifiedFields.remove(field.getName());
            this.savePersistedValue(field, value);
        } else {
            this.modifiedFields.add(field.getName());
        }
    }

    public void restorePersistedValue(Object instance, Field field) {
        field.setAccessible(true);
        Object value = this.persistedValues.get(field.getName());
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new ModelAccessException("Error setting field " + field.getName() + " on " + instance, e);
        }
        this.modifiedFields.remove(field.getName());
    }

    public void setForeignTableField(Object instance, Field field, Object value, boolean saved) {
        this.setPersistedField(instance, field, value, saved);
        this.foreignTablesLoaded.add(field.getName());
    }

    @Nullable
    public <T> MutableObject<T> getForeignTableField(Object entity, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        return this.getForeignTableField(entity, entity.getClass().getDeclaredField(fieldName));
    }

    @Nullable
    public <T> MutableObject<T> getForeignTableField(Object entity, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        Object instance = field.get(entity);
        if (instance != null) {
            return new MutableObject(instance);
        }
        if (this.foreignTablesLoaded.contains(field.getName()) || this.persistedValues.containsKey(field.getName()) && this.persistedValues.get(field.getName()) != null) {
            return new MutableObject(null);
        }
        return null;
    }

    public <T> Mono<T> lazyGetForeignTableField(Object entity, String fieldName, String joinKey) {
        try {
            MutableObject<T> instance = this.getForeignTableField(entity, fieldName);
            if (instance != null) {
                return instance.getValue() != null ? Mono.just((Object)instance.getValue()) : Mono.empty();
            }
            this.foreignTablesLoaded.add(fieldName);
            Field field = entity.getClass().getDeclaredField(fieldName);
            Object id = ModelUtils.getRequiredId(entity, this.entityType, null);
            RelationalPersistentEntity elementEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(field.getType());
            RelationalPersistentProperty fkProperty = (RelationalPersistentProperty)elementEntity.getRequiredPersistentProperty(joinKey);
            return SelectQuery.from(field.getType(), "entity").where(Criteria.property("entity", fkProperty.getName()).is(id)).execute(this.client).next().doOnNext(inst -> {
                try {
                    field.setAccessible(true);
                    field.set(entity, inst);
                    this.savePersistedValue(field, inst);
                    Field fk = field.getType().getDeclaredField(joinKey);
                    fk.setAccessible(true);
                    fk.set(inst, entity);
                }
                catch (Exception e) {
                    throw new ModelAccessException("Unable to set " + fieldName, e);
                }
            });
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public <T> Flux<T> lazyGetForeignTableCollectionField(Object entity, String fieldName, String joinKey) {
        try {
            MutableObject<T> instance = this.getForeignTableField(entity, fieldName);
            if (instance != null) {
                if (instance.getValue() == null) {
                    return Flux.empty();
                }
                Object collection = instance.getValue();
                if (collection.getClass().isArray()) {
                    return Flux.fromArray((Object[])((Object[])collection));
                }
                return Flux.fromIterable((Iterable)((Iterable)collection));
            }
            this.foreignTablesLoaded.add(fieldName);
            Field field = entity.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object id = ModelUtils.getRequiredId(entity, this.entityType, null);
            Class<?> elementType = ModelUtils.getCollectionType(field);
            if (elementType == null) {
                throw new MappingException("Property is not a collection: " + fieldName);
            }
            RelationalPersistentEntity elementEntity = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(elementType);
            RelationalPersistentProperty fkProperty = (RelationalPersistentProperty)elementEntity.getRequiredPersistentProperty(joinKey);
            Flux<?> flux = SelectQuery.from(elementType, "element").where(Criteria.property("element", fkProperty.getName()).is(id)).execute(this.client);
            Field fk = elementType.getDeclaredField(joinKey);
            fk.setAccessible(true);
            if (field.getType().isArray()) {
                return EntityState.toArray(flux, field, entity, elementType, fk);
            }
            return this.toCollection(flux, field, entity, elementType, fk);
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private static <T> Flux<T> toArray(Flux<T> flux, Field field, Object entity, Class<?> elementType, Field fk) {
        return flux.collectList().flatMapMany(list -> {
            Object[] array = list.toArray((Object[])Array.newInstance(elementType, list.size()));
            try {
                field.set(entity, array);
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
            for (Object element : list) {
                try {
                    fk.set(element, entity);
                }
                catch (Exception e) {
                    throw new ModelAccessException("Unable to set field " + fk.getName(), e);
                }
            }
            return Flux.fromIterable((Iterable)list);
        });
    }

    private <T> Flux<T> toCollection(Flux<T> flux, Field field, Object entity, Class<?> elementType, Field fk) throws IllegalAccessException {
        Collection col = CollectionFactory.createCollection(field.getType(), elementType, (int)10);
        field.set(entity, col);
        flux = flux.doOnNext(element -> {
            ((Collection)col).add(element);
            try {
                fk.set(element, entity);
            }
            catch (Exception e) {
                throw new ModelAccessException("Unable to set field " + fk.getName(), e);
            }
        });
        flux = flux.doOnComplete(() -> this.savePersistedValue(field, col));
        return flux;
    }

    public void foreignTableLoaded(Field field, Object value) {
        this.foreignTablesLoaded.add(field.getName());
        this.savePersistedValue(field, value);
    }

    public <T, R> Function<T, R> getFieldMapper(Object entity, String fieldName) {
        try {
            Field field = entity.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return e -> {
                try {
                    return field.get(e);
                }
                catch (Exception err) {
                    throw new ModelAccessException("Unable to access field " + fieldName, err);
                }
            };
        }
        catch (Exception e2) {
            throw new ModelAccessException("Unable to access field " + fieldName, e2);
        }
    }
}

