/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.enhance;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;
import reactor.core.publisher.Mono;

public final class Enhancer {
    private static final Log logger = LogFactory.getLog(Enhancer.class);
    static Map<Class<?>, Field> entities = new HashMap();
    static final String STATE_FIELD_NAME = "_lcState";

    private Enhancer() {
    }

    public static Collection<Class<?>> getEntities() {
        return entities.keySet();
    }

    public static void enhance(Collection<String> entityClasses) {
        ClassPool classPool = ClassPool.getDefault();
        for (String string : entityClasses) {
            Enhancer.enhanceClass(classPool, string);
        }
        for (Class clazz : entities.keySet()) {
            try {
                Field fieldInfo = clazz.getDeclaredField(STATE_FIELD_NAME);
                fieldInfo.setAccessible(true);
                entities.put(clazz, fieldInfo);
            }
            catch (Exception e) {
                throw new ModelAccessException("Error accessing to enhanced class " + clazz.getName(), e);
            }
        }
    }

    private static void enhanceClass(ClassPool classPool, String className) {
        logger.info((Object)("Enhancing entity " + className));
        try {
            CtClass cl = classPool.get(className);
            if (!cl.hasAnnotation(Table.class)) {
                throw new ModelException("Class is not an entity (no @Table annotation): " + className);
            }
            if (Enhancer.hasField(cl, STATE_FIELD_NAME)) {
                logger.warn((Object)("Entity already enhanced: " + className));
                return;
            }
            cl.defrost();
            Enhancer.addStateAttribute(classPool, cl);
            for (CtField field : cl.getDeclaredFields()) {
                if (!Enhancer.isPersistent(field)) continue;
                String accessorSuffix = Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
                Enhancer.processSetter(cl, field, accessorSuffix);
            }
            Enhancer.enhanceLazyMethods(cl, classPool);
            Class<?> neighbor = null;
            try {
                neighbor = Enhancer.class.getClassLoader().loadClass(cl.getPackageName() + ".package-info");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class newClass = neighbor != null ? cl.toClass(neighbor) : cl.toClass();
            entities.put(newClass, null);
        }
        catch (Exception e) {
            throw new ModelAccessException("Unable to enhance entity " + className, e);
        }
    }

    private static boolean isPersistent(CtField field) {
        if (field.hasAnnotation(Transient.class) || field.hasAnnotation(Autowired.class) || field.hasAnnotation(Value.class)) {
            return false;
        }
        return field.hasAnnotation(Id.class) || field.hasAnnotation(Column.class) || field.hasAnnotation(ColumnDefinition.class) || field.hasAnnotation(Version.class) || field.hasAnnotation(ForeignKey.class);
    }

    private static boolean hasField(CtClass cl, String name) {
        try {
            cl.getDeclaredField(name);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static void processSetter(CtClass cl, CtField field, String accessorSuffix) throws CannotCompileException {
        try {
            CtMethod accessor = cl.getDeclaredMethod("set" + accessorSuffix);
            Enhancer.enhanceSetter(field, accessor);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private static void addStateAttribute(ClassPool classPool, CtClass cl) throws CannotCompileException, NotFoundException {
        CtField f = new CtField(classPool.get("net.lecousin.reactive.data.relational.enhance.EntityState"), STATE_FIELD_NAME, cl);
        cl.addField(f);
        ConstPool cpool = cl.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(cpool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation(Transient.class.getName(), cpool);
        attr.addAnnotation(annot);
        f.getFieldInfo().addAttribute((AttributeInfo)attr);
    }

    private static void enhanceSetter(CtField field, CtMethod setter) throws CannotCompileException {
        setter.insertBefore("if ($0._lcState != null) { $0._lcState.fieldSet(\"" + field.getName() + "\", $1); }");
    }

    private static void enhanceLazyMethods(CtClass cl, ClassPool classPool) throws ReflectiveOperationException, CannotCompileException, NotFoundException {
        boolean hasLoadEntity = false;
        for (CtMethod method : cl.getMethods()) {
            if (method.getName().equals("entityLoaded") && method.getParameterTypes().length == 0 && method.getReturnType().getName().equals("boolean")) {
                method.setBody("return $0._lcState != null && $0._lcState.isLoaded();");
                continue;
            }
            if (!method.getName().equals("loadEntity") || method.getParameterTypes().length != 0 || !method.getReturnType().getName().equals(Mono.class.getName())) continue;
            method.setBody("return $0._lcState.load($0);");
            hasLoadEntity = true;
        }
        if (!hasLoadEntity) {
            CtMethod m = CtNewMethod.make((String)"public reactor.core.publisher.Mono loadEntity() { return $0._lcState.load($0); }", (CtClass)cl);
            cl.addMethod(m);
        }
        Enhancer.enhanceLazyGetMethods(cl, classPool);
    }

    private static void enhanceLazyGetMethods(CtClass cl, ClassPool classPool) throws ReflectiveOperationException, CannotCompileException, NotFoundException {
        for (CtMethod method : cl.getMethods()) {
            if (!method.getName().startsWith("lazyGet")) continue;
            Object propertyName = method.getName().substring(7);
            CtField field = cl.getField((String)(propertyName = Character.toLowerCase(((String)propertyName).charAt(0)) + ((String)propertyName).substring(1)));
            ForeignTable ft = (ForeignTable)field.getAnnotation(ForeignTable.class);
            if (ft != null) {
                if (field.getType().isArray() || field.getType().subtypeOf(classPool.get(Collection.class.getName()))) {
                    method.setBody("return $0._lcState.lazyGetForeignTableCollectionField($0, \"" + (String)propertyName + "\", \"" + ft.joinKey() + "\");");
                    continue;
                }
                method.setBody("return $0._lcState.lazyGetForeignTableField($0, \"" + (String)propertyName + "\", \"" + ft.joinKey() + "\");");
                continue;
            }
            ForeignKey fk = (ForeignKey)field.getAnnotation(ForeignKey.class);
            if (fk != null) {
                method.setBody("return $0.get" + method.getName().substring(7) + "() != null ? $0.get" + method.getName().substring(7) + "().loadEntity() : reactor.core.publisher.Mono.empty();");
                continue;
            }
            method.setBody("return $0.loadEntity().map($0._lcState.getFieldMapper($0, \"" + (String)propertyName + "\"));");
        }
    }
}

