/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.reactivestreams.Publisher;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class EntityLoader {
    private Map<RelationalPersistentEntity<?>, Map<Object, List<Consumer<Object>>>> toLoad = new HashMap();
    private Map<RelationalPersistentEntity<?>, Map<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>>> toRetrieve = new HashMap();

    EntityLoader() {
    }

    Mono<Void> doOperations(Operation op) {
        Mono<Void> load = this.doLoad(op);
        Mono<Void> retrieve = this.doRetrieve(op);
        if (load != null) {
            if (retrieve != null) {
                return Mono.when((Publisher[])new Publisher[]{load, retrieve});
            }
            return load;
        }
        if (retrieve != null) {
            return retrieve;
        }
        return null;
    }

    <T> void load(RelationalPersistentEntity<?> entity, T instance, Consumer<T> onLoaded) {
        Map map = this.toLoad.computeIfAbsent(entity, e -> new HashMap());
        List consumers = map.computeIfAbsent(instance, v -> new LinkedList());
        consumers.add(onLoaded);
    }

    private Mono<Void> doLoad(Operation op) {
        LinkedList<Mono> loads = new LinkedList<Mono>();
        Map<RelationalPersistentEntity<?>, Map<Object, List<Consumer<Object>>>> map = this.toLoad;
        this.toLoad = new HashMap();
        for (Map.Entry<RelationalPersistentEntity<?>, Map<Object, List<Consumer<Object>>>> entity : map.entrySet()) {
            for (Map.Entry<Object, List<Consumer<Object>>> instance : entity.getValue().entrySet()) {
                loads.add(op.lcClient.lazyLoad(instance.getKey(), entity.getKey()).map(loaded -> {
                    for (Consumer consumer : (List)instance.getValue()) {
                        op.toCall(() -> consumer.accept(loaded));
                    }
                    return loaded;
                }));
            }
        }
        if (loads.isEmpty()) {
            return null;
        }
        return Mono.when(loads);
    }

    void retrieve(RelationalPersistentEntity<?> entity, RelationalPersistentProperty property, Object propertyValue, Consumer<Object> consumer) {
        Map map = this.toRetrieve.computeIfAbsent(entity, e -> new HashMap());
        Map byValue = map.computeIfAbsent(property, p -> new HashMap());
        List list = byValue.computeIfAbsent(propertyValue, v -> new LinkedList());
        list.add(consumer);
    }

    private Mono<Void> doRetrieve(Operation op) {
        Map<RelationalPersistentEntity<?>, Map<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>>> map = this.toRetrieve;
        this.toRetrieve = new HashMap();
        LinkedList<Flux> loads = new LinkedList<Flux>();
        for (Map.Entry<RelationalPersistentEntity<?>, Map<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>>> entity : map.entrySet()) {
            for (Map.Entry<RelationalPersistentProperty, Map<Object, List<Consumer<Object>>>> property : entity.getValue().entrySet()) {
                loads.add(op.lcClient.execute(SelectQuery.from(entity.getKey().getType(), "e").where(Criteria.property("e", property.getKey().getName()).in(property.getValue().keySet())), null).map(e -> EntityLoader.retrieved(e, op, (RelationalPersistentProperty)property.getKey(), (Map)property.getValue())));
            }
        }
        if (loads.isEmpty()) {
            return null;
        }
        return Mono.when(loads);
    }

    private static <T> T retrieved(T entity, Operation op, RelationalPersistentProperty property, Map<Object, List<Consumer<Object>>> consumersMap) {
        try {
            List<Consumer<Object>> consumers = consumersMap.get(ModelUtils.getDatabaseValue(entity, property, op.lcClient.getMappingContext()));
            if (consumers != null) {
                for (Consumer<Object> c : consumers) {
                    op.toCall(() -> c.accept(entity));
                }
            }
            return entity;
        }
        catch (Exception e) {
            throw new MappingException("Error analyzing data from retrieved entity", (Throwable)e);
        }
    }
}

