/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.enhance.Enhancer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yaml.snakeyaml.Yaml;

public class LcReactiveDataRelationalInitializer {
    private static final Log logger = LogFactory.getLog(LcReactiveDataRelationalInitializer.class);
    private static boolean initialized = false;

    private LcReactiveDataRelationalInitializer() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        logger.info((Object)"Initializing lc-reactive-data-relational");
        try {
            Enumeration<URL> urls = LcReactiveDataRelationalInitializer.class.getClassLoader().getResources("lc-reactive-data-relational.yaml");
            Config config = new Config();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                logger.info((Object)("Loading configuration from " + url));
                LcReactiveDataRelationalInitializer.loadConfiguration(url, config);
            }
            Enhancer.enhance(config.entities);
        }
        catch (Exception e) {
            logger.error((Object)"Error configuring lc-reactive-data-relational", (Throwable)e);
        }
    }

    private static void loadConfiguration(URL url, Config config) {
        try (InputStream input = url.openStream();){
            Yaml yaml = new Yaml();
            Map root = (Map)yaml.load(input);
            if (root.containsKey("entities")) {
                LcReactiveDataRelationalInitializer.configureEntities(config, "", root.get("entities"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to read configuration file", (Throwable)e);
        }
    }

    private static void configureEntities(Config config, String prefix, Object value) {
        if (value instanceof String) {
            config.entities.add(prefix + (String)value);
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                LcReactiveDataRelationalInitializer.configureEntities(config, prefix, element);
            }
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                LcReactiveDataRelationalInitializer.configureEntities(config, prefix + entry.getKey() + ".", entry.getValue());
            }
        } else {
            logger.warn((Object)("Unexpected entity package value: " + value));
        }
    }

    private static class Config {
        private List<String> entities = new LinkedList<String>();

        private Config() {
        }
    }
}

