/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.autoconfigure.data.r2dbc.DataR2dbcTest;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.test.annotation.DirtiesContext;

@DataR2dbcTest
@EnableAutoConfiguration
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public abstract class AbstractLcReactiveDataRelationalTest {
    @Autowired
    protected LcReactiveDataRelationalClient lcClient;
    @Autowired
    protected DatabaseClient springClient;

    @BeforeEach
    public void initDatabase() {
        this.lcClient.dropCreateSchemaContent(this.lcClient.buildSchemaFromEntities()).block();
    }

    @SafeVarargs
    protected final <T> void expectEntities(Class<T> type, ExpectedEntity<T> ... expected) {
        List found = (List)SelectQuery.from(type, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)expected.length, (int)found.size());
        ArrayList expectedEntities = new ArrayList(expected.length);
        Collections.addAll(expectedEntities, expected);
        StringBuilder error = new StringBuilder();
        for (Object entity : found) {
            boolean matchFound = false;
            StringBuilder valuesFound = new StringBuilder();
            boolean first = true;
            Iterator it = expectedEntities.iterator();
            while (it.hasNext()) {
                ExpectedEntity expectedEntity = (ExpectedEntity)it.next();
                boolean match = true;
                ExpectedValue<T, ?>[] expectedValueArray = expectedEntity.expectedValues;
                int n = expectedValueArray.length;
                for (int i = 0; i < n; ++i) {
                    ExpectedValue expectedValue = expectedValueArray[i];
                    Object value = expectedValue.supplier.apply(entity);
                    if (first) {
                        valuesFound.append('<').append(value).append('>');
                    }
                    if (Objects.equals(value, expectedValue.expected)) continue;
                    match = false;
                }
                first = false;
                if (!match) continue;
                it.remove();
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            error.append("Unexpected ").append(type.getSimpleName()).append(" with values ").append((CharSequence)valuesFound);
            for (ExpectedEntity expectedEntity : expectedEntities) {
                error.append("\n - ");
                for (ExpectedValue expectedValue : expectedEntity.expectedValues) {
                    error.append('<').append(expectedValue.expected).append('>');
                }
            }
            error.append('\n');
        }
        if (!expectedEntities.isEmpty()) {
            error.append("Remaining expected entities: ");
            for (ExpectedEntity expectedEntity : expectedEntities) {
                error.append("\n - ");
                for (ExpectedValue expectedValue : expectedEntity.expectedValues) {
                    error.append('<').append(expectedValue.expected).append('>');
                }
            }
            error.append('\n');
        }
        if (error.length() > 0) {
            throw new AssertionError((Object)error.toString());
        }
    }

    protected static class ExpectedValue<S, T> {
        private Function<S, T> supplier;
        private T expected;

        public ExpectedValue(Function<S, T> supplier, T expected) {
            this.supplier = supplier;
            this.expected = expected;
        }
    }

    protected static class ExpectedEntity<T> {
        private ExpectedValue<T, ?>[] expectedValues;

        @SafeVarargs
        public ExpectedEntity(ExpectedValue<T, ?> ... expectedValues) {
            this.expectedValues = expectedValues;
        }
    }
}

