/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema.dialect;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.Index;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.SchemaException;
import net.lecousin.reactive.data.relational.schema.Table;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatement;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatements;

public abstract class RelationalDatabaseSchemaDialect {
    public Object convertToDataBase(Object value) {
        return value;
    }

    public Object convertFromDataBase(Object value, Class<?> targetType) {
        return value;
    }

    public String getColumnType(Column col, Class<?> type, ColumnDefinition def) {
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return this.getColumnTypeBoolean(col, type, def);
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return this.getColumnTypeByte(col, type, def);
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return this.getColumnTypeShort(col, type, def);
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return this.getColumnTypeInteger(col, type, def);
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return this.getColumnTypeLong(col, type, def);
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return this.getColumnTypeFloat(col, type, def);
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return this.getColumnTypeDouble(col, type, def);
        }
        if (BigDecimal.class.equals(type)) {
            return this.getColumnTypeBigDecimal(col, type, def);
        }
        if (String.class.equals(type) || char[].class.equals(type)) {
            return this.getColumnTypeString(col, type, def);
        }
        if (Character.TYPE.equals(type) || Character.class.equals(type)) {
            return this.getColumnTypeChar(col, type, def);
        }
        if (LocalDate.class.equals(type)) {
            return this.getColumnTypeDate(col, type, def);
        }
        if (LocalTime.class.equals(type)) {
            return this.getColumnTypeTime(col, type, def);
        }
        if (OffsetTime.class.equals(type)) {
            return this.getColumnTypeTimeWithTimeZone(col, type, def);
        }
        if (LocalDateTime.class.equals(type)) {
            return this.getColumnTypeDateTime(col, type, def);
        }
        if (ZonedDateTime.class.equals(type)) {
            return this.getColumnTypeDateTimeWithTimeZone(col, type, def);
        }
        if (Instant.class.equals(type)) {
            return this.getColumnTypeTimestamp(col, type, def);
        }
        throw new SchemaException("Column type not supported: " + type.getName() + " for column " + col.getName());
    }

    protected String getColumnTypeBoolean(Column col, Class<?> type, ColumnDefinition def) {
        return "BOOLEAN";
    }

    protected String getColumnTypeByte(Column col, Class<?> type, ColumnDefinition def) {
        return "TINYINT";
    }

    protected String getColumnTypeShort(Column col, Class<?> type, ColumnDefinition def) {
        return "SMALLINT";
    }

    protected String getColumnTypeInteger(Column col, Class<?> type, ColumnDefinition def) {
        return "INT";
    }

    protected String getColumnTypeLong(Column col, Class<?> type, ColumnDefinition def) {
        return "BIGINT";
    }

    protected String getColumnTypeFloat(Column col, Class<?> type, ColumnDefinition def) {
        return "FLOAT";
    }

    protected String getColumnTypeDouble(Column col, Class<?> type, ColumnDefinition def) {
        return "DOUBLE";
    }

    protected String getColumnTypeBigDecimal(Column col, Class<?> type, ColumnDefinition def) {
        int precision = def != null ? def.precision() : 10;
        int scale = def != null ? def.scale() : 2;
        return "DECIMAL(" + precision + "," + scale + ")";
    }

    protected String getColumnTypeChar(Column col, Class<?> type, ColumnDefinition def) {
        return this.getColumnTypeShort(col, type, def);
    }

    protected String getColumnTypeString(Column col, Class<?> type, ColumnDefinition def) {
        if (def != null) {
            if (def.max() > Integer.MAX_VALUE) {
                return "CLOB(" + def.max() + ")";
            }
            if (def.min() > 0L && def.max() == def.min()) {
                return "CHAR(" + def.max() + ")";
            }
            if (def.max() > 0L) {
                return "VARCHAR(" + def.max() + ")";
            }
        }
        return "VARCHAR";
    }

    protected String getColumnTypeTimestamp(Column col, Class<?> type, ColumnDefinition def) {
        return "TIMESTAMP";
    }

    protected String getColumnTypeDate(Column col, Class<?> type, ColumnDefinition def) {
        return "DATE";
    }

    protected String getColumnTypeTime(Column col, Class<?> type, ColumnDefinition def) {
        return "TIME";
    }

    protected String getColumnTypeTimeWithTimeZone(Column col, Class<?> type, ColumnDefinition def) {
        return "TIME WITH TIME ZONE";
    }

    protected String getColumnTypeDateTime(Column col, Class<?> type, ColumnDefinition def) {
        return "DATETIME";
    }

    protected String getColumnTypeDateTimeWithTimeZone(Column col, Class<?> type, ColumnDefinition def) {
        return "DATETIME WITH TIME ZONE";
    }

    public SchemaStatements dropSchemaContent(RelationalDatabaseSchema schema) {
        SchemaStatements toExecute = new SchemaStatements();
        HashMap<Table, SchemaStatement> dropTableMap = new HashMap<Table, SchemaStatement>();
        for (Table table : schema.getTables()) {
            SchemaStatement dropTable = new SchemaStatement(this.dropTable(table));
            toExecute.add(dropTable);
            dropTableMap.put(table, dropTable);
        }
        for (Table table : schema.getTables()) {
            for (Column col : table.getColumns()) {
                if (col.getForeignKeyReferences() == null || col.getForeignKeyReferences().getFirst() == table) continue;
                ((SchemaStatement)dropTableMap.get(col.getForeignKeyReferences().getFirst())).addDependency((SchemaStatement)dropTableMap.get(table));
            }
        }
        return toExecute;
    }

    public String dropTable(Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP TABLE IF EXISTS ");
        sql.append(table.getName());
        return sql.toString();
    }

    public SchemaStatements createSchemaContent(RelationalDatabaseSchema schema) {
        SchemaStatements toExecute = new SchemaStatements();
        HashMap<Table, SchemaStatement> createTableMap = new HashMap<Table, SchemaStatement>();
        for (Table table : schema.getTables()) {
            SchemaStatement createTable = new SchemaStatement(this.createTable(table));
            createTableMap.put(table, createTable);
            toExecute.add(createTable);
            for (Index index : table.getIndexes()) {
                if (this.canCreateIndexInTableDefinition(index)) continue;
                SchemaStatement createIndex = new SchemaStatement(this.createIndex(table, index));
                createIndex.addDependency(createTable);
                toExecute.add(createIndex);
            }
        }
        SchemaStatement previousAlter = null;
        for (Table table : schema.getTables()) {
            for (Column col : table.getColumns()) {
                if (col.getForeignKeyReferences() == null) continue;
                SchemaStatement alterTable = new SchemaStatement(this.alterTableForeignKey(table, col));
                alterTable.addDependency((SchemaStatement)createTableMap.get(table));
                alterTable.addDependency((SchemaStatement)createTableMap.get(col.getForeignKeyReferences().getFirst()));
                if (previousAlter != null) {
                    alterTable.addDependency(previousAlter);
                }
                previousAlter = alterTable;
                toExecute.add(alterTable);
            }
        }
        return toExecute;
    }

    protected boolean canCreateIndexInTableDefinition(Index index) {
        return false;
    }

    public String createTable(Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(table.getName());
        sql.append(" (");
        boolean first = true;
        for (Column col : table.getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            this.addColumnDefinition(col, sql);
        }
        for (Index index : table.getIndexes()) {
            if (!this.canCreateIndexInTableDefinition(index)) continue;
            sql.append(", ");
            this.addIndexDefinitionInTable(table, index, sql);
        }
        sql.append(')');
        return sql.toString();
    }

    public String createIndex(Table table, Index index) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (index.isUnique()) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        sql.append(index.getName());
        sql.append(" ON ");
        sql.append(table.getName());
        sql.append('(');
        boolean first = true;
        for (String col : index.getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(',');
            }
            sql.append(col);
        }
        sql.append(')');
        return sql.toString();
    }

    protected void addColumnDefinition(Column col, StringBuilder sql) {
        sql.append(col.getName());
        sql.append(' ');
        sql.append(col.getType());
        if (!col.isNullable()) {
            this.addNotNull(col, sql);
        }
        if (col.isAutoIncrement()) {
            this.addAutoIncrement(col, sql);
        }
        if (col.isPrimaryKey()) {
            this.addPrimaryKey(col, sql);
        }
    }

    protected void addIndexDefinitionInTable(Table table, Index index, StringBuilder sql) {
    }

    protected void addNotNull(Column col, StringBuilder sql) {
        sql.append(" NOT NULL");
    }

    protected void addAutoIncrement(Column col, StringBuilder sql) {
        sql.append(" AUTO_INCREMENT");
    }

    protected void addPrimaryKey(Column col, StringBuilder sql) {
        sql.append(" PRIMARY KEY");
    }

    protected String alterTableForeignKey(Table table, Column col) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(table.getName());
        sql.append(" ADD FOREIGN KEY (");
        sql.append(col.getName());
        sql.append(") REFERENCES ");
        sql.append(((Table)col.getForeignKeyReferences().getFirst()).getName());
        sql.append('(');
        sql.append(((Column)col.getForeignKeyReferences().getSecond()).getName());
        sql.append(')');
        return sql.toString();
    }
}

