/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.annotations.GeneratedValue;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcEntityWriter;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractInstanceProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

class SaveProcessor
extends AbstractInstanceProcessor<SaveRequest> {
    SaveProcessor() {
    }

    @Override
    protected <T> SaveRequest createRequest(T instance, EntityState state, RelationalPersistentEntity<T> entity, PersistentPropertyAccessor<T> accessor) {
        return new SaveRequest(entity, instance, state, accessor);
    }

    @Override
    protected boolean doProcess(Operation op, SaveRequest request) {
        return true;
    }

    @Override
    protected void processForeignKey(Operation op, SaveRequest request, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation, @Nullable Field foreignTableField, @Nullable ForeignTable foreignTableAnnotation) {
        Object value = request.accessor.getProperty((PersistentProperty)fkProperty);
        Object originalValue = request.state.getPersistedValue(fkProperty.getName());
        if (!Objects.equals(originalValue, value) && originalValue != null) {
            if (foreignTableAnnotation != null) {
                SaveProcessor.removeForeignTableLink(op, request, foreignTableField, originalValue);
            }
            if (foreignTableAnnotation != null && !foreignTableAnnotation.optional() || fkAnnotation.cascadeDelete()) {
                op.addToDelete(originalValue, null, null, null);
            }
        }
        if (value != null) {
            SaveRequest save = op.addToSave(value, null, null, null);
            if (!save.state.isPersisted()) {
                request.dependsOn(save);
            }
        }
    }

    private static void removeForeignTableLink(Operation op, SaveRequest request, Field foreignTableField, Object originalValue) {
        try {
            if (ModelUtils.isCollection(foreignTableField)) {
                ModelUtils.removeFromCollectionField(foreignTableField, originalValue, request.instance);
            } else {
                EntityState foreignState = EntityState.get(originalValue, op.lcClient);
                foreignState.setForeignTableField(originalValue, foreignTableField, null, false);
            }
        }
        catch (Exception e) {
            throw new ModelAccessException("Unable to remove link for removed entity", e);
        }
    }

    @Override
    protected <T> void processForeignTableField(Operation op, SaveRequest request, Field foreignTableField, ForeignTable foreignTableAnnotation, @Nullable MutableObject<?> foreignFieldValue, boolean isCollection, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        if (foreignFieldValue == null) {
            return;
        }
        if (ModelUtils.isCollection(foreignTableField)) {
            SaveProcessor.processForeignTableFieldCollection(op, request, foreignTableField, foreignFieldValue, foreignEntity, fkProperty, fkAnnotation);
        } else {
            SaveProcessor.processForeignTableFieldSimple(op, request, foreignTableField, foreignFieldValue, foreignEntity, fkProperty, fkAnnotation);
        }
    }

    private static <T> void processForeignTableFieldCollection(Operation op, SaveRequest request, Field foreignTableField, MutableObject<?> foreignFieldValue, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        SaveRequest save;
        ArrayList value = foreignFieldValue.getValue();
        Object originalValue = request.state.getPersistedValue(foreignTableField.getName());
        if (value == null) {
            if (originalValue == null) {
                return;
            }
            value = new ArrayList(0);
        }
        LinkedList deletedElements = new LinkedList();
        if (originalValue != null) {
            deletedElements.addAll(ModelUtils.getAsCollection(originalValue));
        }
        deletedElements.removeAll(ModelUtils.getAsCollection(value));
        if (!deletedElements.isEmpty()) {
            if (!fkAnnotation.optional() || fkAnnotation.onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.DELETE)) {
                for (Object element : deletedElements) {
                    op.addToDelete(element, foreignEntity, null, null);
                }
            } else {
                for (Object element : deletedElements) {
                    save = op.addToSave(element, foreignEntity, null, null);
                    save.state.setPersistedField(element, fkProperty.getField(), null, false);
                }
            }
        }
        for (Object element : ModelUtils.getAsCollection(value)) {
            save = op.addToSave(element, foreignEntity, null, null);
            save.state.setPersistedField(element, fkProperty.getField(), request.instance, false);
        }
    }

    private static <T> void processForeignTableFieldSimple(Operation op, SaveRequest request, Field foreignTableField, MutableObject<?> foreignFieldValue, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        SaveRequest save;
        Object value = foreignFieldValue.getValue();
        Object originalValue = request.state.getPersistedValue(foreignTableField.getName());
        if (!Objects.equals(originalValue, value) && originalValue != null) {
            if (!fkAnnotation.optional() || fkAnnotation.onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.DELETE)) {
                op.addToDelete(originalValue, foreignEntity, null, null);
            } else {
                save = op.addToSave(originalValue, foreignEntity, null, null);
                save.state.setPersistedField(originalValue, fkProperty.getField(), null, false);
            }
        }
        if (value != null) {
            save = op.addToSave(value, foreignEntity, null, null);
            save.state.setPersistedField(value, fkProperty.getField(), request.instance, false);
        }
    }

    @Override
    protected Mono<Void> doRequests(Operation op, RelationalPersistentEntity<?> entityType, List<SaveRequest> requests) {
        LinkedList<Mono<Object>> statements = new LinkedList<Mono<Object>>();
        for (SaveRequest request : requests) {
            if (!request.state.isPersisted()) {
                statements.add(SaveProcessor.doInsert(op, request));
                continue;
            }
            statements.add(SaveProcessor.doUpdate(op, request));
        }
        return Mono.when(statements);
    }

    private static Mono<Object> doInsert(Operation op, SaveRequest request) {
        return Mono.fromCallable(() -> {
            SqlQuery<Insert> query = new SqlQuery<Insert>(op.lcClient);
            LinkedList<RelationalPersistentProperty> generated = new LinkedList<RelationalPersistentProperty>();
            OutboundRow row = new OutboundRow();
            LcEntityWriter writer = new LcEntityWriter(op.lcClient.getMapper());
            for (RelationalPersistentProperty property : request.entityType) {
                if (property.isAnnotationPresent(GeneratedValue.class)) {
                    generated.add(property);
                    continue;
                }
                if (!property.isWritable()) continue;
                if (request.entityType.isVersionProperty((PersistentProperty)property)) {
                    request.accessor.setProperty((PersistentProperty)property, op.lcClient.getMapper().getConversionService().convert((Object)1L, property.getType()));
                }
                writer.writeProperty(row, property, request.accessor);
            }
            query.setQuery(SaveProcessor.createInsertQuery(query, row, request.entityType.getTableName()));
            return query.execute().filter(statement -> statement.returnGeneratedValues(new String[0])).map((r, meta) -> {
                int index = 0;
                for (RelationalPersistentProperty property : generated) {
                    request.accessor.setProperty((PersistentProperty)property, r.get(index++));
                }
                request.state.loaded(request.instance);
                return request.instance;
            });
        }).flatMap(RowsFetchSpec::first);
    }

    private static Insert createInsertQuery(SqlQuery<Insert> query, OutboundRow row, SqlIdentifier tableName) {
        Table table = Table.create((SqlIdentifier)tableName);
        ArrayList<Column> columns = new ArrayList<Column>(row.size());
        ArrayList<Object> values = new ArrayList<Object>(row.size());
        for (Map.Entry entry : row.entrySet()) {
            columns.add(Column.create((SqlIdentifier)((SqlIdentifier)entry.getKey()), (Table)table));
            if (((Parameter)entry.getValue()).getValue() == null) {
                values.add(SQL.nullLiteral());
                continue;
            }
            values.add(query.marker(((Parameter)entry.getValue()).getValue()));
        }
        return Insert.builder().into(table).columns(columns).values(values).build();
    }

    private static Mono<Object> doUpdate(Operation op, SaveRequest request) {
        return Mono.fromCallable(() -> {
            SqlQuery<Update> query = new SqlQuery<Update>(op.lcClient);
            Table table = Table.create((SqlIdentifier)request.entityType.getTableName());
            OutboundRow row = new OutboundRow();
            LcEntityWriter writer = new LcEntityWriter(op.lcClient.getMapper());
            LinkedList<AssignValue> assignments = new LinkedList<AssignValue>();
            SaveProcessor.prepareUpdate(request, table, assignments, row, writer, query);
            if (row.isEmpty()) {
                return null;
            }
            for (Map.Entry entry : row.entrySet()) {
                assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)((SqlIdentifier)entry.getKey()), (Table)table), (Expression)(((Parameter)entry.getValue()).getValue() != null ? query.marker(((Parameter)entry.getValue()).getValue()) : SQL.nullLiteral())));
            }
            Condition criteria = ModelUtils.getConditionOnId(query, request.entityType, request.accessor, op.lcClient.getMappingContext());
            if (request.entityType.hasVersionProperty()) {
                RelationalPersistentProperty property = (RelationalPersistentProperty)request.entityType.getRequiredVersionProperty();
                Object value = request.accessor.getProperty((PersistentProperty)property);
                long currentVersion = ((Number)value).longValue();
                criteria = criteria.and((Condition)Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)query.marker(currentVersion)));
            }
            query.setQuery(Update.builder().table(table).set(assignments).where(criteria).build());
            Mono rowsUpdated = query.execute().fetch().rowsUpdated();
            if (request.entityType.hasVersionProperty()) {
                rowsUpdated = rowsUpdated.flatMap(updatedRows -> {
                    if (updatedRows == 0) {
                        return Mono.error((Throwable)new OptimisticLockingFailureException("Version does not match"));
                    }
                    return Mono.just((Object)updatedRows);
                });
            }
            return rowsUpdated;
        }).flatMap(updatedRows -> updatedRows != null ? updatedRows.thenReturn(request.instance).doOnSuccess(e -> SaveProcessor.entityUpdated(op, request)) : Mono.just((Object)request.instance));
    }

    private static void prepareUpdate(SaveRequest request, Table table, List<AssignValue> assignments, OutboundRow row, LcEntityWriter writer, SqlQuery<Update> query) {
        for (RelationalPersistentProperty property : request.entityType) {
            if (request.entityType.isVersionProperty((PersistentProperty)property)) {
                Object value = request.accessor.getProperty((PersistentProperty)property);
                Assert.notNull((Object)value, (String)("Version must not be null (property " + property.getName() + " on " + request.entityType.getType().getSimpleName() + ")"));
                long currentVersion = ((Number)value).longValue();
                assignments.add(AssignValue.create((Column)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)query.marker(currentVersion + 1L)));
                continue;
            }
            if (property.isIdProperty() || !request.state.isFieldModified(property.getName()) || !property.isWritable()) continue;
            writer.writeProperty(row, property, request.accessor);
        }
    }

    private static void entityUpdated(Operation op, SaveRequest request) {
        request.state.load(request.instance);
        if (request.entityType.hasVersionProperty()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)request.entityType.getRequiredVersionProperty();
            request.accessor.setProperty((PersistentProperty)property, op.lcClient.getMapper().getConversionService().convert((Object)(((Number)request.accessor.getProperty((PersistentProperty)property)).longValue() + 1L), property.getType()));
        }
    }

    static class SaveRequest
    extends AbstractInstanceProcessor.Request {
        <T> SaveRequest(RelationalPersistentEntity<T> entityType, T instance, EntityState state, PersistentPropertyAccessor<T> accessor) {
            super(entityType, instance, state, accessor);
            if (!this.state.isLoaded() && this.state.isPersisted()) {
                this.toProcess = false;
            }
        }
    }
}

