/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.EntityCache;
import net.lecousin.reactive.data.relational.query.operation.DeleteProcessor;
import net.lecousin.reactive.data.relational.query.operation.DeleteWithoutLoading;
import net.lecousin.reactive.data.relational.query.operation.EntityLoader;
import net.lecousin.reactive.data.relational.query.operation.PropertyUpdater;
import net.lecousin.reactive.data.relational.query.operation.SaveProcessor;
import org.reactivestreams.Publisher;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public class Operation {
    LcReactiveDataRelationalClient lcClient;
    EntityCache cache = new EntityCache();
    EntityLoader loader = new EntityLoader();
    PropertyUpdater updater = new PropertyUpdater();
    SaveProcessor save = new SaveProcessor();
    DeleteProcessor delete = new DeleteProcessor();
    DeleteWithoutLoading deleteWithoutLoading = new DeleteWithoutLoading();
    private List<Runnable> toCall = new LinkedList<Runnable>();

    public Operation(LcReactiveDataRelationalClient lcClient) {
        this.lcClient = lcClient;
    }

    public <T> SaveProcessor.SaveRequest addToSave(T entity, @Nullable RelationalPersistentEntity<T> entityType, @Nullable EntityState state, @Nullable PersistentPropertyAccessor<T> accessor) {
        SaveProcessor.SaveRequest request = (SaveProcessor.SaveRequest)this.save.addToProcess(this, entity, entityType, state, accessor);
        this.delete.addToNotProcess(this, entity, request.entityType, request.state, request.accessor);
        return request;
    }

    public <T> DeleteProcessor.DeleteRequest addToDelete(T entity, @Nullable RelationalPersistentEntity<T> entityType, @Nullable EntityState state, @Nullable PersistentPropertyAccessor<T> accessor) {
        return (DeleteProcessor.DeleteRequest)this.delete.addToProcess(this, entity, entityType, state, accessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toCall(Runnable fct) {
        List<Runnable> list = this.toCall;
        synchronized (list) {
            this.toCall.add(fct);
        }
    }

    public Mono<Void> execute() {
        return this.doNext().thenReturn((Object)1).expand(value -> {
            Mono<Void> step = this.doNext();
            if (step == null) {
                return Mono.empty();
            }
            return step.thenReturn((Object)1);
        }).then();
    }

    private Mono<Void> doNext() {
        List<Runnable> calls = this.toCall;
        this.toCall = new LinkedList<Runnable>();
        for (Runnable r : calls) {
            r.run();
        }
        try {
            if (this.save.processRequests(this)) {
                return Mono.empty();
            }
            if (this.delete.processRequests(this)) {
                return Mono.empty();
            }
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        Mono<Void> op = this.loader.doOperations(this);
        if (op != null) {
            return op;
        }
        op = this.updater.doOperations(this);
        if (op != null) {
            return op;
        }
        op = this.save.doOperations(this);
        if (op != null) {
            return op;
        }
        op = this.delete.doOperations(this);
        Mono<Void> op2 = this.deleteWithoutLoading.doOperations(this);
        if (op == null) {
            return op2;
        }
        if (op2 == null) {
            return op;
        }
        return Mono.when((Publisher[])new Publisher[]{op, op2});
    }
}

