/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractInstanceProcessor;
import net.lecousin.reactive.data.relational.query.operation.AbstractProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.IsNull;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

class DeleteProcessor
extends AbstractInstanceProcessor<DeleteRequest> {
    DeleteProcessor() {
    }

    @Override
    protected <T> DeleteRequest createRequest(T instance, EntityState state, RelationalPersistentEntity<T> entity, PersistentPropertyAccessor<T> accessor) {
        return new DeleteRequest(entity, instance, state, accessor);
    }

    @Override
    protected boolean doProcess(Operation op, DeleteRequest request) {
        if (!request.state.isPersisted()) {
            return false;
        }
        for (RelationalPersistentEntity entity : op.lcClient.getMappingContext().getPersistentEntities()) {
            if (entity.equals(request.entityType)) continue;
            for (RelationalPersistentProperty fkProperty : entity.getPersistentProperties(ForeignKey.class)) {
                Field ftField;
                if (!fkProperty.getType().equals(request.entityType.getType()) || (ftField = ModelUtils.getForeignTableFieldForJoinKey(request.entityType.getType(), fkProperty.getName(), entity.getType())) != null) continue;
                ForeignKey fkAnnotation = (ForeignKey)fkProperty.getRequiredAnnotation(ForeignKey.class);
                this.processForeignTableField(op, request, (Field)null, (ForeignTable)null, (MutableObject<?>)null, false, (RelationalPersistentEntity)entity, fkProperty, fkAnnotation);
            }
        }
        return true;
    }

    @Override
    protected void processForeignKey(Operation op, DeleteRequest request, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation, @Nullable Field foreignTableField, @Nullable ForeignTable foreignTableAnnotation) {
        Object foreignInstance;
        if (!request.entityType.hasIdProperty()) {
            foreignInstance = request.accessor.getProperty((PersistentProperty)fkProperty);
            if (foreignInstance != null) {
                RelationalPersistentEntity fe = (RelationalPersistentEntity)op.lcClient.getMappingContext().getRequiredPersistentEntity(foreignInstance.getClass());
                foreignInstance = fe.getPropertyAccessor(foreignInstance).getProperty(fe.getRequiredIdProperty());
            }
            request.saveForeignKeyValue(fkProperty.getName(), foreignInstance);
        }
        if (foreignTableAnnotation != null && foreignTableField != null) {
            if (ModelUtils.isCollection(foreignTableField)) {
                DeleteProcessor.removeFromForeignTableCollection(request, fkProperty, foreignTableField);
                return;
            }
            if (foreignTableAnnotation.optional() && !fkAnnotation.cascadeDelete()) {
                if (request.state.isLoaded() && !request.state.isFieldModified(fkProperty.getName()) && (foreignInstance = request.accessor.getProperty((PersistentProperty)fkProperty)) != null) {
                    try {
                        foreignTableField.set(foreignInstance, null);
                    }
                    catch (Exception e) {
                        throw new ModelAccessException("Cannot set foreign table field", e);
                    }
                }
                return;
            }
        } else if (!fkAnnotation.cascadeDelete()) {
            return;
        }
        if (request.state.isLoaded()) {
            this.deleteForeignKeyInstance(op, request, request.state.getPersistedValue(fkProperty.getName()));
            return;
        }
        op.loader.load(request.entityType, request.instance, loaded -> this.deleteForeignKeyInstance(op, request, request.accessor.getProperty((PersistentProperty)fkProperty)));
    }

    private static void removeFromForeignTableCollection(DeleteRequest request, RelationalPersistentProperty fkProperty, Field foreignTableField) {
        Object foreignInstance;
        if (request.state.isLoaded() && !request.state.isFieldModified(fkProperty.getName()) && (foreignInstance = request.accessor.getProperty((PersistentProperty)fkProperty)) != null) {
            try {
                ModelUtils.removeFromCollectionField(foreignTableField, foreignInstance, request.instance);
            }
            catch (Exception e) {
                throw new ModelAccessException("Cannot remove instance from collection field", e);
            }
        }
    }

    private void deleteForeignKeyInstance(Operation op, DeleteRequest request, Object foreignInstance) {
        if (foreignInstance == null) {
            return;
        }
        DeleteRequest deleteForeign = (DeleteRequest)this.addToProcess(op, foreignInstance, null, null, null);
        deleteForeign.dependsOn(request);
    }

    @Override
    protected <T> void processForeignTableField(Operation op, DeleteRequest request, @Nullable Field foreignTableField, @Nullable ForeignTable foreignTableAnnotation, @Nullable MutableObject<?> foreignFieldValue, boolean isCollection, RelationalPersistentEntity<T> foreignEntity, RelationalPersistentProperty fkProperty, ForeignKey fkAnnotation) {
        if (fkAnnotation.onForeignDeleted().equals((Object)ForeignKey.OnForeignDeleted.SET_TO_NULL)) {
            Object foreignInstance;
            Object instId = ModelUtils.getRequiredId(request.instance, request.entityType, request.accessor);
            request.dependsOn(op.updater.update(foreignEntity, fkProperty, instId, null));
            if (foreignFieldValue != null && (foreignInstance = foreignFieldValue.getValue()) != null) {
                EntityState.get(foreignInstance, op.lcClient, foreignEntity).setPersistedField(foreignInstance, fkProperty.getField(), null, true);
            }
            return;
        }
        if (foreignFieldValue != null && !request.state.isFieldModified(foreignTableField.getName())) {
            Object foreignInstance = foreignFieldValue.getValue();
            if (foreignInstance == null) {
                return;
            }
            if (ModelUtils.isCollection(foreignTableField)) {
                for (Object o : ModelUtils.getAsCollection(foreignFieldValue.getValue())) {
                    request.dependsOn((AbstractProcessor.Request)this.addToProcess(op, o, foreignEntity, null, null));
                }
            } else {
                request.dependsOn((AbstractProcessor.Request)this.addToProcess(op, foreignFieldValue.getValue(), foreignEntity, null, null));
            }
        } else {
            Object instId = ModelUtils.getRequiredId(request.instance, request.entityType, request.accessor);
            if (!DeleteProcessor.hasOtherLinks(op, foreignEntity.getType(), fkProperty.getName())) {
                request.dependsOn(op.deleteWithoutLoading.addRequest(foreignEntity, fkProperty, instId));
            } else {
                op.loader.retrieve(foreignEntity, fkProperty, instId, loaded -> request.dependsOn((AbstractProcessor.Request)this.addToProcess(op, loaded, foreignEntity, null, null)));
            }
        }
    }

    private static boolean hasOtherLinks(Operation op, Class<?> entityType, String otherThanField) {
        for (Pair<Field, ForeignTable> p : ModelUtils.getForeignTables(entityType)) {
            if (((Field)p.getFirst()).getName().equals(otherThanField)) continue;
            return true;
        }
        RelationalPersistentEntity entity = (RelationalPersistentEntity)op.lcClient.getMappingContext().getRequiredPersistentEntity(entityType);
        for (RelationalPersistentProperty prop : entity) {
            if (prop.getName().equals(otherThanField) || !prop.isAnnotationPresent(ForeignKey.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Mono<Void> doRequests(Operation op, RelationalPersistentEntity<?> entityType, List<DeleteRequest> requests) {
        Condition criteria;
        SqlQuery<Delete> delete = new SqlQuery<Delete>(op.lcClient);
        Table table = Table.create((SqlIdentifier)entityType.getTableName());
        Condition condition = criteria = entityType.hasIdProperty() ? DeleteProcessor.createCriteriaOnIds(entityType, requests, delete, table) : DeleteProcessor.createCriteriaOnProperties(entityType, requests, delete, table);
        if (LcReactiveDataRelationalClient.logger.isDebugEnabled()) {
            LcReactiveDataRelationalClient.logger.debug((Object)("Delete " + entityType.getType().getName() + " where " + criteria));
        }
        delete.setQuery(StatementBuilder.delete().from(table).where(criteria).build());
        return delete.execute().then().doOnSuccess(v -> op.toCall(() -> DeleteProcessor.deleteDone(entityType, requests)));
    }

    private static Condition createCriteriaOnIds(RelationalPersistentEntity<?> entityType, List<DeleteRequest> requests, SqlQuery<Delete> query, Table table) {
        ArrayList<Expression> ids = new ArrayList<Expression>(requests.size());
        for (DeleteRequest request : requests) {
            Object id = entityType.getPropertyAccessor(request.instance).getProperty(entityType.getRequiredIdProperty());
            ids.add(query.marker(id));
        }
        return Conditions.in((Expression)Column.create((SqlIdentifier)((RelationalPersistentProperty)entityType.getRequiredIdProperty()).getColumnName(), (Table)table), ids);
    }

    private static Condition createCriteriaOnProperties(RelationalPersistentEntity<?> entityType, List<DeleteRequest> requests, SqlQuery<Delete> query, Table table) {
        IsNull criteria = null;
        Iterator<DeleteRequest> it = requests.iterator();
        do {
            DeleteRequest request = it.next();
            IsNull c = null;
            Iterator itProperty = entityType.iterator();
            do {
                IsNull propertyCondition;
                RelationalPersistentProperty property;
                Object value;
                if ((value = request.accessor.getProperty((PersistentProperty)(property = (RelationalPersistentProperty)itProperty.next()))) == null) {
                    propertyCondition = Conditions.isNull((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table));
                } else {
                    if (property.isAnnotationPresent(ForeignKey.class)) {
                        value = request.getSavedForeignKeyValue(property.getName());
                    }
                    propertyCondition = Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)query.marker(value));
                }
                Object object = c = c != null ? c.and((Condition)propertyCondition) : propertyCondition;
            } while (itProperty.hasNext());
            Object object = criteria = criteria != null ? criteria.or((Condition)c) : c;
        } while (it.hasNext());
        return criteria;
    }

    private static void deleteDone(RelationalPersistentEntity<?> entityType, List<DeleteRequest> done) {
        for (DeleteRequest request : done) {
            request.state.deleted();
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entityType.getIdProperty();
            if (idProperty == null || idProperty.getType().isPrimitive()) continue;
            entityType.getPropertyAccessor(request.instance).setProperty((PersistentProperty)idProperty, null);
        }
    }

    static class DeleteRequest
    extends AbstractInstanceProcessor.Request {
        private Map<String, Object> savedForeignKeys = new HashMap<String, Object>();

        <T> DeleteRequest(RelationalPersistentEntity<T> entityType, T instance, EntityState state, PersistentPropertyAccessor<T> accessor) {
            super(entityType, instance, state, accessor);
        }

        private void saveForeignKeyValue(String foreignKey, Object value) {
            this.savedForeignKeys.put(foreignKey, value);
        }

        private Object getSavedForeignKeyValue(String foreignKey) {
            return this.savedForeignKeys.get(foreignKey);
        }
    }
}

