/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.annotations.ForeignTable;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.CompositeIdValue;
import net.lecousin.reactive.data.relational.model.InvalidEntityStateException;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.PropertiesSource;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;

public class ModelUtils {
    private static final Map<Class<?>, Map<String, Pair<Field, ForeignTable>>> CACHE_FOREIGN_TABLE = new HashMap();

    private ModelUtils() {
    }

    public static boolean isNullable(RelationalPersistentProperty property) {
        if (property.getRawType().isPrimitive()) {
            return false;
        }
        if (property.isIdProperty()) {
            return false;
        }
        ForeignKey fk = (ForeignKey)property.findAnnotation(ForeignKey.class);
        if (fk != null) {
            return fk.optional();
        }
        ColumnDefinition def = (ColumnDefinition)property.findAnnotation(ColumnDefinition.class);
        if (def != null) {
            return def.nullable();
        }
        return true;
    }

    public static void setReverseLink(Object instance, Object linkedInstance, RelationalPersistentProperty linkedProperty) {
        Field field = ModelUtils.getForeignTableFieldForJoinKey(instance.getClass(), linkedProperty.getName(), linkedInstance.getClass());
        if (field != null && !ModelUtils.isCollection(field)) {
            try {
                field.set(instance, linkedInstance);
            }
            catch (Exception e) {
                throw new ModelAccessException("Unable to set ForeignTable field " + field.getName() + " on " + instance.getClass().getSimpleName() + " with value " + linkedInstance, e);
            }
        }
    }

    @Nullable
    public static Field getForeignTableFieldForJoinKey(Class<?> entity, String joinKey, Class<?> targetType) {
        Pair<Field, ForeignTable> p = ModelUtils.getForeignTableWithFieldForJoinKey(entity, joinKey, targetType);
        return p != null ? (Field)p.getFirst() : null;
    }

    public static Field getRequiredForeignTableFieldForJoinKey(Class<?> entity, String joinKey, Class<?> targetType) {
        return (Field)ModelUtils.getRequiredForeignTableWithFieldForJoinKey(entity, joinKey, targetType).getFirst();
    }

    @Nullable
    public static Pair<Field, ForeignTable> getForeignTableWithFieldForJoinKey(Class<?> entity, String joinKey, Class<?> targetType) {
        Map<String, Pair<Field, ForeignTable>> map = ModelUtils.getForeignTableFieldMap(entity);
        for (Map.Entry<String, Pair<Field, ForeignTable>> e : map.entrySet()) {
            Field field;
            Class<?> type;
            if (!((ForeignTable)e.getValue().getSecond()).joinKey().equals(joinKey) || !targetType.equals(type = ModelUtils.isCollection(field = (Field)e.getValue().getFirst()) ? ModelUtils.getCollectionType(field) : field.getType())) continue;
            return e.getValue();
        }
        return null;
    }

    private static String missingForeignTable(String expected, String expectedOn, Class<?> entity) {
        return "Missing @ForeignTable " + expected + " '" + expectedOn + "' in class '" + entity.getSimpleName() + "'";
    }

    public static Pair<Field, ForeignTable> getRequiredForeignTableWithFieldForJoinKey(Class<?> entity, String joinKey, Class<?> targetType) {
        Pair<Field, ForeignTable> p = ModelUtils.getForeignTableWithFieldForJoinKey(entity, joinKey, targetType);
        if (p == null) {
            throw new MappingException(ModelUtils.missingForeignTable("field with join key", joinKey, entity));
        }
        return p;
    }

    @Nullable
    public static Field getForeignTableFieldForProperty(Class<?> entity, String propertyName) {
        Map<String, Pair<Field, ForeignTable>> map = ModelUtils.getForeignTableFieldMap(entity);
        Pair<Field, ForeignTable> p = map.get(propertyName);
        return p != null ? (Field)p.getFirst() : null;
    }

    public static Field getRequiredForeignTableFieldForProperty(Class<?> entity, String propertyName) {
        Map<String, Pair<Field, ForeignTable>> map = ModelUtils.getForeignTableFieldMap(entity);
        Pair<Field, ForeignTable> p = map.get(propertyName);
        if (p == null) {
            throw new MappingException(ModelUtils.missingForeignTable("on property", propertyName, entity));
        }
        return (Field)p.getFirst();
    }

    @Nullable
    public static ForeignTable getForeignTableForProperty(Class<?> entity, String propertyName) {
        Map<String, Pair<Field, ForeignTable>> map = ModelUtils.getForeignTableFieldMap(entity);
        Pair<Field, ForeignTable> p = map.get(propertyName);
        return p != null ? (ForeignTable)p.getSecond() : null;
    }

    public static ForeignTable getRequiredForeignTableForProperty(Class<?> entity, String propertyName) {
        Map<String, Pair<Field, ForeignTable>> map = ModelUtils.getForeignTableFieldMap(entity);
        Pair<Field, ForeignTable> p = map.get(propertyName);
        if (p == null) {
            throw new MappingException(ModelUtils.missingForeignTable("on property", propertyName, entity));
        }
        return (ForeignTable)p.getSecond();
    }

    public static boolean isForeignTableField(Field field) {
        Map<String, Pair<Field, ForeignTable>> map = ModelUtils.getForeignTableFieldMap(field.getDeclaringClass());
        for (Pair<Field, ForeignTable> p : map.values()) {
            if (!((Field)p.getFirst()).equals(field)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Pair<Field, ForeignTable>> getForeignTables(Class<?> entity) {
        return ModelUtils.getForeignTableFieldMap(entity).values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Pair<Field, ForeignTable>> getForeignTableFieldMap(Class<?> entity) {
        Map<String, Pair<Field, ForeignTable>> map;
        Map<Class<?>, Map<String, Pair<Field, ForeignTable>>> map2 = CACHE_FOREIGN_TABLE;
        synchronized (map2) {
            map = CACHE_FOREIGN_TABLE.get(entity);
            if (map == null) {
                map = new HashMap<String, Pair<Field, ForeignTable>>();
                ModelUtils.fillForeignTables(entity, map);
                CACHE_FOREIGN_TABLE.put(entity, map);
            }
        }
        return map;
    }

    private static void fillForeignTables(Class<?> entity, Map<String, Pair<Field, ForeignTable>> map) {
        for (Field f : ModelUtils.getAllFields(entity)) {
            ForeignTable ft = f.getAnnotation(ForeignTable.class);
            if (ft == null) continue;
            map.put(f.getName(), (Pair<Field, ForeignTable>)Pair.of((Object)f, (Object)ft));
            f.setAccessible(true);
        }
    }

    private static List<Field> getAllFields(Class<?> cl) {
        LinkedList<Field> fields = new LinkedList<Field>();
        ModelUtils.getAllFields(cl, fields);
        return fields;
    }

    private static void getAllFields(Class<?> cl, List<Field> fields) {
        if (cl == null) {
            return;
        }
        Collections.addAll(fields, cl.getDeclaredFields());
        ModelUtils.getAllFields(cl.getSuperclass(), fields);
    }

    public static Object getRequiredId(Object instance, RelationalPersistentEntity<?> entityType, @Nullable PersistentPropertyAccessor<?> accessor) {
        RelationalPersistentProperty idProperty;
        Object id = (accessor != null ? accessor : entityType.getPropertyAccessor(instance)).getProperty((PersistentProperty)(idProperty = (RelationalPersistentProperty)entityType.getRequiredIdProperty()));
        if (id == null) {
            throw new InvalidEntityStateException("Entity is supposed to be persisted to database, but it's Id property is null");
        }
        return id;
    }

    public static boolean isCollection(Field field) {
        return ModelUtils.isCollectionType(field.getType());
    }

    public static boolean isCollectionType(Class<?> type) {
        if (type.isArray()) {
            return !char[].class.equals(type);
        }
        return Collection.class.isAssignableFrom(type);
    }

    @Nullable
    public static <T> Collection<T> getAsCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    @Nullable
    public static Class<?> getCollectionType(Field field) {
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Type genType = field.getGenericType();
        if (genType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
        }
        return null;
    }

    public static Class<?> getRequiredCollectionType(Field field) {
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Type genType = field.getGenericType();
        if (genType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
        }
        throw new MappingException("Field is not a collection: " + field.getDeclaringClass().getName() + "." + field.getName());
    }

    public static void addToCollectionField(Field field, Object collectionOwnerInstance, Object elementToAdd) throws IllegalAccessException {
        if (field.getType().isArray()) {
            Object[] array = (Object[])field.get(collectionOwnerInstance);
            if (array == null || array.length == 0) {
                array = (Object[])Array.newInstance(field.getType().getComponentType(), 1);
                array[0] = elementToAdd;
                field.set(collectionOwnerInstance, array);
                return;
            }
            if (ArrayUtils.contains((Object[])array, (Object)elementToAdd)) {
                return;
            }
            Object[] newArray = (Object[])Array.newInstance(field.getType().getComponentType(), array.length + 1);
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = elementToAdd;
            field.set(collectionOwnerInstance, newArray);
            return;
        }
        Collection collectionInstance = (Collection)field.get(collectionOwnerInstance);
        if (collectionInstance == null) {
            collectionInstance = CollectionFactory.createCollection(field.getType(), ModelUtils.getCollectionType(field), (int)10);
            field.set(collectionOwnerInstance, collectionInstance);
        }
        if (!collectionInstance.contains(elementToAdd)) {
            collectionInstance.add(elementToAdd);
        }
    }

    public static void removeFromCollectionField(Field field, Object collectionOwnerInstance, Object elementToRemove) throws IllegalAccessException {
        if (field.getType().isArray()) {
            Object[] array = (Object[])field.get(collectionOwnerInstance);
            if (array == null) {
                return;
            }
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != elementToRemove) continue;
                index = i;
                break;
            }
            if (index < 0) {
                return;
            }
            Object[] newArray = (Object[])Array.newInstance(field.getType().getComponentType(), array.length - 1);
            if (index > 0) {
                System.arraycopy(array, 0, newArray, 0, index);
            }
            if (index < array.length - 1) {
                System.arraycopy(array, index + 1, newArray, index, array.length - index - 1);
            }
            field.set(collectionOwnerInstance, newArray);
            return;
        }
        Collection collectionInstance = (Collection)field.get(collectionOwnerInstance);
        if (collectionInstance == null) {
            return;
        }
        collectionInstance.remove(elementToRemove);
    }

    public static Object getDatabaseValue(Object instance, RelationalPersistentProperty property, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        Object value;
        Field f = property.getRequiredField();
        f.setAccessible(true);
        try {
            value = f.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new ModelAccessException("Unable to get field value", e);
        }
        if (value == null) {
            return null;
        }
        if (property.isAnnotationPresent(ForeignKey.class)) {
            RelationalPersistentEntity e = (RelationalPersistentEntity)mappingContext.getRequiredPersistentEntity(value.getClass());
            value = e.getPropertyAccessor(value).getProperty(e.getRequiredIdProperty());
        }
        return value;
    }

    public static Object getPersistedDatabaseValue(EntityState state, RelationalPersistentProperty property, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        Object value = state.getPersistedValue(property.getName());
        if (value == null) {
            return null;
        }
        if (property.isAnnotationPresent(ForeignKey.class)) {
            RelationalPersistentEntity e = (RelationalPersistentEntity)mappingContext.getRequiredPersistentEntity(value.getClass());
            value = e.getPropertyAccessor(value).getProperty(e.getRequiredIdProperty());
        }
        return value;
    }

    public static List<RelationalPersistentProperty> getProperties(RelationalPersistentEntity<?> entityType, String ... names) {
        ArrayList<RelationalPersistentProperty> list = new ArrayList<RelationalPersistentProperty>(names.length);
        for (String name : names) {
            list.add((RelationalPersistentProperty)entityType.getRequiredPersistentProperty(name));
        }
        return list;
    }

    public static Object getId(RelationalPersistentEntity<?> entityType, PersistentPropertyAccessor<?> accessor, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        if (entityType.hasIdProperty()) {
            return ModelUtils.getIdPropertyValue(entityType, accessor);
        }
        if (entityType.isAnnotationPresent(CompositeId.class)) {
            return ModelUtils.getIdFromProperties(ModelUtils.getProperties(entityType, ((CompositeId)entityType.getRequiredAnnotation(CompositeId.class)).properties()), accessor, mappingContext);
        }
        return ModelUtils.getIdFromProperties(entityType, accessor, mappingContext);
    }

    public static Object getIdPropertyValue(RelationalPersistentEntity<?> entityType, PersistentPropertyAccessor<?> accessor) {
        return accessor.getProperty(entityType.getRequiredIdProperty());
    }

    public static CompositeIdValue getIdFromProperties(Iterable<RelationalPersistentProperty> properties, PersistentPropertyAccessor<?> accessor, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        CompositeIdValue id = new CompositeIdValue();
        for (RelationalPersistentProperty property : properties) {
            id.add(property.getName(), ModelUtils.getDatabaseValue(accessor.getBean(), property, mappingContext));
        }
        return id;
    }

    public static Object getId(RelationalPersistentEntity<?> entityType, PropertiesSource source) {
        if (entityType.hasIdProperty()) {
            return ModelUtils.getIdPropertyValue(entityType, source);
        }
        if (entityType.isAnnotationPresent(CompositeId.class)) {
            return ModelUtils.getIdFromProperties(ModelUtils.getProperties(entityType, ((CompositeId)entityType.getRequiredAnnotation(CompositeId.class)).properties()), source);
        }
        return ModelUtils.getIdFromProperties(entityType, source);
    }

    public static Object getIdPropertyValue(RelationalPersistentEntity<?> entityType, PropertiesSource source) {
        return source.getPropertyValue((RelationalPersistentProperty)entityType.getRequiredIdProperty());
    }

    public static CompositeIdValue getIdFromProperties(Iterable<RelationalPersistentProperty> properties, PropertiesSource source) {
        CompositeIdValue id = new CompositeIdValue();
        for (RelationalPersistentProperty property : properties) {
            id.add(property.getName(), source.getPropertyValue(property));
        }
        return id;
    }

    public static Condition getConditionOnId(SqlQuery<?> query, RelationalPersistentEntity<?> entityType, PersistentPropertyAccessor<?> accessor, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        if (entityType.hasIdProperty()) {
            return ModelUtils.getConditionOnProperties(query, entityType, Arrays.asList((RelationalPersistentProperty)entityType.getRequiredIdProperty()), accessor, mappingContext);
        }
        if (entityType.isAnnotationPresent(CompositeId.class)) {
            return ModelUtils.getConditionOnProperties(query, entityType, ModelUtils.getProperties(entityType, ((CompositeId)entityType.getRequiredAnnotation(CompositeId.class)).properties()), accessor, mappingContext);
        }
        return ModelUtils.getConditionOnProperties(query, entityType, entityType, accessor, mappingContext);
    }

    public static Condition getConditionOnProperties(SqlQuery<?> query, RelationalPersistentEntity<?> entityType, Iterable<RelationalPersistentProperty> properties, PersistentPropertyAccessor<?> accessor, MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        Iterator<RelationalPersistentProperty> it = properties.iterator();
        Comparison condition = null;
        Table table = Table.create((SqlIdentifier)entityType.getTableName());
        do {
            RelationalPersistentProperty property = it.next();
            Object value = ModelUtils.getDatabaseValue(accessor.getBean(), property, mappingContext);
            Comparison propertyCondition = Conditions.isEqual((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)table), (Expression)(value != null ? query.marker(value) : SQL.nullLiteral()));
            Object object = condition = condition != null ? condition.and((Condition)propertyCondition) : propertyCondition;
        } while (it.hasNext());
        return condition;
    }
}

