/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.mapping;

import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.annotations.ForeignKey;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.model.EntityCache;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.PropertiesSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.relational.core.conversion.BasicRelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LcEntityReader {
    private static final Log logger = LogFactory.getLog(LcEntityReader.class);
    private CustomConversions conversions;
    private ConversionService conversionService;
    private EntityCache cache;
    private LcReactiveDataRelationalClient client;

    public LcEntityReader(@Nullable EntityCache cache, @Nullable CustomConversions conversions, LcReactiveDataRelationalClient client) {
        this.cache = cache != null ? cache : new EntityCache();
        R2dbcConverter converter = client.getDataAccess().getConverter();
        if (conversions != null) {
            this.conversions = conversions;
        } else if (converter instanceof BasicRelationalConverter) {
            this.conversions = ((BasicRelationalConverter)converter).getConversions();
        } else {
            throw new IllegalArgumentException("No conversions");
        }
        this.conversionService = converter.getConversionService();
        this.client = client;
    }

    public LcEntityReader(@Nullable EntityCache cache, LcMappingR2dbcConverter converter) {
        this(cache, converter.getConversions(), converter.getLcClient());
    }

    public EntityCache getCache() {
        return this.cache;
    }

    public <T> T read(Class<T> type, PropertiesSource source) {
        Class<?> sourceType;
        ClassTypeInformation typeInfo = ClassTypeInformation.from(type);
        Class rawType = typeInfo.getType();
        if (rawType.isAssignableFrom(sourceType = source.getSource().getClass())) {
            return (T)source.getSource();
        }
        if (this.conversions.hasCustomReadTarget(sourceType, rawType) && this.conversionService.canConvert(sourceType, rawType)) {
            return (T)this.conversionService.convert(source.getSource(), rawType);
        }
        return this.read((RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(type), source);
    }

    public <T> T read(RelationalPersistentEntity<T> entityType, PropertiesSource source) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read <" + source.getSource() + "> into " + entityType.getName()));
        }
        T result = this.getOrCreateInstance(entityType, source);
        EntityState state = EntityState.get(result, this.client, entityType);
        if (entityType.requiresPropertyPopulation()) {
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entityType.getPropertyAccessor(result), this.conversionService);
            for (RelationalPersistentProperty property : entityType) {
                Object value;
                if (entityType.isConstructorArgument((PersistentProperty)property) || (value = this.readProperty(property, source, result)) == null) continue;
                propertyAccessor.setProperty((PersistentProperty)property, value);
            }
        }
        state.loaded(result);
        return result;
    }

    protected Object readProperty(RelationalPersistentProperty property, PropertiesSource source, Object instance) {
        if (property.isEntity()) {
            return this.readEntityProperty(property, instance, source);
        }
        if (!source.isPropertyPresent(property)) {
            return null;
        }
        Object value = source.getPropertyValue(property);
        return this.readValue(value, property.getTypeInformation());
    }

    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (null == value) {
            return null;
        }
        value = this.client.getSchemaDialect().convertFromDataBase(value, type.getType());
        if (this.conversions.hasCustomReadTarget(value.getClass(), type.getType())) {
            return this.conversionService.convert(value, type.getType());
        }
        if (value instanceof String && char[].class.equals((Object)type.getType())) {
            return ((String)value).toCharArray();
        }
        return this.getPotentiallyConvertedSimpleRead(value, type.getType());
    }

    @Nullable
    protected Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, target);
    }

    protected <T> T readEntityProperty(RelationalPersistentProperty property, Object parentInstance, PropertiesSource source) {
        RelationalPersistentEntity entityType = (RelationalPersistentEntity)this.client.getMappingContext().getRequiredPersistentEntity(property.getActualType());
        if (property.isAnnotationPresent(ForeignKey.class)) {
            return this.readForeignKeyEntity(property, parentInstance, entityType, source);
        }
        throw new MappingException("Sub-entity without @ForeignKey is not supported: " + property.getName());
    }

    protected <T> T readForeignKeyEntity(RelationalPersistentProperty property, Object parentInstance, RelationalPersistentEntity<T> entityType, PropertiesSource source) {
        if (!source.isPropertyPresent(property)) {
            return null;
        }
        Object value = source.getPropertyValue(property);
        if (value == null) {
            return null;
        }
        T instance = this.getOrCreateInstance(entityType, source, value);
        EntityState state = EntityState.get(instance, this.client, entityType);
        if (!state.isLoaded()) {
            entityType.getPropertyAccessor(instance).setProperty(entityType.getRequiredIdProperty(), value);
        }
        ModelUtils.setReverseLink(instance, parentInstance, property);
        if (!state.isLoaded()) {
            state.lazyLoaded();
        }
        return instance;
    }

    protected <T> T getOrCreateInstance(RelationalPersistentEntity<T> entityType, PropertiesSource source) {
        Object id;
        try {
            id = ModelUtils.getId(entityType, source);
        }
        catch (Exception e) {
            id = null;
        }
        return this.getOrCreateInstance(entityType, source, id);
    }

    protected <T> T getOrCreateInstance(RelationalPersistentEntity<T> entityType, PropertiesSource source, Object id) {
        Object instance;
        if (id != null && (instance = this.cache.getById(entityType.getType(), id)) != null) {
            return instance;
        }
        PropertiesSourceParameterValueProvider parameterValueProvider = new PropertiesSourceParameterValueProvider(entityType, source, this.conversionService);
        Object instance2 = this.client.getMapper().createInstance((PersistentEntity)entityType, parameterValueProvider::getParameterValue);
        if (id != null) {
            this.cache.setById(entityType.getType(), id, instance2);
        }
        return (T)instance2;
    }

    public static class PropertiesSourceParameterValueProvider
    implements ParameterValueProvider<RelationalPersistentProperty> {
        private final RelationalPersistentEntity<?> entityType;
        private final PropertiesSource source;
        private final ConversionService conversionService;

        public PropertiesSourceParameterValueProvider(RelationalPersistentEntity<?> entityType, PropertiesSource source, ConversionService conversionService) {
            this.entityType = entityType;
            this.source = source;
            this.conversionService = conversionService;
        }

        @Nullable
        public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
            String paramName = parameter.getName();
            Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
            RelationalPersistentProperty property = (RelationalPersistentProperty)this.entityType.getRequiredPersistentProperty(paramName);
            if (!this.source.isPropertyPresent(property)) {
                return null;
            }
            Object value = this.source.getPropertyValue(property);
            if (value == null) {
                return null;
            }
            Class type = parameter.getType().getType();
            if (type.isInstance(value)) {
                return type.cast(value);
            }
            return (T)this.conversionService.convert(value, type);
        }
    }
}

