/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.model1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.model1.Company;
import net.lecousin.reactive.data.relational.test.model1.CompanyRepository;
import net.lecousin.reactive.data.relational.test.model1.Employee;
import net.lecousin.reactive.data.relational.test.model1.Person;
import net.lecousin.reactive.data.relational.test.model1.PersonRepository;
import net.lecousin.reactive.data.relational.test.model1.PointOfContact;
import net.lecousin.reactive.data.relational.test.model1.PostalAddress;
import net.lecousin.reactive.data.relational.test.model1.Site;
import net.lecousin.reactive.data.relational.test.model1.User;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractTestModel1
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private PersonRepository repoPerson;
    @Autowired
    private CompanyRepository repoCompany;

    private void createModel() {
        Person johnSmith = AbstractTestModel1.createPerson("John", "Smith", null);
        Person joeSmith = AbstractTestModel1.createPerson("Joe", "Smith", AbstractTestModel1.createAddress("Street 5", 12345, "Madrid", "ES"));
        Person emilyTaylor = AbstractTestModel1.createPerson("Emily", "Taylor", null);
        Person jessicaTaylor = AbstractTestModel1.createPerson("Jessica", "Taylor", AbstractTestModel1.createAddress("Street 3", 1111, "Paris", "FR"));
        Person meganDavis = AbstractTestModel1.createPerson("Megan", "Davis", null);
        Person jamesMiller = AbstractTestModel1.createPerson("James", "Miller", null);
        Company google = AbstractTestModel1.createCompany("Google");
        Company apple = AbstractTestModel1.createCompany("Apple");
        Company microsoft = AbstractTestModel1.createCompany("Microsoft");
        AbstractTestModel1.addEmployee(google, johnSmith);
        AbstractTestModel1.addEmployee(google, joeSmith);
        AbstractTestModel1.addEmployee(apple, emilyTaylor);
        AbstractTestModel1.addEmployee(microsoft, jessicaTaylor);
        AbstractTestModel1.addSite(google, AbstractTestModel1.createAddress("Street 1", 12345, "Madrid", "ES"), "Google Spain");
        AbstractTestModel1.addSite(apple, AbstractTestModel1.createAddress("Street 5", 4587, "London", "UK"), "Apple UK");
        AbstractTestModel1.addSite(apple, AbstractTestModel1.createAddress("Street 1", 6982, "Paris", "FR"), "Apple FR");
        AbstractTestModel1.addSite(microsoft, AbstractTestModel1.createAddress("Street 2", 12345, "Madrid", "ES"), "Microsoft Spain");
        AbstractTestModel1.addSite(microsoft, AbstractTestModel1.createAddress("Street 3", 963852, "Marseille", "FR"), "Microsoft France");
        google.setProviders(new PointOfContact[]{AbstractTestModel1.createPOC(google, apple, meganDavis, "poc1"), AbstractTestModel1.createPOC(google, microsoft, jessicaTaylor, "poc2")});
        apple.setProviders(new PointOfContact[]{AbstractTestModel1.createPOC(apple, microsoft, jamesMiller, "poc3")});
        microsoft.setProviders(new PointOfContact[]{AbstractTestModel1.createPOC(microsoft, apple, jamesMiller, "poc4")});
        google.setOwner(meganDavis);
        apple.setOwner(jamesMiller);
        microsoft.setOwner(emilyTaylor);
        this.repoCompany.saveAll(Arrays.asList(google, apple, microsoft)).collectList().block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)7, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    private static Person createPerson(String firstName, String lastName, PostalAddress address) {
        Person p = new Person();
        p.setFirstName(firstName);
        p.setLastName(lastName);
        p.setAddress(address);
        return p;
    }

    private static Company createCompany(String name) {
        Company c = new Company();
        c.setName(name);
        return c;
    }

    private static PostalAddress createAddress(String street, int postalCode, String city, String country) {
        PostalAddress a = new PostalAddress();
        a.setAddress(street);
        a.setPostalCode(postalCode);
        a.setCity(city);
        a.setCountry(country);
        return a;
    }

    private static void addEmployee(Company c, Person p) {
        if (c.getEmployees() == null) {
            c.setEmployees(new LinkedList<Employee>());
        }
        Employee e = new Employee();
        e.setCompany(c);
        e.setPerson(p);
        c.getEmployees().add(e);
    }

    private static void addSite(Company c, PostalAddress a, String name) {
        Site s = new Site();
        s.setCompany(c);
        s.setAddress(a);
        s.setName(name);
        if (c.getSites() == null) {
            c.setSites(new LinkedList<Site>());
        }
        c.getSites().add(s);
    }

    private static PointOfContact createPOC(Company owner, Company provider, Person person, String description) {
        PointOfContact poc = new PointOfContact();
        poc.setOwner(owner);
        poc.setPerson(person);
        poc.setProvider(provider);
        poc.setDescription(description);
        return poc;
    }

    @SafeVarargs
    private <T> void expectEntities(Class<T> type, ExpectedEntity<T> ... expected) {
        List found = (List)SelectQuery.from(type, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)expected.length, (int)found.size());
        ArrayList expectedEntities = new ArrayList(expected.length);
        Collections.addAll(expectedEntities, expected);
        StringBuilder error = new StringBuilder();
        for (Object entity : found) {
            boolean matchFound = false;
            StringBuilder valuesFound = new StringBuilder();
            boolean first = true;
            Iterator it = expectedEntities.iterator();
            while (it.hasNext()) {
                ExpectedEntity expectedEntity = (ExpectedEntity)it.next();
                boolean match = true;
                ExpectedValue<T, ?>[] expectedValueArray = expectedEntity.expectedValues;
                int n = expectedValueArray.length;
                for (int i = 0; i < n; ++i) {
                    ExpectedValue expectedValue = expectedValueArray[i];
                    Object value = expectedValue.supplier.apply(entity);
                    if (first) {
                        valuesFound.append('<').append(value).append('>');
                    }
                    if (Objects.equals(value, expectedValue.expected)) continue;
                    match = false;
                }
                first = false;
                if (!match) continue;
                it.remove();
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            error.append("Unexpected ").append(type.getSimpleName()).append(" with values ").append((CharSequence)valuesFound);
            for (ExpectedEntity expectedEntity : expectedEntities) {
                error.append("\n - ");
                for (ExpectedValue expectedValue : expectedEntity.expectedValues) {
                    error.append('<').append(expectedValue.expected).append('>');
                }
            }
            error.append('\n');
        }
        if (!expectedEntities.isEmpty()) {
            error.append("Remaining expected entities: ");
            for (ExpectedEntity expectedEntity : expectedEntities) {
                error.append("\n - ");
                for (ExpectedValue expectedValue : expectedEntity.expectedValues) {
                    error.append('<').append(expectedValue.expected).append('>');
                }
            }
            error.append('\n');
        }
        if (error.length() > 0) {
            throw new AssertionError((Object)error.toString());
        }
    }

    @Test
    public void testLazyGetArray() {
        this.createModel();
        Company microsoft = (Company)this.repoCompany.findByName("Microsoft").block();
        Assertions.assertNull((Object)microsoft.getProviders());
        Assertions.assertEquals((int)1, (int)((List)microsoft.lazyGetProviders().collectList().block()).size());
        Assertions.assertEquals((int)1, (int)microsoft.getProviders().length);
        Assertions.assertEquals((int)1, (int)((List)microsoft.lazyGetProviders().collectList().block()).size());
        Company google = (Company)this.repoCompany.findByName("Google").block();
        Assertions.assertNull((Object)google.getProviders());
        Assertions.assertEquals((int)2, (int)((List)google.lazyGetProviders().collectList().block()).size());
        Assertions.assertEquals((int)2, (int)google.getProviders().length);
        Assertions.assertEquals((int)2, (int)((List)google.lazyGetProviders().collectList().block()).size());
    }

    @Test
    public void testDeleteEmployeeWithLazyLoadedPerson() {
        this.createModel();
        Company microsoft = (Company)this.repoCompany.findByName("Microsoft").block();
        Assertions.assertEquals((int)1, (int)((List)microsoft.lazyGetEmployees().collectList().block()).size());
        Employee employee = microsoft.getEmployees().get(0);
        Assertions.assertNotNull((Object)employee.getPerson());
        Assertions.assertFalse((boolean)employee.getPerson().entityLoaded());
        this.lcClient.delete((Object)employee).block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)7, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        List persons = (List)this.repoPerson.findByFirstName("Jessica").collectList().block();
        Assertions.assertEquals((int)1, (int)persons.size());
        Person jessica = (Person)persons.get(0);
        Assertions.assertNull((Object)jessica.lazyGetJob().block());
        microsoft = (Company)this.repoCompany.findByName("Microsoft").block();
        Assertions.assertEquals((int)0, (int)((List)microsoft.lazyGetEmployees().collectList().block()).size());
    }

    @Test
    public void testDeleteCompany() {
        this.createModel();
        Company google = (Company)this.repoCompany.findByName("Google").block();
        this.repoCompany.delete(google).block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)6, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)4, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testDeletePointOfContact() {
        this.createModel();
        Company microsoft = (Company)this.repoCompany.findByName("Microsoft").block();
        List pocs = (List)microsoft.lazyGetProviders().collectList().block();
        Assertions.assertEquals((int)1, (int)pocs.size());
        PointOfContact lazyPoc = (PointOfContact)SelectQuery.from(PointOfContact.class, (String)"entity").where(Criteria.property((String)"entity", (String)"id").is((Object)((PointOfContact)pocs.get(0)).getId())).execute(this.lcClient).blockFirst();
        Assertions.assertNotNull((Object)lazyPoc);
        this.lcClient.delete((Object)lazyPoc).block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)7, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testDeletePointOfContactFromLoadedCompany() {
        this.createModel();
        Company microsoft = (Company)this.repoCompany.findByName("Microsoft").block();
        List pocs = (List)microsoft.lazyGetProviders().collectList().block();
        Assertions.assertEquals((int)1, (int)pocs.size());
        this.lcClient.delete((Object)((PointOfContact)pocs.get(0))).block();
        Assertions.assertEquals((int)0, (int)microsoft.getProviders().length);
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)7, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testDeleteSitesFromLoadedCompany() {
        this.createModel();
        Company microsoft = (Company)this.repoCompany.findByName("Microsoft").block();
        List sites = (List)microsoft.lazyGetSites().collectList().block();
        Assertions.assertEquals((int)2, (int)sites.size());
        Assertions.assertTrue((boolean)sites.stream().anyMatch(site -> "Microsoft Spain".equals(site.getName())));
        Assertions.assertTrue((boolean)sites.stream().anyMatch(site -> "Microsoft France".equals(site.getName())));
        this.lcClient.delete((Iterable)sites).block();
        Assertions.assertEquals((int)0, (int)microsoft.getSites().size());
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testDeletePerson() {
        this.createModel();
        List persons = (List)this.repoPerson.findByFirstName("Jessica").collectList().block();
        Assertions.assertEquals((int)1, (int)persons.size());
        Person jessica = (Person)persons.get(0);
        this.repoPerson.delete(jessica).block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, Object>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, null), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 2)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)6, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testDeletePersonNotLoaded() {
        this.createModel();
        Company microsoft = (Company)this.repoCompany.findByName("Microsoft").block();
        Person jessica = ((Employee)((List)microsoft.lazyGetEmployees().collectList().block()).get(0)).getPerson();
        this.repoPerson.delete(jessica).block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, Object>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, null), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 2)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)6, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testFindAllWithJoins() {
        this.createModel();
        List companies = (List)this.repoCompany.findAllWithJoins().collectList().block();
        Assertions.assertEquals((int)3, (int)companies.size());
        Company company = companies.stream().filter(e -> "Google".equals(e.getName())).findFirst().get();
        Assertions.assertEquals((int)2, (int)company.getEmployees().size());
        Person person = company.getEmployees().stream().filter(e -> "John".equals(e.getPerson().getFirstName())).findFirst().get().getPerson();
        Assertions.assertNull((Object)person.getAddress());
        Assertions.assertTrue((person.getJob().getCompany() == company ? 1 : 0) != 0);
        person = company.getEmployees().stream().filter(e -> "Joe".equals(e.getPerson().getFirstName())).findFirst().get().getPerson();
        Assertions.assertNotNull((Object)person.getAddress());
        Assertions.assertEquals((Object)"Madrid", (Object)person.getAddress().getCity());
        Assertions.assertTrue((person.getJob().getCompany() == company ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)company.getSites().size());
        Site site = company.getSites().get(0);
        Assertions.assertEquals((Object)"Google Spain", (Object)site.getName());
        Assertions.assertEquals((Object)"Madrid", (Object)site.getAddress().getCity());
        Assertions.assertEquals((int)2, (int)company.getProviders().length);
        PointOfContact poc = Arrays.asList(company.getProviders()).stream().filter(e -> "Microsoft".equals(e.getProvider().getName())).findFirst().get();
        Assertions.assertTrue((poc.getOwner() == company ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"Jessica", (Object)poc.getPerson().getFirstName());
        poc = Arrays.asList(company.getProviders()).stream().filter(e -> "Apple".equals(e.getProvider().getName())).findFirst().get();
        Assertions.assertTrue((poc.getOwner() == company ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"Megan", (Object)poc.getPerson().getFirstName());
        company = companies.stream().filter(e -> "Microsoft".equals(e.getName())).findFirst().get();
        Assertions.assertEquals((int)1, (int)company.getEmployees().size());
        person = company.getEmployees().stream().filter(e -> "Jessica".equals(e.getPerson().getFirstName())).findFirst().get().getPerson();
        Assertions.assertNotNull((Object)person.getAddress());
        Assertions.assertEquals((Object)"Paris", (Object)person.getAddress().getCity());
        Assertions.assertTrue((person.getJob().getCompany() == company ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)company.getSites().size());
        site = company.getSites().stream().filter(e -> "Madrid".equals(e.getAddress().getCity())).findFirst().get();
        Assertions.assertEquals((Object)"Microsoft Spain", (Object)site.getName());
        site = company.getSites().stream().filter(e -> "Marseille".equals(e.getAddress().getCity())).findFirst().get();
        Assertions.assertEquals((Object)"Microsoft France", (Object)site.getName());
        Assertions.assertEquals((int)1, (int)company.getProviders().length);
        poc = Arrays.asList(company.getProviders()).stream().filter(e -> "Apple".equals(e.getProvider().getName())).findFirst().get();
        Assertions.assertTrue((poc.getOwner() == company ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"James", (Object)poc.getPerson().getFirstName());
        company = companies.stream().filter(e -> "Apple".equals(e.getName())).findFirst().get();
        Assertions.assertEquals((int)1, (int)company.getEmployees().size());
        person = company.getEmployees().stream().filter(e -> "Emily".equals(e.getPerson().getFirstName())).findFirst().get().getPerson();
        Assertions.assertNull((Object)person.getAddress());
        Assertions.assertTrue((person.getJob().getCompany() == company ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)company.getSites().size());
        site = company.getSites().stream().filter(e -> "London".equals(e.getAddress().getCity())).findFirst().get();
        Assertions.assertEquals((Object)"Apple UK", (Object)site.getName());
        site = company.getSites().stream().filter(e -> "Paris".equals(e.getAddress().getCity())).findFirst().get();
        Assertions.assertEquals((Object)"Apple FR", (Object)site.getName());
        Assertions.assertEquals((int)1, (int)company.getProviders().length);
        poc = Arrays.asList(company.getProviders()).stream().filter(e -> "Microsoft".equals(e.getProvider().getName())).findFirst().get();
        Assertions.assertTrue((poc.getOwner() == company ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"James", (Object)poc.getPerson().getFirstName());
        companies = (List)this.repoCompany.findAllWithJoins(0, 2).collectList().block();
        Assertions.assertEquals((int)2, (int)companies.size());
        companies = (List)this.repoCompany.findAllWithJoins(1, 2).collectList().block();
        Assertions.assertEquals((int)2, (int)companies.size());
        companies = (List)this.repoCompany.findAllWithJoins(2, 2).collectList().block();
        Assertions.assertEquals((int)1, (int)companies.size());
        companies = (List)this.repoCompany.findAllWithJoins(3, 2).collectList().block();
        Assertions.assertEquals((int)0, (int)companies.size());
        companies = (List)this.repoCompany.findAllWithJoins(4, 2).collectList().block();
        Assertions.assertEquals((int)0, (int)companies.size());
    }

    @Test
    public void testDeletePointOfContactFromLoadedEntities() {
        this.createModel();
        List companies = (List)this.repoCompany.findAllWithJoins().collectList().block();
        Company company = companies.stream().filter(e -> "Google".equals(e.getName())).findFirst().get();
        company.setProviders(null);
        this.repoCompany.save(company).block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
        Assertions.assertEquals((int)7, (int)((List)SelectQuery.from(PostalAddress.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Site.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testRemoveOwningCompanyFromPerson() {
        this.createModel();
        List companies = (List)this.repoCompany.findAllWithJoins().collectList().block();
        Company company = companies.stream().filter(e -> "Google".equals(e.getName())).findFirst().get();
        Person owner = company.getOwner();
        Assertions.assertNotNull((Object)owner);
        Assertions.assertNotNull((Object)owner.getOwningCompany());
        Assertions.assertTrue((company == owner.getOwningCompany() ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"Megan", (Object)owner.getFirstName());
        owner.setOwningCompany(null);
        this.repoPerson.save(owner).block();
        Assertions.assertNull((Object)company.getOwner());
        companies = (List)this.repoCompany.findAllWithJoins().collectList().block();
        company = companies.stream().filter(e -> "Google".equals(e.getName())).findFirst().get();
        Assertions.assertNull((Object)company.getOwner());
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 2L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Jessica"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Jessica"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
    }

    @Test
    public void testUniqueIndexes() {
        this.createModel();
        Company google = AbstractTestModel1.createCompany("Google");
        try {
            this.repoCompany.save(google).block();
            throw new AssertionError((Object)"Error expected when creating a company with the same name");
        }
        catch (Exception exception) {
            Person person = AbstractTestModel1.createPerson("John", "Smith2", null);
            this.repoPerson.save(person).block();
            person = AbstractTestModel1.createPerson("John2", "Smith", null);
            this.repoPerson.save(person).block();
            person = AbstractTestModel1.createPerson("John", "Smith", null);
            try {
                this.repoPerson.save(person).block();
                throw new AssertionError((Object)"Error expected when creating a person with the same name");
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    @Test
    public void testRemovePersonFromUserAndUpdatePointOfContactInSameOperation() {
        this.createModel();
        User user = new User();
        user.setUsername("abcd");
        user.setPerson((Person)this.repoPerson.findByFirstName("Jessica").blockFirst());
        user = (User)this.lcClient.save((Object)user).block();
        user.setPerson(null);
        PointOfContact poc = (PointOfContact)SelectQuery.from(PointOfContact.class, (String)"poc").where(Criteria.property((String)"poc", (String)"description").is((Object)"poc2")).execute(this.lcClient).blockFirst();
        poc.setDescription("poc2.2");
        poc.setPerson(null);
        this.lcClient.saveAll(new Object[]{user, poc}).block();
        this.expectEntities(Company.class, new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Google"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Microsoft"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)), new ExpectedEntity(new ExpectedValue<Company, String>(Company::getName, "Apple"), new ExpectedValue<Company, Long>(Company::getVersion, 1L)));
        this.expectEntities(Employee.class, new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "John")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Google"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Joe")), new ExpectedEntity(new ExpectedValue<Employee, String>(e -> ((Company)e.getCompany().loadEntity().block()).getName(), "Apple"), new ExpectedValue<Employee, String>(e -> ((Person)e.getPerson().loadEntity().block()).getFirstName(), "Emily")));
        this.expectEntities(Person.class, new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "John"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Joe"), new ExpectedValue<Person, String>(Person::getLastName, "Smith"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Emily"), new ExpectedValue<Person, String>(Person::getLastName, "Taylor"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "Megan"), new ExpectedValue<Person, String>(Person::getLastName, "Davis"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)), new ExpectedEntity(new ExpectedValue<Person, String>(Person::getFirstName, "James"), new ExpectedValue<Person, String>(Person::getLastName, "Miller"), new ExpectedValue<Person, Integer>(Person::getVersion, 1)));
        this.expectEntities(PointOfContact.class, new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "Megan"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Google"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, Object>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, null), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 2), new ExpectedValue<PointOfContact, String>(PointOfContact::getDescription, "poc2.2")), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)), new ExpectedEntity(new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getOwner().loadEntity().block()).getName(), "Microsoft"), new ExpectedValue<PointOfContact, String>(e -> ((Company)e.getProvider().loadEntity().block()).getName(), "Apple"), new ExpectedValue<PointOfContact, String>(e -> e.getPerson() != null ? ((Person)e.getPerson().loadEntity().block()).getFirstName() : null, "James"), new ExpectedValue<PointOfContact, Integer>(PointOfContact::getVersion, 1)));
    }

    private static class ExpectedValue<S, T> {
        private Function<S, T> supplier;
        private T expected;

        public ExpectedValue(Function<S, T> supplier, T expected) {
            this.supplier = supplier;
            this.expected = expected;
        }
    }

    private static class ExpectedEntity<T> {
        private ExpectedValue<T, ?>[] expectedValues;

        @SafeVarargs
        public ExpectedEntity(ExpectedValue<T, ?> ... expectedValues) {
            this.expectedValues = expectedValues;
        }
    }
}

