/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test;

import java.util.Arrays;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.enhance.Enhancer;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.Entity;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractBasicTest
extends AbstractLcReactiveDataRelationalTest {
    @Test
    public void testEnhanceAgain() {
        Enhancer.enhance(Arrays.asList(((Class)Enhancer.getEntities().iterator().next()).getName()));
    }

    @Test
    public void testEnhanceNonEntityClass() {
        try {
            Enhancer.enhance(Arrays.asList(this.getClass().getName()));
            throw new AssertionError((Object)"Error expected");
        }
        catch (ModelAccessException modelAccessException) {
            return;
        }
    }

    @Test
    public void testGetStateWithoutEntityType() throws Exception {
        Entity entity = new Entity();
        LcReactiveDataRelationalClient client = (LcReactiveDataRelationalClient)Mockito.mock(LcReactiveDataRelationalClient.class);
        MappingContext mappingContext = (MappingContext)Mockito.mock(MappingContext.class);
        RelationalPersistentEntity entityType = (RelationalPersistentEntity)Mockito.mock(RelationalPersistentEntity.class);
        Mockito.when((Object)client.getMappingContext()).thenReturn((Object)mappingContext);
        Mockito.when((Object)mappingContext.getRequiredPersistentEntity(entity.getClass())).thenReturn((Object)entityType);
        EntityState.get((Object)entity, (LcReactiveDataRelationalClient)client);
    }

    @Test
    public void testGetEntityStateError() throws Exception {
        Entity entity = new Entity();
        try {
            EntityState.get((Object)entity, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

