/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema.dialect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.Index;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.SchemaException;
import net.lecousin.reactive.data.relational.schema.Sequence;
import net.lecousin.reactive.data.relational.schema.Table;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatement;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatements;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.SimpleFunction;

public abstract class RelationalDatabaseSchemaDialect {
    public static final int DEFAULT_FLOATING_POINT_PRECISION = 10;
    public static final int DEFAULT_FLOATING_POINT_SCALE = 2;
    public static final int DEFAULT_TIME_PRECISION = 3;
    protected Map<Class<?>, ColumnTypeMapper> classToColumnType = new HashMap();

    protected RelationalDatabaseSchemaDialect() {
        this.classToColumnType.put(Boolean.TYPE, this::getColumnTypeBoolean);
        this.classToColumnType.put(Boolean.class, this::getColumnTypeBoolean);
        this.classToColumnType.put(Byte.TYPE, this::getColumnTypeByte);
        this.classToColumnType.put(Byte.class, this::getColumnTypeByte);
        this.classToColumnType.put(Short.TYPE, this::getColumnTypeShort);
        this.classToColumnType.put(Short.class, this::getColumnTypeShort);
        this.classToColumnType.put(Integer.TYPE, this::getColumnTypeInteger);
        this.classToColumnType.put(Integer.class, this::getColumnTypeInteger);
        this.classToColumnType.put(Long.TYPE, this::getColumnTypeLong);
        this.classToColumnType.put(Long.class, this::getColumnTypeLong);
        this.classToColumnType.put(Float.TYPE, this::getColumnTypeFloat);
        this.classToColumnType.put(Float.class, this::getColumnTypeFloat);
        this.classToColumnType.put(Double.TYPE, this::getColumnTypeDouble);
        this.classToColumnType.put(Double.class, this::getColumnTypeDouble);
        this.classToColumnType.put(BigDecimal.class, this::getColumnTypeBigDecimal);
        this.classToColumnType.put(String.class, this::getColumnTypeString);
        this.classToColumnType.put(char[].class, this::getColumnTypeString);
        this.classToColumnType.put(Character.TYPE, this::getColumnTypeChar);
        this.classToColumnType.put(Character.class, this::getColumnTypeChar);
        this.classToColumnType.put(LocalDate.class, this::getColumnTypeDate);
        this.classToColumnType.put(LocalTime.class, this::getColumnTypeTime);
        if (!this.isTimeZoneSupported()) {
            this.classToColumnType.put(OffsetTime.class, (col, gt, t, def) -> {
                throw new SchemaException("Time with timezone not supported by " + this.getName() + " for column " + col.getReferenceName() + " with type " + t.getName());
            });
        } else {
            this.classToColumnType.put(OffsetTime.class, this::getColumnTypeTimeWithTimeZone);
        }
        this.classToColumnType.put(LocalDateTime.class, this::getColumnTypeDateTime);
        if (!this.isTimeZoneSupported()) {
            this.classToColumnType.put(ZonedDateTime.class, (col, gt, t, def) -> {
                throw new SchemaException("DateTime with timezone not supported by " + this.getName() + " for column " + col.getReferenceName() + " with type " + t.getName());
            });
        } else {
            this.classToColumnType.put(ZonedDateTime.class, this::getColumnTypeDateTimeWithTimeZone);
        }
        this.classToColumnType.put(Instant.class, this::getColumnTypeTimestamp);
        this.classToColumnType.put(UUID.class, this::getColumnTypeUUID);
    }

    public abstract String getName();

    public abstract boolean isCompatible(R2dbcDialect var1);

    public static RelationalDatabaseSchemaDialect getDialect(R2dbcDialect r2dbcDialect) {
        return ServiceLoader.load(RelationalDatabaseSchemaDialect.class).stream().map(ServiceLoader.Provider::get).filter(dialect -> dialect.isCompatible(r2dbcDialect)).findFirst().orElseThrow();
    }

    public Object convertToDataBase(Object value, PropertyMetadata property) {
        return value;
    }

    public Object convertFromDataBase(Object value, Class<?> targetType) {
        return value;
    }

    public String getColumnType(Column col, Type genericType, ColumnDefinition def) {
        Class type;
        if (genericType instanceof Class) {
            type = (Class)genericType;
        } else if (genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getRawType();
        } else {
            throw new SchemaException("Column type not supported: " + genericType + " on column " + col.getReferenceName() + " with " + this.getName());
        }
        ColumnTypeMapper mapper = this.classToColumnType.get(type);
        if (mapper != null) {
            return mapper.getColumnType(col, genericType, type, def);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.getColumnTypeEnum(col, genericType, type, def);
        }
        if (this.isArrayColumnSupported()) {
            Type elementType = null;
            if (type.isArray()) {
                elementType = type.getComponentType();
            } else if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
                elementType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            }
            if (elementType != null) {
                return this.getArrayColumnType(col, genericType, type, elementType, def);
            }
        }
        return this.customColumnTypes(col, genericType, type, def);
    }

    protected String customColumnTypes(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        throw new SchemaException("Column type not supported: " + type.getName() + " on column " + col.getReferenceName() + " with " + this.getName());
    }

    protected String getColumnTypeBoolean(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "BOOLEAN";
    }

    protected String getColumnTypeByte(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "TINYINT";
    }

    protected String getColumnTypeShort(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "SMALLINT";
    }

    protected String getColumnTypeInteger(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "INT";
    }

    protected String getColumnTypeLong(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "BIGINT";
    }

    protected String getColumnTypeFloat(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "FLOAT";
    }

    protected String getColumnTypeDouble(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "DOUBLE";
    }

    protected String getColumnTypeBigDecimal(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        int scale;
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 10;
        }
        int n2 = scale = def != null ? def.scale() : -1;
        if (scale < 0) {
            scale = 2;
        }
        return "DECIMAL(" + precision + "," + scale + ")";
    }

    protected String getColumnTypeChar(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return this.getColumnTypeShort(col, genericType, type, def);
    }

    protected String getColumnTypeString(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        if (def != null) {
            if (def.max() > Integer.MAX_VALUE) {
                return "CLOB(" + def.max() + ")";
            }
            if (def.max() > 0L) {
                return "VARCHAR(" + def.max() + ")";
            }
        }
        return "VARCHAR";
    }

    public boolean isTimeZoneSupported() {
        return true;
    }

    protected String getColumnTypeTimestamp(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "TIMESTAMP(" + precision + ")";
    }

    protected String getColumnTypeDate(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "DATE";
    }

    protected String getColumnTypeTime(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "TIME(" + precision + ")";
    }

    protected String getColumnTypeTimeWithTimeZone(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "TIME(" + precision + ") WITH TIME ZONE";
    }

    protected String getColumnTypeDateTime(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "DATETIME(" + precision + ")";
    }

    protected String getColumnTypeDateTimeWithTimeZone(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        int precision;
        int n = precision = def != null ? def.precision() : -1;
        if (precision < 0) {
            precision = 3;
        }
        return "DATETIME(" + precision + ") WITH TIME ZONE";
    }

    protected String getColumnTypeUUID(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        return "UUID";
    }

    protected String getColumnTypeEnum(Column col, Type genericType, Class<?> type, ColumnDefinition def) {
        int max = 1;
        for (Object enumValue : type.getEnumConstants()) {
            max = Math.max(max, enumValue.toString().length());
        }
        return "VARCHAR(" + max + ")";
    }

    public boolean isArrayColumnSupported() {
        return false;
    }

    protected String getArrayColumnType(Column col, Type genericType, Class<?> type, Type genericElementType, ColumnDefinition def) {
        throw new SchemaException("Array column not supported");
    }

    public SchemaStatements dropSchemaContent(RelationalDatabaseSchema schema) {
        SchemaStatements toExecute = new SchemaStatements();
        HashMap<Table, SchemaStatement> dropTableMap = new HashMap<Table, SchemaStatement>();
        for (Table table : schema.getTables()) {
            SchemaStatement dropTable = new SchemaStatement(this.dropTable(table));
            toExecute.add(dropTable);
            dropTableMap.put(table, dropTable);
        }
        for (Table table : schema.getTables()) {
            for (Column col : table.getColumns()) {
                if (col.getForeignKeyReferences() == null || col.getForeignKeyReferences().getFirst() == table) continue;
                ((SchemaStatement)dropTableMap.get(col.getForeignKeyReferences().getFirst())).addDependency((SchemaStatement)dropTableMap.get(table));
            }
        }
        if (this.supportsSequence()) {
            for (Sequence s : schema.getSequences()) {
                toExecute.add(new SchemaStatement(this.dropSequence(s)));
            }
        }
        return toExecute;
    }

    public String dropTable(Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP TABLE IF EXISTS ");
        sql.append(table.toSql());
        return sql.toString();
    }

    public SchemaStatements createSchemaContent(RelationalDatabaseSchema schema) {
        SchemaStatements toExecute = new SchemaStatements();
        Map<Table, SchemaStatement> createTableMap = this.createTables(schema, toExecute);
        this.addConstraints(schema, toExecute, createTableMap);
        this.createSequences(schema, toExecute);
        return toExecute;
    }

    private Map<Table, SchemaStatement> createTables(RelationalDatabaseSchema schema, SchemaStatements toExecute) {
        HashMap<Table, SchemaStatement> createTableMap = new HashMap<Table, SchemaStatement>();
        for (Table table : schema.getTables()) {
            SchemaStatement createTable = new SchemaStatement(this.createTable(table));
            createTableMap.put(table, createTable);
            toExecute.add(createTable);
            for (Index index : table.getIndexes()) {
                if (this.canCreateIndexInTableDefinition(index)) continue;
                SchemaStatement createIndex = new SchemaStatement(this.createIndex(table, index));
                createIndex.addDependency(createTable);
                toExecute.add(createIndex);
            }
        }
        return createTableMap;
    }

    private void createSequences(RelationalDatabaseSchema schema, SchemaStatements toExecute) {
        if (!this.supportsSequence()) {
            return;
        }
        for (Sequence s : schema.getSequences()) {
            toExecute.add(new SchemaStatement(this.createSequence(s)));
        }
    }

    private void addConstraints(RelationalDatabaseSchema schema, SchemaStatements toExecute, Map<Table, SchemaStatement> createTableMap) {
        HashMap<Table, List<SchemaStatement>> alterTableByTable = new HashMap<Table, List<SchemaStatement>>();
        HashMap<SchemaStatement, Table> foreignTable = new HashMap<SchemaStatement, Table>();
        MutableObject latestAlterTable = new MutableObject(null);
        for (Table table : schema.getTables()) {
            this.addTableConstraints(table, toExecute, createTableMap, alterTableByTable, foreignTable, (MutableObject<SchemaStatement>)latestAlterTable);
        }
        for (Map.Entry entry : foreignTable.entrySet()) {
            for (SchemaStatement statement : (List)alterTableByTable.get(entry.getValue())) {
                ((SchemaStatement)entry.getKey()).doNotExecuteTogether(statement);
            }
        }
    }

    private void addTableConstraints(Table table, SchemaStatements toExecute, Map<Table, SchemaStatement> createTableMap, Map<Table, List<SchemaStatement>> alterTableByTable, Map<SchemaStatement, Table> foreignTable, MutableObject<SchemaStatement> latestAlterTable) {
        LinkedList<SchemaStatement> alterTableList = new LinkedList<SchemaStatement>();
        StringBuilder sql = new StringBuilder();
        HashSet<Table> foreignTables = new HashSet<Table>();
        foreignTables.add(table);
        for (Column col : table.getColumns()) {
            if (col.getForeignKeyReferences() == null) continue;
            if (this.canAddMultipleConstraintsInSingleAlterTable()) {
                this.appendForeignKeyConstraint(table, col, sql);
                foreignTables.add((Table)col.getForeignKeyReferences().getFirst());
                continue;
            }
            toExecute.add(this.createAlterTableAddForeignKey(table, col, createTableMap, alterTableList, foreignTable, latestAlterTable));
        }
        if (this.canAddMultipleConstraintsInSingleAlterTable() && sql.length() > 0) {
            SchemaStatement alterTable = new SchemaStatement(sql.toString());
            for (Table foreign : foreignTables) {
                alterTable.addDependency(createTableMap.get(foreign));
            }
            if (!this.canDoConcurrentAlterTable()) {
                RelationalDatabaseSchemaDialect.addAlterTable(latestAlterTable, alterTable);
            }
            toExecute.add(alterTable);
        }
        alterTableByTable.put(table, alterTableList);
    }

    private void appendForeignKeyConstraint(Table table, Column col, StringBuilder sql) {
        if (sql.length() > 0) {
            this.appendForeignKey(table, col, sql);
        } else {
            sql.append(this.alterTableForeignKey(table, col));
        }
    }

    private SchemaStatement createAlterTableAddForeignKey(Table table, Column col, Map<Table, SchemaStatement> createTableMap, LinkedList<SchemaStatement> alterTableList, Map<SchemaStatement, Table> foreignTable, MutableObject<SchemaStatement> latestAlterTable) {
        SchemaStatement alterTable = new SchemaStatement(this.alterTableForeignKey(table, col));
        alterTable.addDependency(createTableMap.get(table));
        Table foreign = (Table)col.getForeignKeyReferences().getFirst();
        if (foreign != table) {
            alterTable.addDependency(createTableMap.get(foreign));
        }
        if (this.canDoConcurrentAlterTable()) {
            if (!alterTableList.isEmpty()) {
                alterTable.addDependency(alterTableList.getLast());
            }
            alterTableList.addLast(alterTable);
            if (foreign != table) {
                foreignTable.put(alterTable, table);
            }
        } else {
            RelationalDatabaseSchemaDialect.addAlterTable(latestAlterTable, alterTable);
        }
        return alterTable;
    }

    private static void addAlterTable(MutableObject<SchemaStatement> latestAlterTable, SchemaStatement alterTable) {
        if (latestAlterTable.getValue() != null) {
            alterTable.addDependency((SchemaStatement)latestAlterTable.getValue());
        }
        latestAlterTable.setValue((Object)alterTable);
    }

    protected boolean canDoConcurrentAlterTable() {
        return true;
    }

    protected boolean canAddMultipleConstraintsInSingleAlterTable() {
        return false;
    }

    protected boolean canCreateIndexInTableDefinition(Index index) {
        return false;
    }

    public String createTable(Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(table.toSql());
        sql.append(" (");
        boolean first = true;
        for (Column col : table.getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(", ");
            }
            this.addColumnDefinition(col, sql);
        }
        for (Index index : table.getIndexes()) {
            if (!this.canCreateIndexInTableDefinition(index)) continue;
            sql.append(", ");
            this.addIndexDefinitionInTable(table, index, sql);
        }
        sql.append(')');
        return sql.toString();
    }

    public String createIndex(Table table, Index index) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (index.isUnique()) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        sql.append(index.toSql());
        sql.append(" ON ");
        sql.append(table.toSql());
        sql.append('(');
        boolean first = true;
        for (Column col : index.getColumns()) {
            if (first) {
                first = false;
            } else {
                sql.append(',');
            }
            sql.append(col.toSql());
        }
        sql.append(')');
        return sql.toString();
    }

    protected void addColumnDefinition(Column col, StringBuilder sql) {
        sql.append(col.toSql());
        sql.append(' ');
        sql.append(col.getType());
        if (col.isRandomUuid() && this.supportsUuidGeneration()) {
            this.addDefaultRandomUuid(col, sql);
        }
        if (!col.isNullable()) {
            this.addNotNull(col, sql);
        }
        if (col.isAutoIncrement()) {
            this.addAutoIncrement(col, sql);
        }
        if (col.isPrimaryKey()) {
            this.addPrimaryKey(col, sql);
        }
    }

    protected void addIndexDefinitionInTable(Table table, Index index, StringBuilder sql) {
    }

    protected void addNotNull(Column col, StringBuilder sql) {
        sql.append(" NOT NULL");
    }

    protected void addAutoIncrement(Column col, StringBuilder sql) {
        sql.append(" AUTO_INCREMENT");
    }

    public boolean supportsUuidGeneration() {
        return true;
    }

    protected void addDefaultRandomUuid(Column col, StringBuilder sql) {
        sql.append(" DEFAULT RANDOM_UUID()");
    }

    protected void addPrimaryKey(Column col, StringBuilder sql) {
        sql.append(" PRIMARY KEY");
    }

    protected String alterTableForeignKey(Table table, Column col) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(table.toSql());
        this.addForeignKeyStatement(table, col, sql);
        return sql.toString();
    }

    protected void addForeignKeyStatement(Table table, Column col, StringBuilder sql) {
        sql.append(" ADD FOREIGN KEY (");
        sql.append(col.toSql());
        sql.append(") REFERENCES ");
        sql.append(((Table)col.getForeignKeyReferences().getFirst()).toSql());
        sql.append('(');
        sql.append(((Column)col.getForeignKeyReferences().getSecond()).toSql());
        sql.append(')');
    }

    protected void appendForeignKey(Table table, Column col, StringBuilder sql) {
        sql.append(',');
        this.addForeignKeyStatement(table, col, sql);
    }

    public boolean supportsSequence() {
        return true;
    }

    protected String dropSequence(Sequence sequence) {
        return "DROP SEQUENCE IF EXISTS " + sequence.toSql();
    }

    protected String createSequence(Sequence sequence) {
        return "CREATE SEQUENCE " + sequence.toSql() + " START WITH 1 INCREMENT BY 1";
    }

    public String sequenceNextValueFunctionName() {
        return "NEXTVAL";
    }

    public Expression applyFunctionTo(SqlFunction function, Expression expression) {
        switch (function) {
            case DAY_OF_MONTH: {
                return SimpleFunction.create((String)"DAY_OF_MONTH", Collections.singletonList(expression));
            }
            case DAY_OF_YEAR: {
                return SimpleFunction.create((String)"DAY_OF_YEAR", Collections.singletonList(expression));
            }
            case HOUR: {
                return SimpleFunction.create((String)"HOUR", Collections.singletonList(expression));
            }
            case ISO_DAY_OF_WEEK: {
                return SimpleFunction.create((String)"ISO_DAY_OF_WEEK", Collections.singletonList(expression));
            }
            case ISO_WEEK: {
                return SimpleFunction.create((String)"ISO_WEEK", Collections.singletonList(expression));
            }
            case LOWER: {
                return SimpleFunction.create((String)"LOWER", Collections.singletonList(expression));
            }
            case MINUTE: {
                return SimpleFunction.create((String)"MINUTE", Collections.singletonList(expression));
            }
            case MONTH: {
                return SimpleFunction.create((String)"MONTH", Collections.singletonList(expression));
            }
            case SECOND: {
                return SimpleFunction.create((String)"SECOND", Collections.singletonList(expression));
            }
            case UPPER: {
                return SimpleFunction.create((String)"UPPER", Collections.singletonList(expression));
            }
            case YEAR: {
                return SimpleFunction.create((String)"YEAR", Collections.singletonList(expression));
            }
        }
        throw new SchemaException("Unknown SQL function: " + function);
    }

    public Expression countDistinct(List<Expression> expressions) {
        return Functions.count((Expression[])new Expression[]{SimpleFunction.create((String)"DISTINCT", expressions)});
    }

    public boolean isMultipleInsertSupported() {
        return true;
    }

    public static enum SqlFunction {
        UPPER,
        LOWER,
        ISO_DAY_OF_WEEK,
        DAY_OF_MONTH,
        DAY_OF_YEAR,
        MONTH,
        YEAR,
        ISO_WEEK,
        HOUR,
        MINUTE,
        SECOND;

    }

    public static interface ColumnTypeMapper {
        public String getColumnType(Column var1, Type var2, Class<?> var3, ColumnDefinition var4);
    }
}

