/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.Index;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;

public class Table {
    private SqlIdentifier sqlId;
    private IdentifierProcessing idProcessing;
    private List<Column> columns = new LinkedList<Column>();
    private List<Index> indexes = new LinkedList<Index>();

    public Table(SqlIdentifier sqlId, IdentifierProcessing idProcessing) {
        this.sqlId = sqlId;
        this.idProcessing = idProcessing;
    }

    public void add(Column col) {
        this.columns.add(col);
    }

    public void add(Index index) {
        this.indexes.add(index);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    IdentifierProcessing idProcessing() {
        return this.idProcessing;
    }

    public String toSql() {
        return this.sqlId.toSql(this.idProcessing);
    }

    public String getReferenceName() {
        return this.sqlId.getReference();
    }

    public Column getColumn(String name) {
        for (Column col : this.columns) {
            if (!col.getReferenceName().equalsIgnoreCase(name)) continue;
            return col;
        }
        throw new NoSuchElementException("Column <" + name + "> in table <" + name + ">");
    }
}

