/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.lecousin.reactive.data.relational.annotations.ColumnDefinition;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.annotations.GeneratedValue;
import net.lecousin.reactive.data.relational.annotations.Indexes;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.Index;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.Sequence;
import net.lecousin.reactive.data.relational.schema.Table;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.util.Pair;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SchemaBuilderFromEntities {
    private SchemaBuilderFromEntities() {
    }

    public static RelationalDatabaseSchema build(Collection<EntityMetadata> entities) {
        RelationalDatabaseSchema schema = new RelationalDatabaseSchema();
        for (EntityMetadata entity : entities) {
            schema.add(SchemaBuilderFromEntities.buildTable(entity));
            SchemaBuilderFromEntities.addSequences(entity, schema);
        }
        for (EntityMetadata entity : entities) {
            SchemaBuilderFromEntities.addForeignKeys(entity, schema);
        }
        return schema;
    }

    protected static Table buildTable(EntityMetadata entityType) {
        Indexes indexesAnnotation;
        Table table = new Table(entityType.getTableName(), entityType.getClient().getDialect().getIdentifierProcessing());
        for (PropertyMetadata property : entityType.getPersistentProperties()) {
            try {
                table.add(SchemaBuilderFromEntities.buildColumn(table, property));
            }
            catch (Exception e) {
                throw new MappingException("Error building schema for entity " + entityType.getName() + " on property " + property.getName(), (Throwable)e);
            }
        }
        CompositeId compositeId = entityType.getCompositeIdAnnotation();
        if (compositeId != null) {
            Index index = new Index(compositeId.indexName(), entityType.getClient().getDialect().getIdentifierProcessing());
            index.setUnique(true);
            for (String propertyName : compositeId.properties()) {
                PropertyMetadata property = entityType.getRequiredPersistentProperty(propertyName);
                index.addColumn(table.getColumn(property.getColumnName().getReference()));
            }
            table.add(index);
        }
        LinkedList<net.lecousin.reactive.data.relational.annotations.Index> indexes = new LinkedList<net.lecousin.reactive.data.relational.annotations.Index>();
        net.lecousin.reactive.data.relational.annotations.Index indexAnnotation = (net.lecousin.reactive.data.relational.annotations.Index)entityType.getSpringMetadata().findAnnotation(net.lecousin.reactive.data.relational.annotations.Index.class);
        if (indexAnnotation != null) {
            indexes.add(indexAnnotation);
        }
        if ((indexesAnnotation = (Indexes)entityType.getSpringMetadata().findAnnotation(Indexes.class)) != null) {
            Collections.addAll(indexes, indexesAnnotation.value());
        }
        for (net.lecousin.reactive.data.relational.annotations.Index i : indexes) {
            Index index = new Index(i.name(), entityType.getClient().getDialect().getIdentifierProcessing());
            index.setUnique(i.unique());
            for (String propertyName : i.properties()) {
                PropertyMetadata property = entityType.getRequiredPersistentProperty(propertyName);
                index.addColumn(table.getColumn(property.getColumnName().getReference()));
            }
            table.add(index);
        }
        return table;
    }

    protected static Column buildColumn(Table table, PropertyMetadata property) {
        Column col = new Column(table, property.getColumnName());
        if (property.isId()) {
            col.setPrimaryKey(true);
        }
        col.setNullable(property.isNullable());
        GeneratedValue generated = property.getGeneratedValueAnnotation();
        if (generated != null) {
            if (GeneratedValue.Strategy.AUTO_INCREMENT.equals((Object)generated.strategy())) {
                col.setAutoIncrement(true);
            } else if (GeneratedValue.Strategy.RANDOM_UUID.equals((Object)generated.strategy())) {
                col.setRandomUuid(true);
            }
        }
        Class<?> type = property.getGenericType();
        if (property.isForeignKey()) {
            EntityMetadata entity = property.getClient().getRequiredEntity(type);
            PropertyMetadata idProperty = entity.getRequiredIdProperty();
            type = idProperty.getType();
        }
        ColumnDefinition def = (ColumnDefinition)property.getRequiredSpringProperty().findAnnotation(ColumnDefinition.class);
        col.setType(property.getClient().getSchemaDialect().getColumnType(col, type, def));
        return col;
    }

    protected static void addForeignKeys(EntityMetadata entityType, RelationalDatabaseSchema schema) {
        Iterator<PropertyMetadata> keys = entityType.getForeignKeys().iterator();
        if (!keys.hasNext()) {
            return;
        }
        Table table = schema.getTable(entityType.getTableName().getReference());
        do {
            PropertyMetadata fkProperty = keys.next();
            Column fkColumn = table.getColumn(fkProperty.getColumnName().getReference());
            EntityMetadata foreignType = entityType.getClient().getRequiredEntity(fkProperty.getType());
            PropertyMetadata foreignId = foreignType.getRequiredIdProperty();
            Table foreignTable = schema.getTable(foreignType.getTableName().getReference());
            Column foreignColumn = foreignTable.getColumn(foreignId.getColumnName().getReference());
            fkColumn.setForeignKeyReferences((Pair<Table, Column>)Pair.of((Object)foreignTable, (Object)foreignColumn));
        } while (keys.hasNext());
    }

    protected static void addSequences(EntityMetadata entityType, RelationalDatabaseSchema schema) {
        for (PropertyMetadata property : entityType.getGeneratedValues()) {
            GeneratedValue annotation = property.getRequiredGeneratedValueAnnotation();
            if (!annotation.strategy().equals((Object)GeneratedValue.Strategy.SEQUENCE)) continue;
            Assert.isTrue((boolean)StringUtils.hasText((String)annotation.sequence()), (String)"Sequence name must be specified");
            try {
                schema.getSequence(annotation.sequence());
            }
            catch (NoSuchElementException e) {
                schema.add(new Sequence(annotation.sequence(), entityType.getClient().getDialect().getIdentifierProcessing()));
            }
        }
    }
}

