/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.repository;

import java.util.Collection;
import java.util.List;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.repository.LcR2dbcEntityTemplate;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepository;
import org.reactivestreams.Publisher;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.repository.support.SimpleR2dbcRepository;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class LcR2dbcRepositoryImpl<T, ID>
extends SimpleR2dbcRepository<T, ID>
implements LcR2dbcRepository<T, ID> {
    private LcReactiveDataRelationalClient lcClient;
    private RelationalEntityInformation<T, ID> entityInfo;
    private R2dbcEntityOperations entityOperations;

    public LcR2dbcRepositoryImpl(RelationalEntityInformation<T, ID> entity, R2dbcEntityOperations entityOperations, R2dbcConverter converter) {
        super(entity, entityOperations, converter);
        this.lcClient = ((LcR2dbcEntityTemplate)entityOperations).getLcClient();
        this.entityInfo = entity;
        this.entityOperations = entityOperations;
    }

    @Override
    public LcReactiveDataRelationalClient getLcClient() {
        return this.lcClient;
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null in findById");
        EntityMetadata entity = this.lcClient.getRequiredEntity(this.entityInfo.getJavaType());
        PropertyMetadata idProperty = entity.getRequiredIdProperty();
        return SelectQuery.from(this.entityInfo.getJavaType(), "e").where(Criteria.property("e", idProperty.getName()).is(id)).execute(this.lcClient).next();
    }

    public Flux<T> findAllById(Publisher<ID> idPublisher) {
        EntityMetadata entity = this.lcClient.getRequiredEntity(this.entityInfo.getJavaType());
        PropertyMetadata idProperty = entity.getRequiredIdProperty();
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            return SelectQuery.from(this.entityInfo.getJavaType(), "e").where(Criteria.property("e", idProperty.getName()).in((Collection<?>)ids)).execute(this.lcClient);
        });
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null in existsById");
        EntityMetadata entity = this.lcClient.getRequiredEntity(this.entityInfo.getJavaType());
        PropertyMetadata idProperty = entity.getRequiredIdProperty();
        Table table = Table.create((SqlIdentifier)entity.getTableName());
        Column idColumn = Column.create((SqlIdentifier)idProperty.getColumnName(), (Table)table);
        Object idValue = this.lcClient.getSchemaDialect().convertToDataBase(id, idProperty);
        SqlQuery<Select> q = new SqlQuery<Select>(this.lcClient);
        Select select = Select.builder().select((Expression)idColumn).from((TableLike)table).limit(1L).where((Condition)Conditions.isEqual((Expression)idColumn, (Expression)q.marker(idValue))).build();
        q.setQuery(select);
        return q.execute().map((r, m) -> r).first().hasElement();
    }

    public <S extends T> Mono<S> save(S objectToSave) {
        return this.lcClient.save(objectToSave);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> objectsToSave) {
        return this.lcClient.save(objectsToSave);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> objectsToSave) {
        return this.lcClient.save(objectsToSave);
    }

    public Mono<Void> delete(T objectToDelete) {
        return this.lcClient.delete(objectToDelete);
    }

    public Mono<Void> deleteAll(Iterable<? extends T> iterable) {
        return this.lcClient.delete(iterable);
    }

    public Mono<Void> deleteAll(Publisher<? extends T> objectPublisher) {
        return this.lcClient.delete(objectPublisher);
    }

    public Mono<Void> deleteAll() {
        if (ModelUtils.hasCascadeDeleteImpacts(this.entityInfo.getJavaType())) {
            return this.deleteAll((Publisher<? extends T>)this.findAll());
        }
        return this.entityOperations.delete(this.entityInfo.getJavaType()).all().then();
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        EntityMetadata entity = this.lcClient.getRequiredEntity(this.entityInfo.getJavaType());
        PropertyMetadata idProperty = entity.getRequiredIdProperty();
        Table table = Table.create((SqlIdentifier)entity.getTableName());
        Column idColumn = Column.create((SqlIdentifier)idProperty.getColumnName(), (Table)table);
        SqlQuery<Delete> q = new SqlQuery<Delete>(this.lcClient);
        List idsList = Streamable.of(ids).map(id -> q.marker(this.lcClient.getSchemaDialect().convertToDataBase(id, idProperty))).toList();
        q.setQuery(Delete.builder().from(table).where(Conditions.in((Expression)idColumn, (Collection)idsList)).build());
        return q.execute().fetch().rowsUpdated().then();
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null in deleteById");
        if (ModelUtils.hasCascadeDeleteImpacts(this.entityInfo.getJavaType())) {
            return this.findById(id).flatMap(this::delete);
        }
        EntityMetadata entity = this.lcClient.getRequiredEntity(this.entityInfo.getJavaType());
        if (!entity.hasIdProperty()) {
            return this.findById(id).flatMap(this::delete);
        }
        PropertyMetadata idProperty = entity.getRequiredIdProperty();
        Table table = Table.create((SqlIdentifier)entity.getTableName());
        Column idColumn = Column.create((SqlIdentifier)idProperty.getColumnName(), (Table)table);
        Object idValue = this.lcClient.getSchemaDialect().convertToDataBase(id, idProperty);
        SqlQuery<Delete> q = new SqlQuery<Delete>(this.lcClient);
        q.setQuery(Delete.builder().from(table).where((Condition)Conditions.isEqual((Expression)idColumn, (Expression)q.marker(idValue))).build());
        return q.execute().fetch().rowsUpdated().then();
    }

    public Mono<Void> deleteById(Publisher<ID> idPublisher) {
        if (ModelUtils.hasCascadeDeleteImpacts(this.entityInfo.getJavaType())) {
            return this.deleteAll((Publisher<? extends T>)this.findAllById(idPublisher));
        }
        EntityMetadata entity = this.lcClient.getRequiredEntity(this.entityInfo.getJavaType());
        if (!entity.hasIdProperty()) {
            return this.deleteAll((Publisher<? extends T>)this.findAllById(idPublisher));
        }
        return Flux.from(idPublisher).subscribeOn(Schedulers.parallel()).publishOn(Schedulers.parallel()).buffer(100).parallel().runOn(Schedulers.parallel(), 1).flatMap(this::deleteAllById).then();
    }
}

