/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.operation.AbstractProcessor;
import net.lecousin.reactive.data.relational.query.operation.Operation;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import reactor.core.publisher.Mono;

class DeleteWithoutLoading
extends AbstractProcessor<Request> {
    private Map<PropertyMetadata, List<Request>> requests = new HashMap<PropertyMetadata, List<Request>>();

    DeleteWithoutLoading() {
    }

    Request addRequest(PropertyMetadata whereProperty, Object whereValue) {
        List list = this.requests.computeIfAbsent(whereProperty, p -> new LinkedList());
        for (Request r : list) {
            if (!r.whereProperty.equals(whereProperty) || !Objects.equals(r.whereValue, whereValue)) continue;
            return r;
        }
        Request r = new Request(whereProperty, whereValue);
        list.add(r);
        return r;
    }

    @Override
    protected Mono<Void> executeRequests(Operation op) {
        LinkedList<Mono<Void>> calls = new LinkedList<Mono<Void>>();
        for (Map.Entry<PropertyMetadata, List<Request>> property : this.requests.entrySet()) {
            LinkedList<Request> ready = new LinkedList<Request>();
            for (Request r : property.getValue()) {
                if (!this.canExecuteRequest(r)) continue;
                ready.add(r);
            }
            if (ready.isEmpty()) continue;
            SqlQuery<Delete> query = new SqlQuery<Delete>(op.lcClient);
            Table table = Table.create((SqlIdentifier)property.getKey().getEntity().getTableName());
            Condition condition = DeleteWithoutLoading.createCondition(table, ready, query);
            query.setQuery(Delete.builder().from(table).where(condition).build());
            calls.add((Mono<Void>)query.execute().then().doOnSuccess(v -> ready.forEach(r -> {
                r.executed = true;
            })));
        }
        return Operation.executeParallel(calls);
    }

    private static Condition createCondition(Table table, List<Request> ready, SqlQuery<Delete> query) {
        HashMap<SqlIdentifier, Set> valuesByColumn = new HashMap<SqlIdentifier, Set>();
        for (Request r : ready) {
            SqlIdentifier col = r.whereProperty.getColumnName();
            valuesByColumn.computeIfAbsent(col, c -> new HashSet()).add(r.whereValue);
        }
        Condition condition = null;
        for (Map.Entry e : valuesByColumn.entrySet()) {
            Column col = Column.create((SqlIdentifier)((SqlIdentifier)e.getKey()), (Table)table);
            ArrayList<Expression> list = new ArrayList<Expression>(((Set)e.getValue()).size());
            for (Object value : (Set)e.getValue()) {
                list.add(query.marker(value));
            }
            Condition c2 = Conditions.in((Expression)col, list);
            condition = condition != null ? condition.or(c2) : c2;
        }
        if (LcReactiveDataRelationalClient.logger.isDebugEnabled()) {
            LcReactiveDataRelationalClient.logger.debug((Object)("Delete " + table.getName() + " where " + condition));
        }
        return condition;
    }

    static class Request
    extends AbstractProcessor.Request {
        PropertyMetadata whereProperty;
        Object whereValue;

        Request(PropertyMetadata whereProperty, Object whereValue) {
            this.whereProperty = whereProperty;
            this.whereValue = whereValue;
        }
    }
}

