/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.criteria.CriteriaVisitor;
import net.lecousin.reactive.data.relational.query.criteria.InvalidCriteriaException;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;

public class CriteriaSqlBuilder
implements CriteriaVisitor<Condition> {
    protected Map<String, EntityMetadata> entitiesByAlias;
    protected Map<String, Table> tablesByAlias;
    protected SqlQuery<?> query;

    public CriteriaSqlBuilder(Map<String, EntityMetadata> entitiesByAlias, Map<String, Table> tablesByAlias, SqlQuery<?> query) {
        this.entitiesByAlias = entitiesByAlias;
        this.tablesByAlias = tablesByAlias;
        this.query = query;
    }

    @Override
    public Condition visit(Criteria.And and) {
        return and.getLeft().accept(this).and(and.getRight().accept(this));
    }

    @Override
    public Condition visit(Criteria.Or or) {
        return or.getLeft().accept(this).or(or.getRight().accept(this));
    }

    @Override
    public Condition visit(Criteria.PropertyOperation op) {
        EntityMetadata entity = this.entitiesByAlias.get(op.getLeft().getEntityName());
        PropertyMetadata property = entity.getRequiredProperty(op.getLeft().getPropertyName());
        Expression left = this.toExpression(op.getLeft());
        switch (op.getOperator()) {
            case IS_NULL: {
                return Conditions.isNull((Expression)left);
            }
            case IS_NOT_NULL: {
                return Conditions.isNull((Expression)left).not();
            }
        }
        if (op.getValue() instanceof Collection) {
            Collection value = (Collection)op.getValue();
            ArrayList<Expression> expressions = new ArrayList<Expression>(value.size());
            for (Object v : value) {
                expressions.add(this.toExpression(v, property));
            }
            switch (op.getOperator()) {
                case IN: {
                    return Conditions.in((Expression)left, expressions);
                }
                case NOT_IN: {
                    return Conditions.in((Expression)left, expressions).not();
                }
            }
            throw new InvalidCriteriaException("Unexpected operator " + op.getOperator() + " on a collection");
        }
        Object rightValue = op.getValue();
        if (property.isForeignKey() && rightValue != null && property.getType().isAssignableFrom(rightValue.getClass())) {
            EntityInstance<Object> foreignKey = this.query.getClient().getInstance(rightValue);
            rightValue = foreignKey.getId();
        }
        Expression right = this.toExpression(rightValue, property);
        switch (op.getOperator()) {
            case EQUALS: {
                return Conditions.isEqual((Expression)left, (Expression)right);
            }
            case NOT_EQUALS: {
                return Conditions.isNotEqual((Expression)left, (Expression)right);
            }
            case GREATER_THAN: {
                return Conditions.isGreater((Expression)left, (Expression)right);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Conditions.isGreaterOrEqualTo((Expression)left, (Expression)right);
            }
            case LESS_THAN: {
                return Conditions.isLess((Expression)left, (Expression)right);
            }
            case LESS_THAN_OR_EQUAL: {
                return Conditions.isLessOrEqualTo((Expression)left, (Expression)right);
            }
            case LIKE: {
                return Conditions.like((Expression)left, (Expression)right);
            }
            case NOT_LIKE: {
                return Conditions.like((Expression)left, (Expression)right).not();
            }
            case ARRAY_CONTAINS: {
                return Conditions.isEqual((Expression)right, (Expression)SimpleFunction.create((String)"ANY", Collections.singletonList(left)));
            }
        }
        throw new InvalidCriteriaException("Unexpected operator " + op.getOperator());
    }

    protected Expression toExpression(Object value, PropertyMetadata property) {
        if (value instanceof Criteria.PropertyOperand) {
            return this.toExpression((Criteria.PropertyOperand)value);
        }
        if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
            value = value.toString();
        }
        return this.query.marker(this.query.getClient().getSchemaDialect().convertToDataBase(value, property));
    }

    protected Expression toExpression(Criteria.PropertyOperand propertyOperand) {
        Column column;
        EntityMetadata rightEntity = this.entitiesByAlias.get(propertyOperand.getEntityName());
        Column result = column = Column.create((SqlIdentifier)rightEntity.getRequiredProperty(propertyOperand.getPropertyName()).getColumnName(), (Table)this.tablesByAlias.get(propertyOperand.getEntityName()));
        for (RelationalDatabaseSchemaDialect.SqlFunction fct : propertyOperand.getFunctionsToApply()) {
            result = this.query.getClient().getSchemaDialect().applyFunctionTo(fct, (Expression)result);
        }
        return result;
    }
}

