/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.mapping.LcEntityReader;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.PropertiesSource;
import net.lecousin.reactive.data.relational.model.PropertiesSourceMap;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.query.criteria.CriteriaSqlBuilder;
import net.lecousin.reactive.data.relational.query.criteria.CriteriaVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderNamingStrategy;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple3;

public class SelectExecution<T> {
    private static final Log logger = LogFactory.getLog(SelectExecution.class);
    private SelectQuery<T> query;
    private LcReactiveDataRelationalClient client;
    private LcEntityReader reader;

    public SelectExecution(SelectQuery<T> query, LcReactiveDataRelationalClient client, @Nullable LcEntityReader reader) {
        this.query = query;
        this.client = client;
        this.reader = reader != null ? reader : new LcEntityReader(null, client.getMapper());
    }

    public Flux<T> execute() {
        return Mono.fromCallable(this::needsPreSelectIds).flatMapMany(needsPreSelect -> needsPreSelect != false ? this.executeWithPreSelect() : this.executeWithoutPreSelect()).checkpoint(this.query.toString());
    }

    public Mono<Long> executeCount() {
        ArrayList<Expression> idColumns;
        this.query.setJoinsTargetType(this.client.getMapper());
        EntityMetadata meta = this.client.getRequiredEntity(this.query.from.targetType);
        SelectMapping mapping = this.buildSelectMapping();
        if (meta.hasIdProperty()) {
            idColumns = Collections.singletonList(Column.create((SqlIdentifier)meta.getRequiredIdProperty().getColumnName(), (Table)mapping.tableByAlias.get(this.query.from.alias)));
        } else if (meta.hasCompositeId()) {
            List<PropertyMetadata> properties = meta.getCompositeIdProperties();
            idColumns = new ArrayList(properties.size());
            for (PropertyMetadata property : properties) {
                idColumns.add((Expression)Column.create((SqlIdentifier)property.getColumnName(), (Table)mapping.tableByAlias.get(this.query.from.alias)));
            }
        } else {
            throw new IllegalArgumentException("Cannot count distinct entities without an Id column or a CompoisteId");
        }
        SelectBuilder.SelectFromAndJoin select = Select.builder().select(this.client.getSchemaDialect().countDistinct(idColumns)).from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.needsTableForPreSelect(join, false)) continue;
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> q = new SqlQuery<Select>(this.client);
        if (this.query.where != null) {
            select = ((SelectBuilder.SelectWhere)select).where(this.query.where.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, q)));
        }
        q.setQuery(select.build());
        return q.execute().fetch().one().map(m -> (Long)m.values().iterator().next());
    }

    private boolean needsPreSelectIds() {
        this.query.setJoinsTargetType(this.client.getMapper());
        if (!this.hasJoinMany()) {
            return false;
        }
        if (this.query.limit > 0L) {
            return true;
        }
        return this.hasOrderByOnSubEntityOrOrderByWithConditionOnSubEntity() || this.hasConditionOnManyEntity();
    }

    private boolean hasJoinMany() {
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!SelectExecution.isMany(join)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMany(SelectQuery.TableReference table) {
        if (table.source == null) {
            return false;
        }
        try {
            Field field = table.source.targetType.getDeclaredField(table.propertyName);
            return ModelUtils.isCollection(field);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isManyFromRoot(SelectQuery.TableReference table) {
        while (table.source != null) {
            if (SelectExecution.isMany(table)) {
                return true;
            }
            table = table.source;
        }
        return false;
    }

    private boolean hasOrderByOnSubEntityOrOrderByWithConditionOnSubEntity() {
        if (this.query.orderBy.isEmpty()) {
            return false;
        }
        for (Tuple3<String, String, Boolean> order : this.query.orderBy) {
            SelectQuery.TableReference table = this.query.tableAliases.get(order.getT1());
            if (table == this.query.from) continue;
            return true;
        }
        return this.hasConditionOnSubEntity();
    }

    private boolean hasConditionOnSubEntity() {
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference table = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (table != SelectExecution.this.query.from) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && (table = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName())) != SelectExecution.this.query.from) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private boolean hasConditionOnManyEntity() {
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference table = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (SelectExecution.isManyFromRoot(table)) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && SelectExecution.isManyFromRoot(table = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private static boolean isSourceFor(SelectQuery.TableReference t1, SelectQuery.TableReference t2) {
        while (t2 != null) {
            if (t1 == t2) {
                return true;
            }
            t2 = t2.source;
        }
        return false;
    }

    private boolean needsTableForPreSelect(final SelectQuery.TableReference table, boolean includeOrderBy) {
        if (includeOrderBy) {
            for (Tuple3<String, String, Boolean> order : this.query.orderBy) {
                SelectQuery.TableReference t = this.query.tableAliases.get(order.getT1());
                if (!SelectExecution.isSourceFor(table, t)) continue;
                return true;
            }
        }
        if (this.query.where == null) {
            return false;
        }
        Boolean found = this.query.where.accept(new CriteriaVisitor.SearchVisitor(){

            @Override
            public Boolean visit(Criteria.PropertyOperation op) {
                SelectQuery.TableReference t = SelectExecution.this.query.tableAliases.get(op.getLeft().getEntityName());
                if (SelectExecution.isSourceFor(table, t)) {
                    return Boolean.TRUE;
                }
                if (op.getValue() instanceof Criteria.PropertyOperand && SelectExecution.isSourceFor(table, t = SelectExecution.this.query.tableAliases.get(((Criteria.PropertyOperand)op.getValue()).getEntityName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return found;
    }

    private Flux<T> executeWithPreSelect() {
        SelectMapping mapping = this.buildSelectMapping();
        return this.buildDistinctRootIdSql(mapping).execute().fetch().all().map(row -> row.values().iterator().next()).buffer(100).flatMap(ids -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pre-selected ids bunch: " + Objects.toString(ids)));
            }
            String idPropertyName = mapping.entitiesByAlias.get(this.query.from.alias).getRequiredIdProperty().getName();
            Flux fromDb = this.buildFinalSql(mapping, Criteria.property(this.query.from.alias, idPropertyName).in((Collection<?>)ids), false, true).execute().fetch().all();
            return Flux.create(sink -> {
                RowHandlerSorted handler = new RowHandlerSorted(mapping, sink, (List<Object>)ids);
                fromDb.doOnComplete(handler::handleEnd).subscribe(handler::handleRow, arg_0 -> ((FluxSink)sink).error(arg_0));
            });
        });
    }

    private Flux<T> executeWithoutPreSelect() {
        SelectMapping mapping = this.buildSelectMapping();
        Flux fromDb = this.buildFinalSql(mapping, this.query.where, true, this.hasJoinMany()).execute().fetch().all();
        return Flux.create(sink -> {
            RowHandler handler = new RowHandler(mapping, sink);
            fromDb.doOnComplete(handler::handleEnd).subscribe(handler::handleRow, arg_0 -> ((FluxSink)sink).error(arg_0));
        });
    }

    private SelectMapping buildSelectMapping() {
        SelectMapping mapping = new SelectMapping();
        EntityMetadata meta = this.client.getRequiredEntity(this.query.from.targetType);
        HashMap<String, String> fieldAliases = new HashMap<String, String>();
        mapping.fieldAliasesByTableAlias.put(this.query.from.alias, fieldAliases);
        mapping.entitiesByAlias.put(this.query.from.alias, meta);
        mapping.tableByAlias.put(this.query.from.alias, Table.create((SqlIdentifier)meta.getTableName()).as(this.query.from.alias));
        for (PropertyMetadata property : meta.getPersistentProperties()) {
            String alias = mapping.generateAlias();
            mapping.fields.add(new SelectField(this.query.from.alias, property, alias));
            fieldAliases.put(property.getName(), alias);
        }
        for (SelectQuery.TableReference join : this.query.joins) {
            EntityMetadata joinEntity = this.client.getRequiredEntity(join.targetType);
            fieldAliases = new HashMap();
            mapping.fieldAliasesByTableAlias.put(join.alias, fieldAliases);
            mapping.entitiesByAlias.put(join.alias, joinEntity);
            mapping.tableByAlias.put(join.alias, Table.create((SqlIdentifier)joinEntity.getTableName()).as(join.alias));
            for (PropertyMetadata property : joinEntity.getPersistentProperties()) {
                String alias = mapping.generateAlias();
                mapping.fields.add(new SelectField(join.alias, property, alias));
                fieldAliases.put(property.getName(), alias);
            }
        }
        return mapping;
    }

    private SqlQuery<Select> buildFinalSql(SelectMapping mapping, Criteria criteria, boolean applyLimitAndOrderBy, boolean orderById) {
        ArrayList<Column> selectFields = new ArrayList<Column>(mapping.fields.size());
        for (SelectField selectField : mapping.fields) {
            selectFields.add(selectField.toSql());
        }
        SelectBuilder.SelectFromAndJoin select = Select.builder().select(selectFields).from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        if (applyLimitAndOrderBy) {
            select = this.addLimit((SelectBuilder.BuildSelect)select);
            select = this.addOrderBy((SelectBuilder.BuildSelect)select);
        }
        for (SelectQuery.TableReference join : this.query.joins) {
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> sqlQuery = new SqlQuery<Select>(this.client);
        if (criteria != null) {
            select = ((SelectBuilder.SelectWhere)select).where(criteria.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, sqlQuery)));
        }
        if (orderById) {
            EntityMetadata entity = this.client.getRequiredEntity(this.query.from.targetType);
            if (entity.hasIdProperty()) {
                String idPropertyName = entity.getRequiredIdProperty().getName();
                select = ((SelectBuilder.SelectOrdered)select).orderBy(new Column[]{Column.aliased((String)idPropertyName, (Table)mapping.tableByAlias.get(this.query.from.alias), (String)mapping.fieldAliasesByTableAlias.get(this.query.from.alias).get(idPropertyName))});
            } else if (entity.hasCompositeId()) {
                List<PropertyMetadata> properties = entity.getCompositeIdProperties();
                Column[] columns = new Column[properties.size()];
                int i = 0;
                for (PropertyMetadata property : properties) {
                    columns[i++] = Column.aliased((String)property.getName(), (Table)mapping.tableByAlias.get(this.query.from.alias), (String)mapping.fieldAliasesByTableAlias.get(this.query.from.alias).get(property.getName()));
                }
                select = ((SelectBuilder.SelectOrdered)select).orderBy(columns);
            }
        }
        sqlQuery.setQuery(select.build());
        return sqlQuery;
    }

    private SelectBuilder.BuildSelect addLimit(SelectBuilder.BuildSelect select) {
        if (this.query.limit > 0L) {
            return ((SelectBuilder.SelectFromAndJoin)select).limitOffset(this.query.limit, this.query.offset);
        }
        return select;
    }

    private SelectBuilder.BuildSelect addOrderBy(SelectBuilder.BuildSelect select) {
        if (!this.query.orderBy.isEmpty()) {
            ArrayList<OrderByField> list = new ArrayList<OrderByField>(this.query.orderBy.size());
            for (Tuple3<String, String, Boolean> orderBy : this.query.orderBy) {
                SelectQuery.TableReference table = this.query.tableAliases.get(orderBy.getT1());
                EntityMetadata e = this.client.getRequiredEntity(table.targetType);
                PropertyMetadata p = e.getRequiredPersistentProperty((String)orderBy.getT2());
                OrderByField o = OrderByField.from((Column)Column.create((SqlIdentifier)p.getColumnName(), (Table)Table.create((SqlIdentifier)e.getTableName()).as(table.alias)), (Sort.Direction)((Boolean)orderBy.getT3() != false ? Sort.Direction.ASC : Sort.Direction.DESC));
                list.add(o);
            }
            return ((SelectBuilder.SelectFromAndOrderBy)select).orderBy(list);
        }
        return select;
    }

    private SqlQuery<Select> buildDistinctRootIdSql(SelectMapping mapping) {
        if (this.query.limit > 0L && !this.query.orderBy.isEmpty() || this.hasOrderByOnSubEntityOrOrderByWithConditionOnSubEntity()) {
            return this.buildDistinctRootIdSqlUsingGroupBy(mapping);
        }
        EntityMetadata entity = this.client.getRequiredEntity(this.query.from.targetType);
        SelectBuilder.SelectFromAndJoin select = Select.builder().select((Expression)Column.create((SqlIdentifier)entity.getRequiredIdProperty().getColumnName(), (Table)mapping.tableByAlias.get(this.query.from.alias))).distinct().from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        select = this.addLimit((SelectBuilder.BuildSelect)select);
        select = this.addOrderBy((SelectBuilder.BuildSelect)select);
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.needsTableForPreSelect(join, true)) continue;
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> q = new SqlQuery<Select>(this.client);
        if (this.query.where != null) {
            select = ((SelectBuilder.SelectWhere)select).where(this.query.where.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, q)));
        }
        q.setQuery(select.build());
        return q;
    }

    private SqlQuery<Select> buildDistinctRootIdSqlUsingGroupBy(final SelectMapping mapping) {
        final EntityMetadata entity = this.client.getRequiredEntity(this.query.from.targetType);
        SelectBuilder.SelectFromAndJoin select = Select.builder().select((Expression)Column.create((SqlIdentifier)entity.getRequiredIdProperty().getColumnName(), (Table)mapping.tableByAlias.get(this.query.from.alias))).from((TableLike)mapping.tableByAlias.get(this.query.from.alias));
        for (SelectQuery.TableReference join : this.query.joins) {
            if (!this.needsTableForPreSelect(join, true)) continue;
            select = this.join((SelectBuilder.BuildSelect)select, join, mapping);
        }
        SqlQuery<Select> q = new SqlQuery<Select>(this.client){

            @Override
            protected String finalizeQuery(String sql, RenderContext renderContext) {
                StringBuilder s = new StringBuilder(sql);
                s.append(" GROUP BY ").append(this.toSql(Column.create((SqlIdentifier)entity.getRequiredIdProperty().getColumnName(), (Table)mapping.tableByAlias.get(SelectExecution.this.query.from.alias)), renderContext));
                s.append(" ORDER BY ");
                for (Tuple3<String, String, Boolean> orderBy : SelectExecution.this.query.orderBy) {
                    SelectQuery.TableReference table = SelectExecution.this.query.tableAliases.get(orderBy.getT1());
                    EntityMetadata e = SelectExecution.this.client.getRequiredEntity(table.targetType);
                    PropertyMetadata p = e.getRequiredPersistentProperty((String)orderBy.getT2());
                    Column col = Column.create((SqlIdentifier)p.getColumnName(), (Table)Table.create((SqlIdentifier)e.getTableName()).as(table.alias));
                    if (((Boolean)orderBy.getT3()).booleanValue()) {
                        s.append("MIN(").append(this.toSql(col, renderContext)).append(") ASC");
                        continue;
                    }
                    s.append("MAX(").append(this.toSql(col, renderContext)).append(") DESC");
                }
                if (SelectExecution.this.query.limit > 0L) {
                    s.append(" LIMIT ").append(SelectExecution.this.query.limit).append(" OFFSET ").append(SelectExecution.this.query.offset);
                }
                return s.toString();
            }

            private String toSql(Column col, RenderContext renderContext) {
                RenderNamingStrategy namingStrategy = renderContext.getNamingStrategy();
                return SqlIdentifier.from((SqlIdentifier[])new SqlIdentifier[]{namingStrategy.getReferenceName(col.getTable()), namingStrategy.getReferenceName(col)}).toSql(renderContext.getIdentifierProcessing());
            }
        };
        if (this.query.where != null) {
            select = ((SelectBuilder.SelectWhere)select).where(this.query.where.accept(new CriteriaSqlBuilder(mapping.entitiesByAlias, mapping.tableByAlias, q)));
        }
        q.setQuery(select.build());
        return q;
    }

    private SelectBuilder.BuildSelect join(SelectBuilder.BuildSelect select, SelectQuery.TableReference join, SelectMapping mapping) {
        EntityMetadata sourceEntity = this.client.getRequiredEntity(join.source.targetType);
        EntityMetadata targetEntity = this.client.getRequiredEntity(join.targetType);
        PropertyMetadata property = sourceEntity.getProperty(join.propertyName);
        if (property != null && property.isPersistent()) {
            Table joinTargetTable = mapping.tableByAlias.get(join.alias);
            Column joinTarget = Column.create((SqlIdentifier)targetEntity.getRequiredIdProperty().getColumnName(), (Table)joinTargetTable);
            Table joinSourceTable = mapping.tableByAlias.get(join.source.alias);
            Column joinSource = Column.create((SqlIdentifier)property.getColumnName(), (Table)joinSourceTable);
            return ((SelectBuilder.SelectJoin)select).leftOuterJoin((TableLike)joinTargetTable).on((Expression)joinTarget).equals((Expression)joinSource);
        }
        PropertyMetadata foreignTable = sourceEntity.getRequiredForeignTableProperty(join.propertyName);
        property = targetEntity.getRequiredPersistentProperty(foreignTable.getForeignTableAnnotation().joinKey());
        Table joinTargetTable = mapping.tableByAlias.get(join.alias);
        Column joinTarget = Column.create((SqlIdentifier)property.getColumnName(), (Table)joinTargetTable);
        Table joinSourceTable = mapping.tableByAlias.get(join.source.alias);
        Column joinSource = Column.create((SqlIdentifier)sourceEntity.getRequiredIdProperty().getColumnName(), (Table)joinSourceTable);
        return ((SelectBuilder.SelectJoin)select).leftOuterJoin((TableLike)joinTargetTable).on((Expression)joinTarget).equals((Expression)joinSource);
    }

    private class RowHandlerSorted
    extends RowHandler {
        private LinkedList<Object> sortedIds;
        private Map<Object, T> waitingInstances;

        private RowHandlerSorted(SelectMapping mapping, FluxSink<T> sink, List<Object> sortedIds) {
            super(mapping, sink);
            this.waitingInstances = new HashMap();
            this.sortedIds = new LinkedList<Object>(sortedIds);
        }

        @Override
        protected void newRootReady(T root, Object rootId) {
            Object instance;
            Object nextId = this.sortedIds.getFirst();
            if (!rootId.equals(nextId)) {
                this.waitingInstances.put(rootId, root);
                return;
            }
            this.sink.next(root);
            this.sortedIds.removeFirst();
            while (!this.sortedIds.isEmpty() && !this.waitingInstances.isEmpty() && (instance = this.waitingInstances.remove(nextId = this.sortedIds.getFirst())) != null) {
                this.sink.next(instance);
                this.sortedIds.removeFirst();
            }
        }

        @Override
        protected void endOfRoots() {
            while (!this.waitingInstances.isEmpty()) {
                Object nextId = this.sortedIds.removeFirst();
                Object instance = this.waitingInstances.get(nextId);
                if (instance == null) continue;
                this.sink.next(instance);
            }
            this.sink.complete();
        }
    }

    private class RowHandler {
        protected JoinStatus rootStatus;
        protected FluxSink<T> sink;

        protected RowHandler(SelectMapping mapping, FluxSink<T> sink) {
            this.sink = sink;
            try {
                this.rootStatus = new JoinStatus(SelectExecution.this.query.from, null, mapping, SelectExecution.this.query.joins, SelectExecution.this.client);
            }
            catch (Exception e) {
                throw new MappingException("Error initializing row mapper", (Throwable)e);
            }
        }

        public void handleRow(Map<String, Object> row) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result row = " + row));
            }
            PropertiesSourceMap source = new PropertiesSourceMap(row, this.rootStatus.aliases);
            Object rootId = this.rootStatus.idGetter.apply(source);
            if (this.rootStatus.currentEntityInstance != null) {
                if (rootId != null && !this.rootStatus.currentId.equals(rootId)) {
                    EntityInstance<?> instance = this.rootStatus.currentEntityInstance;
                    Object id = this.rootStatus.currentId;
                    this.rootStatus.reset(null);
                    this.newRootReady(instance.getEntity(), id);
                    this.rootStatus.readNewInstance(rootId, source, SelectExecution.this.reader);
                }
            } else {
                this.rootStatus.readNewInstance(rootId, source, SelectExecution.this.reader);
            }
            this.fillLinkedEntities(this.rootStatus, row);
        }

        public void handleEnd() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"End of rows");
            }
            if (this.rootStatus.currentEntityInstance != null) {
                EntityInstance<?> instance = this.rootStatus.currentEntityInstance;
                Object id = this.rootStatus.currentId;
                this.rootStatus.reset(null);
                this.newRootReady(instance.getEntity(), id);
            }
            this.endOfRoots();
        }

        protected void newRootReady(T root, Object rootId) {
            this.sink.next(root);
        }

        protected void endOfRoots() {
            this.sink.complete();
        }

        private void fillLinkedEntities(JoinStatus parent, Map<String, Object> row) {
            for (JoinStatus join : parent.joins) {
                try {
                    this.fillLinkedEntity(join, parent, row);
                }
                catch (Exception e) {
                    throw new MappingException("Error mapping result for entity " + join.entityType.getType().getName(), (Throwable)e);
                }
            }
        }

        private void fillLinkedEntity(JoinStatus join, JoinStatus parent, Map<String, Object> row) throws ReflectiveOperationException {
            PropertiesSourceMap source;
            Object id;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Read join " + join.entityType.getType().getSimpleName() + " from " + parent.entityType.getType().getSimpleName()));
            }
            if ((id = join.idGetter.apply(source = new PropertiesSourceMap(row, join.aliases))) == null) {
                if (join.joinProperty.isCollection() && ModelUtils.getFieldValue(parent.currentEntityInstance.getEntity(), join.joinProperty.getStaticMetadata().getField()) == null) {
                    ModelUtils.setFieldValue(parent.currentEntityInstance.getEntity(), join.joinProperty.getStaticMetadata().getField(), CollectionFactory.createCollection(join.joinProperty.getType(), ModelUtils.getCollectionType(join.joinProperty.getStaticMetadata().getField()), (int)0));
                }
                return;
            }
            if (!id.equals(join.currentId)) {
                join.readNewInstance(id, source, SelectExecution.this.reader);
                if (join.joinProperty.isCollection()) {
                    ModelUtils.addToCollectionField(join.joinProperty.getStaticMetadata().getField(), parent.currentEntityInstance.getEntity(), join.currentEntityInstance.getEntity());
                } else if (join.joinProperty.isForeignTable()) {
                    parent.currentEntityInstance.getState().setForeignTableField(parent.currentEntityInstance.getEntity(), join.joinProperty.getStaticMetadata(), join.currentEntityInstance.getEntity());
                } else {
                    ModelUtils.setFieldValue(parent.currentEntityInstance.getEntity(), join.joinProperty.getStaticMetadata().getField(), join.currentEntityInstance.getEntity());
                }
            }
            this.fillLinkedEntities(join, row);
        }
    }

    private static class JoinStatus {
        private EntityMetadata entityType;
        private Function<PropertiesSource, Object> idGetter;
        private Map<String, String> aliases;
        private PropertyMetadata joinProperty;
        private List<JoinStatus> joins;
        private EntityInstance<?> currentEntityInstance = null;
        private Object currentId = null;

        private JoinStatus(SelectQuery.TableReference table, SelectQuery.TableReference fromJoin, SelectMapping mapping, List<SelectQuery.TableReference> allJoins, LcReactiveDataRelationalClient client) throws ReflectiveOperationException {
            this.entityType = client.getRequiredEntity(table.targetType);
            this.idGetter = ModelUtils.idGetter(this.entityType.getSpringMetadata());
            this.aliases = mapping.fieldAliasesByTableAlias.get(table.alias);
            if (fromJoin != null) {
                this.joinProperty = client.getRequiredEntity(fromJoin.targetType).getRequiredProperty(table.propertyName);
            }
            this.joins = new LinkedList<JoinStatus>();
            for (SelectQuery.TableReference join : allJoins) {
                if (join.source != table) continue;
                this.joins.add(new JoinStatus(join, table, mapping, allJoins, client));
            }
        }

        private void reset(EntityInstance<?> parentInstance) {
            if (this.currentEntityInstance == null) {
                return;
            }
            if (parentInstance != null && this.joinProperty.isForeignTable()) {
                parentInstance.getState().foreignTableLoaded(this.joinProperty.getStaticMetadata().getField(), ModelUtils.getFieldValue(parentInstance.getEntity(), this.joinProperty.getStaticMetadata().getField()));
            }
            for (JoinStatus join : this.joins) {
                join.reset(this.currentEntityInstance);
            }
            this.currentEntityInstance = null;
            this.currentId = null;
        }

        private void readNewInstance(Object id, PropertiesSource source, LcEntityReader reader) {
            this.reset(null);
            this.currentId = id;
            if (id != null) {
                this.currentEntityInstance = reader.getCache().getInstanceById(this.entityType.getType(), id);
                if (this.currentEntityInstance != null && !this.currentEntityInstance.getState().isLoaded()) {
                    this.currentEntityInstance = null;
                }
            }
            if (this.currentEntityInstance == null) {
                this.currentEntityInstance = reader.read(this.entityType, source);
            }
        }
    }

    private static class SelectField {
        private String tableAlias;
        private PropertyMetadata property;
        private String fieldAlias;

        public SelectField(String tableAlias, PropertyMetadata property, String fieldAlias) {
            this.tableAlias = tableAlias;
            this.property = property;
            this.fieldAlias = fieldAlias;
        }

        public Column toSql() {
            return Column.create((SqlIdentifier)this.property.getColumnName(), (Table)Table.create((SqlIdentifier)this.property.getEntity().getTableName()).as(this.tableAlias)).as(this.fieldAlias);
        }
    }

    private static class SelectMapping {
        private Map<String, EntityMetadata> entitiesByAlias = new HashMap<String, EntityMetadata>();
        private Map<String, Table> tableByAlias = new HashMap<String, Table>();
        private Map<String, Map<String, String>> fieldAliasesByTableAlias = new HashMap<String, Map<String, String>>();
        private List<SelectField> fields = new LinkedList<SelectField>();
        private int aliasCounter = 0;

        private SelectMapping() {
        }

        private String generateAlias() {
            int num = this.aliasCounter++;
            return "f" + StringUtils.leftPad((String)Integer.toString(num), (int)4, (char)'0');
        }
    }
}

