/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.model;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.reactive.data.relational.model.metadata.EntityInstance;

public class EntityCache {
    private Map<Class<?>, Map<Object, EntityInstance<?>>> cache = new HashMap();

    public <T> EntityInstance<T> getInstanceById(Class<T> type, Object id) {
        Map<Object, EntityInstance<?>> instances = this.cache.get(type);
        if (instances == null) {
            return null;
        }
        return instances.get(id);
    }

    public <T> void setInstanceById(Object id, EntityInstance<T> instance) {
        Map instances = this.cache.computeIfAbsent(instance.getType(), t -> new HashMap());
        instances.put(id, instance);
    }

    public <T> EntityInstance<T> getOrSetInstance(EntityInstance<T> instance) {
        Object id;
        if (!instance.getState().isPersisted()) {
            return instance;
        }
        Map map = this.cache.computeIfAbsent(instance.getType(), e -> new HashMap());
        EntityInstance known = (EntityInstance)map.get(id = instance.getId());
        if (known == null) {
            map.put(id, instance);
            return instance;
        }
        if (known == instance || known.getEntity() == instance.getEntity()) {
            return instance;
        }
        return known;
    }

    public <T> EntityInstance<T> getInstance(T entity) {
        for (EntityInstance<?> instance : this.cache.get(entity.getClass()).values()) {
            if (instance.getEntity() != entity) continue;
            return instance;
        }
        return null;
    }
}

