/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.mapping;

import java.lang.reflect.Field;
import java.util.Optional;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.mapping.R2dbcMappingContext;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class LcR2dbcMappingContext
extends R2dbcMappingContext {
    public LcR2dbcMappingContext(NamingStrategy namingStrategy) {
        super(namingStrategy);
    }

    protected <T> RelationalPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        if (!this.forceQuoteFor(typeInformation)) {
            return super.createPersistentEntity(typeInformation);
        }
        this.setForceQuote(true);
        RelationalPersistentEntity entity = super.createPersistentEntity(typeInformation);
        this.setForceQuote(false);
        return entity;
    }

    private <T> boolean forceQuoteFor(TypeInformation<T> typeInformation) {
        if (this.isForceQuote()) {
            return false;
        }
        Table annotation = typeInformation.getRawTypeInformation().getType().getAnnotation(Table.class);
        return annotation != null && StringUtils.hasText((String)annotation.value());
    }

    protected RelationalPersistentProperty createPersistentProperty(Property property, RelationalPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        if (!this.forceQuoteFor(property)) {
            return super.createPersistentProperty(property, owner, simpleTypeHolder);
        }
        this.setForceQuote(true);
        RelationalPersistentProperty p = super.createPersistentProperty(property, owner, simpleTypeHolder);
        this.setForceQuote(false);
        return p;
    }

    private boolean forceQuoteFor(Property property) {
        if (this.isForceQuote()) {
            return false;
        }
        Optional field = property.getField();
        if (!field.isPresent()) {
            return false;
        }
        Column col = ((Field)field.get()).getAnnotation(Column.class);
        return col != null && StringUtils.hasText((String)col.value());
    }
}

