/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.mapping;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.mapping.LcMappingR2dbcConverter;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.model.metadata.PropertyMetadata;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LcEntityWriter {
    private LcMappingR2dbcConverter converter;
    private CustomConversions conversions;
    private ConversionService conversionService;

    public LcEntityWriter(LcMappingR2dbcConverter converter) {
        this.converter = converter;
        this.conversions = converter.getConversions();
        this.conversionService = converter.getConversionService();
    }

    public void write(Object source, OutboundRow sink) {
        Class userClass = ClassUtils.getUserClass((Object)source);
        Optional customTarget = this.conversions.getCustomWriteTarget(userClass, OutboundRow.class);
        if (customTarget.isPresent()) {
            OutboundRow result = (OutboundRow)this.conversionService.convert(source, OutboundRow.class);
            Assert.notNull((Object)result, (String)"OutboundRow must not be null");
            sink.putAll((Map)result);
            return;
        }
        EntityMetadata entity = this.converter.getLcClient().getRequiredEntity(userClass);
        PersistentPropertyAccessor propertyAccessor = entity.getSpringMetadata().getPropertyAccessor(source);
        this.writeProperties(sink, entity, propertyAccessor);
    }

    private void writeProperties(OutboundRow sink, EntityMetadata entity, PersistentPropertyAccessor<?> accessor) {
        for (PropertyMetadata property : entity.getPersistentProperties()) {
            if (!property.isWritable()) continue;
            this.writeProperty(sink, property, accessor);
        }
    }

    public void writeProperty(OutboundRow sink, PropertyMetadata property, PersistentPropertyAccessor<?> accessor) {
        Object value = accessor.getProperty((PersistentProperty)property.getRequiredSpringProperty());
        if (property.isForeignKey()) {
            EntityMetadata fe = this.converter.getLcClient().getRequiredEntity(property.getType());
            PropertyMetadata idProperty = fe.getRequiredIdProperty();
            if (value != null) {
                value = EntityState.get(value, fe).getPersistedValue(idProperty.getName());
            }
            if (value == null) {
                sink.put(property.getColumnName(), Parameter.empty(this.getPotentiallyConvertedSimpleNullType(idProperty.getType())));
                return;
            }
        }
        if (value == null) {
            this.writeNull(sink, property);
            return;
        }
        value = this.converter.getLcClient().getSchemaDialect().convertToDataBase(value, property);
        this.writeSimple(sink, value, property);
    }

    protected void writeNull(OutboundRow sink, PropertyMetadata property) {
        sink.put(property.getColumnName(), Parameter.empty(this.getPotentiallyConvertedSimpleNullType(property.getType())));
    }

    protected Class<?> getPotentiallyConvertedSimpleNullType(Class<?> type) {
        Optional customTarget = this.conversions.getCustomWriteTarget(type);
        if (customTarget.isPresent()) {
            return (Class)customTarget.get();
        }
        if (type.isEnum()) {
            return String.class;
        }
        if (Character.class.equals(type)) {
            return Long.class;
        }
        if (char[].class.equals(type)) {
            return String.class;
        }
        return type;
    }

    protected void writeSimple(OutboundRow sink, Object value, PropertyMetadata property) {
        Object converted = this.getPotentiallyConvertedSimpleWrite(value);
        Assert.notNull((Object)converted, (String)"Converted value must not be null");
        sink.put(property.getColumnName(), Parameter.from((Object)converted));
    }

    @Nullable
    protected Object getPotentiallyConvertedSimpleWrite(@Nullable Object value) {
        return this.getPotentiallyConvertedSimpleWrite(value, Object.class);
    }

    @Nullable
    protected Object getPotentiallyConvertedSimpleWrite(@Nullable Object value, Class<?> typeHint) {
        Optional customTarget;
        if (value == null) {
            return null;
        }
        if (Object.class != typeHint && this.conversionService.canConvert(value.getClass(), typeHint) && (value = this.conversionService.convert(value, typeHint)) == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float) {
                return ((Number)value).doubleValue();
            }
            if (!(value instanceof BigDecimal)) {
                return ((Number)value).longValue();
            }
        } else {
            if (value instanceof Character) {
                return (long)((Character)value).charValue();
            }
            if (char[].class.equals(value.getClass())) {
                return new String((char[])value);
            }
        }
        if ((customTarget = this.conversions.getCustomWriteTarget(value.getClass())).isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            return ((Enum)value).name();
        }
        return value;
    }
}

