/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.tests;

import java.lang.reflect.Field;
import java.util.Arrays;
import net.lecousin.reactive.data.relational.annotations.CompositeId;
import net.lecousin.reactive.data.relational.annotations.JoinTable;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelException;
import net.lecousin.reactive.data.relational.model.ModelUtils;
import net.lecousin.reactive.data.relational.model.metadata.EntityStaticMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.relational.core.mapping.Column;

class TestModelErrors {
    TestModelErrors() {
    }

    @Test
    void test() throws Exception {
        Assertions.assertThrows(ModelAccessException.class, () -> EntityStaticMetadata.get(this.getClass()));
        Assertions.assertThrows(ModelException.class, () -> EntityStaticMetadata.setClasses(Arrays.asList(this.getClass())));
        EntityStaticMetadata.setClasses(Arrays.asList(NonEnhancedEntity.class));
        EntityStaticMetadata ti = EntityStaticMetadata.get(NonEnhancedEntity.class);
        Assertions.assertNull((Object)ti.getJoinTableElementsForJoinTableClass((Object)"test", this.getClass()));
        Assertions.assertNull((Object)ModelUtils.getAsCollection((Object)this));
        Assertions.assertNull((Object)ModelUtils.getCollectionType((Field)NonEnhancedEntity.class.getDeclaredField("_lcState")));
        Assertions.assertThrows(MappingException.class, () -> ModelUtils.getRequiredCollectionType((Field)NonEnhancedEntity.class.getDeclaredField("_lcState")));
    }

    @Test
    void testInvalidCompositeId() throws Exception {
        try {
            EntityStaticMetadata.setClasses(Arrays.asList(InvalidCompositeId.class));
            throw new AssertionError();
        }
        catch (ModelAccessException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("hello does not exist"));
            return;
        }
    }

    @Test
    void testInvalidJoinTable() throws Exception {
        try {
            EntityStaticMetadata.setClasses(Arrays.asList(JoinFrom.class, JoinTo.class));
            throw new AssertionError();
        }
        catch (ModelAccessException modelAccessException) {
            return;
        }
    }

    public static class JoinTo {
        private EntityState _lcState;
    }

    public static class JoinFrom {
        private EntityState _lcState;
        @JoinTable
        private JoinTo join;
    }

    @CompositeId(properties={"hello", "world"}, indexName="test")
    public static class InvalidCompositeId {
        private EntityState _lcState;
        @Column
        private String text;
    }

    public static class NonEnhancedEntity {
        private EntityState _lcState;
    }
}

