/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.tests;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.lecousin.reactive.data.relational.util.Iterables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestIterables {
    TestIterables() {
    }

    @Test
    void testFilterIterable() {
        List<Integer> iterable = Arrays.asList(10, 11, 12, 13, 14, 15);
        Iterable filtered = Iterables.filter(iterable, i -> i % 2 == 0);
        Iterator it = filtered.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((int)10, (Integer)((Integer)it.next()));
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((int)12, (Integer)((Integer)it.next()));
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((int)14, (Integer)((Integer)it.next()));
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next());
    }

    @Test
    void testMapIterable() {
        List<Integer> iterable = Arrays.asList(10, 11, 12, 13, 14, 15);
        Iterable mapped = Iterables.map(iterable, i -> i.toString());
        Iterator it = mapped.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"10", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"11", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"12", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"13", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"14", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"15", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next());
    }
}

