/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.onetoonemodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity1;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity1Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity1WithConstructor;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity1WithConstructorRepository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity2;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity2Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity3;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity3Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity4;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity4Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity5;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MyEntity6;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity1;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity1Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity1WithConstructor;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity2;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity3;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity4;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity5;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity5Repository;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity6;
import net.lecousin.reactive.data.relational.test.onetoonemodel.MySubEntity6Repository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;
import reactor.core.publisher.Flux;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractTestOneToOneModel
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private MyEntity1Repository repo1;
    @Autowired
    private MyEntity2Repository repo2;
    @Autowired
    private MyEntity3Repository repo3;
    @Autowired
    private MyEntity4Repository repo4;
    @Autowired
    private MySubEntity1Repository subRepo1;
    @Autowired
    private MySubEntity5Repository subRepo5;
    @Autowired
    private MySubEntity6Repository subRepo6;
    @Autowired
    private MyEntity1WithConstructorRepository repo1Ctor;

    @Override
    protected Collection<Class<?>> usedEntities() {
        return Arrays.asList(MyEntity1.class, MySubEntity1.class, MyEntity2.class, MySubEntity2.class, MyEntity3.class, MySubEntity3.class, MyEntity4.class, MySubEntity4.class, MyEntity5.class, MySubEntity5.class, MyEntity6.class, MySubEntity6.class, MyEntity1WithConstructor.class, MySubEntity1WithConstructor.class);
    }

    @Test
    public void testEntity1WithoutSubEntity() {
        MyEntity1 entity = new MyEntity1();
        entity.setValue("test");
        this.repo1.save(entity).block();
        List list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        entity.setValue("modified");
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"modified", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        Assertions.assertNull((Object)entity.lazyGetSubEntity().block());
        Assertions.assertNull((Object)entity.lazyGetSubEntity().block());
        this.repo1.deleteAll(list).block();
        Assertions.assertEquals((int)0, (int)((List)this.repo1.findAll().collectList().block()).size());
    }

    @Test
    public void testEntity1WithSubEntity() {
        MyEntity1 entity = new MyEntity1();
        entity.setValue("test");
        MySubEntity1 subEntity = new MySubEntity1();
        subEntity.setSubValue("sub test");
        entity.setSubEntity(subEntity);
        subEntity.setParent(entity);
        this.repo1.save(entity).block();
        List list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertTrue((subEntity == entity.lazyGetSubEntity().block() ? 1 : 0) != 0);
        list = (List)this.repo1.findByValue("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo1.findByValue("test").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertTrue((entity.getSubEntity().getParent() == entity ? 1 : 0) != 0);
        entity.setValue("test 2");
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        subEntity.setSubValue("sub test 2");
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test 2", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test 2", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        subEntity = new MySubEntity1();
        subEntity.setSubValue("new one");
        entity.setSubEntity(subEntity);
        this.repo1.save(entity).block();
        list = (List)this.repo1.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"new one", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"new one", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo1.delete(entity).block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MyEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MySubEntity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testConstructorEntity1WithoutSubEntity() {
        MyEntity1WithConstructor entity = new MyEntity1WithConstructor(null, "test", null);
        this.repo1Ctor.save(entity).block();
        List list = (List)this.repo1Ctor.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1WithConstructor)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        entity.setValue("modified");
        this.repo1Ctor.save(entity).block();
        list = (List)this.repo1Ctor.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1WithConstructor)list.get(0);
        Assertions.assertEquals((Object)"modified", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        Assertions.assertNull((Object)entity.lazyGetSubEntity().block());
        Assertions.assertNull((Object)entity.lazyGetSubEntity().block());
        this.repo1Ctor.deleteAll(list).block();
        Assertions.assertEquals((int)0, (int)((List)this.repo1Ctor.findAll().collectList().block()).size());
    }

    @Test
    public void testConstructorEntity1WithSubEntity() {
        MyEntity1WithConstructor entity = new MyEntity1WithConstructor(null, "test", null);
        MySubEntity1WithConstructor subEntity = new MySubEntity1WithConstructor(null, "sub test", entity);
        entity.setSubEntity(subEntity);
        this.repo1Ctor.save(entity).block();
        List list = (List)this.repo1Ctor.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1WithConstructor)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        subEntity = (MySubEntity1WithConstructor)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertTrue((subEntity == entity.lazyGetSubEntity().block() ? 1 : 0) != 0);
        list = (List)this.repo1Ctor.findByValue("abcd").collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        list = (List)this.repo1Ctor.findByValue("test").collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1WithConstructor)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertTrue((entity.getSubEntity().getParent() == entity ? 1 : 0) != 0);
        entity.setValue("test 2");
        this.repo1Ctor.save(entity).block();
        list = (List)this.repo1Ctor.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1WithConstructor)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1WithConstructor)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        subEntity.setSubValue("sub test 2");
        this.repo1Ctor.save(entity).block();
        list = (List)this.repo1Ctor.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1WithConstructor)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1WithConstructor)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub test 2", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"sub test 2", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity1WithConstructor.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity1WithConstructor.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        subEntity = new MySubEntity1WithConstructor(null, "new one", entity);
        entity.setSubEntity(subEntity);
        this.repo1Ctor.save(entity).block();
        list = (List)this.repo1Ctor.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity1WithConstructor)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        subEntity = (MySubEntity1WithConstructor)entity.lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"new one", (Object)subEntity.getSubValue());
        Assertions.assertEquals((Object)"new one", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity1WithConstructor.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity1WithConstructor.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo1Ctor.delete(entity).block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MyEntity1WithConstructor.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MySubEntity1WithConstructor.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testEntity2WithoutSubEntity() {
        MyEntity2 entity = new MyEntity2();
        entity.setValue("test");
        this.repo2.save(entity).block();
        List list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        entity.setValue("modified");
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"modified", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        this.repo2.deleteAll(list).block();
        Assertions.assertEquals((int)0, (int)((List)this.repo2.findAll().collectList().block()).size());
    }

    @Test
    public void testEntity2WithSubEntity() {
        MyEntity2 entity = new MyEntity2();
        entity.setValue("test");
        MySubEntity2 subEntity = new MySubEntity2();
        subEntity.setSubValue("sub test");
        entity.setSubEntity(subEntity);
        subEntity.setParent(entity);
        this.repo2.save(entity).block();
        List list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertNull((Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)((MySubEntity2)entity.lazyGetSubEntity().block()).getSubValue());
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertNull((Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().lazyGetSubValue().block());
        entity.setValue("test 2");
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        entity.getSubEntity().setSubValue("sub test 2");
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"sub test 2", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        subEntity = new MySubEntity2();
        subEntity.setSubValue("new one");
        entity.setSubEntity(subEntity);
        this.repo2.save(entity).block();
        list = (List)this.repo2.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity2)list.get(0);
        Assertions.assertEquals((Object)"test 2", (Object)entity.getValue());
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)entity, (Object)entity.getSubEntity().getParent());
        Assertions.assertFalse((boolean)entity.getSubEntity().entityLoaded());
        entity.getSubEntity().loadEntity().block();
        Assertions.assertEquals((Object)"new one", (Object)entity.getSubEntity().getSubValue());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MyEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)SelectQuery.from(MySubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        this.repo2.delete(entity).block();
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MyEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)SelectQuery.from(MySubEntity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testEntity3WithSubEntity() {
        MyEntity3 entity = new MyEntity3();
        entity.setValue("test");
        MySubEntity3 subEntity = new MySubEntity3();
        subEntity.setSubValue("sub test");
        entity.setSubEntity(subEntity);
        subEntity.setParent(entity);
        this.repo3.save(entity).block();
        List list = (List)this.repo3.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (MyEntity3)list.get(0);
        Assertions.assertEquals((Object)"test", (Object)entity.getValue());
        Assertions.assertNull((Object)entity.getSubEntity());
        entity.lazyGetSubEntity().block();
        Assertions.assertNotNull((Object)entity.getSubEntity());
        Assertions.assertEquals((Object)"sub test", (Object)entity.getSubEntity().getSubValue());
        this.repo3.delete(entity).block();
        list = (List)SelectQuery.from(MyEntity3.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
        List subList = (List)SelectQuery.from(MySubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)subList.size());
        Assertions.assertNull((Object)((MySubEntity3)subList.get(0)).getParent());
        entity = new MyEntity3();
        entity.setValue("second");
        entity.setSubEntity((MySubEntity3)subList.get(0));
        ((MySubEntity3)subList.get(0)).setParent(entity);
        this.repo3.save(entity).block();
        list = (List)this.repo3.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertNull((Object)((MyEntity3)list.get(0)).getSubEntity());
        Assertions.assertNotNull((Object)((MyEntity3)list.get(0)).lazyGetSubEntity().block());
        Assertions.assertNotNull((Object)((MyEntity3)list.get(0)).getSubEntity());
        subList = (List)SelectQuery.from(MySubEntity3.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)subList.size());
        Assertions.assertEquals((Long)((MySubEntity3)subList.get(0)).getId(), (Long)((MyEntity3)list.get(0)).getSubEntity().getId());
    }

    @Test
    public void testInsertAndDeleteManyEntities() {
        int nb = this.lcClient.getSchemaDialect().isMultipleInsertSupported() ? 100000 : 1000;
        this.lcClient.save((Publisher)Flux.range((int)0, (int)nb).map(i -> {
            MyEntity1 entity = new MyEntity1();
            entity.setValue("entity" + i);
            if (i % 2 == 0) {
                MySubEntity1 sub = new MySubEntity1();
                sub.setSubValue("sub" + i);
                sub.setParent(entity);
                entity.setSubEntity(sub);
            }
            return entity;
        })).then().block();
        Assertions.assertEquals((long)nb, (Long)((Long)this.repo1.count().block()));
        Assertions.assertEquals((long)(nb / 2), (Long)((Long)SelectQuery.from(MySubEntity1.class, (String)"e").executeCount(this.lcClient).block()));
        this.repo1.deleteAll().block();
        Assertions.assertEquals((int)0, (int)((List)this.repo1.findAll().collectList().block()).size());
    }

    @Test
    public void testDeleteById1() {
        List entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            MyEntity1 entity = new MyEntity1();
            entity.setValue("entity" + i);
            if (i % 2 == 0) {
                MySubEntity1 sub = new MySubEntity1();
                sub.setSubValue("sub" + i);
                sub.setParent(entity);
                entity.setSubEntity(sub);
            }
            return entity;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo1.count().block()));
        int nb = 10;
        for (MyEntity1 entity : entities) {
            this.repo1.deleteById(entity.getId()).block();
            Assertions.assertEquals((long)(--nb), (Long)((Long)this.repo1.count().block()));
            Assertions.assertTrue((boolean)this.repo1.findById(entity.getId()).blockOptional().isEmpty());
        }
        Assertions.assertEquals((long)0L, (Long)((Long)this.repo1.count().block()));
        entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            MyEntity1 entity = new MyEntity1();
            entity.setValue("entity" + i);
            if (i % 2 == 0) {
                MySubEntity1 sub = new MySubEntity1();
                sub.setSubValue("sub" + i);
                sub.setParent(entity);
                entity.setSubEntity(sub);
            }
            return entity;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo1.count().block()));
        this.repo1.deleteById((Publisher)Flux.fromIterable((Iterable)entities).map(MyEntity1::getId)).block();
        Assertions.assertEquals((long)0L, (Long)((Long)this.repo1.count().block()));
        entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            MyEntity1 entity = new MyEntity1();
            entity.setValue("entity" + i);
            if (i % 2 == 0) {
                MySubEntity1 sub = new MySubEntity1();
                sub.setSubValue("sub" + i);
                sub.setParent(entity);
                entity.setSubEntity(sub);
            }
            return entity;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo1.count().block()));
        Assertions.assertEquals((long)5L, (Long)((Long)this.subRepo1.count().block()));
        MySubEntity1 sub = (MySubEntity1)((MyEntity1)this.repo1.findByValue("entity4").blockFirst()).lazyGetSubEntity().block();
        Assertions.assertEquals((Object)"sub4", (Object)sub.getSubValue());
        this.subRepo1.deleteById(sub.getId()).block();
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo1.count().block()));
        Assertions.assertEquals((long)4L, (Long)((Long)this.subRepo1.count().block()));
        Assertions.assertNull((Object)((MyEntity1)this.repo1.findByValue("entity4").blockFirst()).lazyGetSubEntity().block());
    }

    @Test
    public void testDeleteById5HavingCascadeDelete() {
        List entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            MyEntity5 entity = new MyEntity5();
            entity.setValue("entity" + i);
            MySubEntity5 sub = new MySubEntity5();
            sub.setSubValue("sub" + i);
            sub.setParent(entity);
            entity.setSubEntity(sub);
            return entity;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)SelectQuery.from(MyEntity5.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)10L, (Long)((Long)this.subRepo5.count().block()));
        MySubEntity5 sub = ((MyEntity5)entities.get(3)).getSubEntity();
        Assertions.assertEquals((Object)"sub3", (Object)sub.getSubValue());
        this.subRepo5.deleteById(sub.getId()).block();
        Assertions.assertEquals((long)9L, (Long)((Long)SelectQuery.from(MyEntity5.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)9L, (Long)((Long)this.subRepo5.count().block()));
    }

    @Test
    public void testDeleteById6HavingForeignTableWithOptionalFalse() {
        List entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            MyEntity6 entity = new MyEntity6();
            entity.setValue("entity" + i);
            MySubEntity6 sub = new MySubEntity6();
            sub.setSubValue("sub" + i);
            sub.setParent(entity);
            entity.setSubEntity(sub);
            return entity;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)SelectQuery.from(MyEntity6.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)10L, (Long)((Long)this.subRepo6.count().block()));
        MySubEntity6 sub = ((MyEntity6)entities.get(3)).getSubEntity();
        Assertions.assertEquals((Object)"sub3", (Object)sub.getSubValue());
        this.subRepo6.deleteById(sub.getId()).block();
        Assertions.assertEquals((long)9L, (Long)((Long)SelectQuery.from(MyEntity6.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)9L, (Long)((Long)this.subRepo6.count().block()));
    }

    @Test
    public void testOneToOneWithCompositeIdInSubEntity() {
        List entities = (List)this.repo4.saveAll((Publisher)Flux.range((int)1, (int)10).map(i -> {
            MyEntity4 e = new MyEntity4();
            e.setValue("entity" + i);
            MySubEntity4 s = new MySubEntity4();
            s.setValue1(i + ".1");
            s.setValue2(i + ".2");
            s.setParent(e);
            e.setSubEntity(s);
            MyEntity1 e1 = new MyEntity1();
            e1.setValue("one." + i);
            s.setEntity1(e1);
            return e;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo4.count().block()));
        Assertions.assertEquals((long)10L, (Long)((Long)SelectQuery.from(MySubEntity4.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo1.count().block()));
        entities = (List)this.repo4.findAll().collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        for (MyEntity4 e : entities) {
            Assertions.assertTrue((boolean)e.getValue().startsWith("entity"));
            int i2 = Integer.parseInt(e.getValue().substring(6));
            Assertions.assertNull((Object)e.getSubEntity());
            MySubEntity4 s = (MySubEntity4)e.lazyGetSubEntity().block();
            Assertions.assertEquals((Object)(i2 + ".1"), (Object)s.getValue1());
            Assertions.assertEquals((Object)(i2 + ".2"), (Object)s.getValue2());
            Assertions.assertEquals((Object)s, (Object)e.getSubEntity());
            Assertions.assertNotNull((Object)s.getEntity1());
            Assertions.assertNull((Object)s.getEntity1().getValue());
            MyEntity1 e1 = (MyEntity1)s.lazyGetEntity1().block();
            Assertions.assertEquals((Object)("one." + i2), (Object)e1.getValue());
            Assertions.assertEquals((Object)("one." + i2), (Object)s.getEntity1().getValue());
        }
        MySubEntity4 sub = new MySubEntity4();
        sub.setValue1("4.1");
        sub.setValue2("4.2");
        Assertions.assertNull((Object)sub.getParent());
        this.lcClient.lazyLoad((Object)sub).block();
        Assertions.assertNotNull((Object)sub.getParent());
        Assertions.assertNull((Object)sub.getParent().getValue());
        this.lcClient.lazyLoad((Object)sub.getParent()).block();
        Assertions.assertEquals((Object)"entity4", (Object)sub.getParent().getValue());
        this.repo4.deleteAll().block();
        Assertions.assertEquals((long)0L, (Long)((Long)this.repo4.count().block()));
        Assertions.assertEquals((long)0L, (Long)((Long)SelectQuery.from(MySubEntity4.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)0L, (Long)((Long)this.repo1.count().block()));
        entities = (List)this.repo4.saveAll((Publisher)Flux.range((int)1, (int)10).map(i -> {
            MyEntity4 e = new MyEntity4();
            e.setValue("entity" + i);
            MySubEntity4 s = new MySubEntity4();
            s.setValue1(i + ".1");
            s.setValue2(i + ".2");
            s.setParent(e);
            e.setSubEntity(s);
            MyEntity1 e1 = new MyEntity1();
            e1.setValue("one." + i);
            s.setEntity1(e1);
            return e;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo4.count().block()));
        Assertions.assertEquals((long)10L, (Long)((Long)SelectQuery.from(MySubEntity4.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo1.count().block()));
        entities = (List)this.repo4.findAllWithSubEntities().collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        for (MyEntity4 e : entities) {
            Assertions.assertTrue((boolean)e.getValue().startsWith("entity"));
            int i3 = Integer.parseInt(e.getValue().substring(6));
            MySubEntity4 s = e.getSubEntity();
            Assertions.assertNotNull((Object)s);
            Assertions.assertEquals((Object)(i3 + ".1"), (Object)s.getValue1());
            Assertions.assertEquals((Object)(i3 + ".2"), (Object)s.getValue2());
            Assertions.assertEquals((Object)s, (Object)e.getSubEntity());
            MyEntity1 e1 = s.getEntity1();
            Assertions.assertNotNull((Object)e1);
            Assertions.assertNotNull((Object)e1.getValue());
            Assertions.assertEquals((Object)("one." + i3), (Object)e1.getValue());
            Assertions.assertEquals((Object)("one." + i3), (Object)s.getEntity1().getValue());
        }
        this.repo4.deleteAll(entities).block();
        Assertions.assertEquals((long)0L, (Long)((Long)this.repo4.count().block()));
        Assertions.assertEquals((long)0L, (Long)((Long)SelectQuery.from(MySubEntity4.class, (String)"e").executeCount(this.lcClient).block()));
        Assertions.assertEquals((long)0L, (Long)((Long)this.repo1.count().block()));
    }

    @Test
    public void testInvalidJoin() {
        SelectQuery q = SelectQuery.from(MyEntity4.class, (String)"e").join("e", "subEntity", "s");
        Assertions.assertThrows(IllegalArgumentException.class, () -> q.join("subEntity", "entity1", "e1"));
    }

    @Test
    public void testCriteriaOnForeignKey() {
        List entities = (List)this.lcClient.save((Publisher)Flux.range((int)0, (int)10).map(i -> {
            MyEntity1 entity = new MyEntity1();
            entity.setValue("entity" + i);
            MySubEntity1 sub = new MySubEntity1();
            sub.setSubValue("sub" + i);
            sub.setParent(entity);
            entity.setSubEntity(sub);
            return entity;
        })).collectList().block();
        Assertions.assertEquals((int)10, (int)entities.size());
        Assertions.assertEquals((long)10L, (Long)((Long)this.repo1.count().block()));
        Assertions.assertEquals((long)10L, (Long)((Long)this.subRepo1.count().block()));
        MyEntity1 e1 = (MyEntity1)entities.get(6);
        List list = (List)SelectQuery.from(MySubEntity1.class, (String)"sub").where(Criteria.property((String)"sub", (String)"parent").is((Object)e1)).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Long)e1.getSubEntity().getId(), (Long)((MySubEntity1)list.get(0)).getId());
        list = (List)SelectQuery.from(MySubEntity1.class, (String)"sub").where(Criteria.property((String)"sub", (String)"parent").isNot((Object)e1)).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)9, (int)list.size());
    }
}

