/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.multipleconnections;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcBadGrammarException;
import java.util.Arrays;
import net.lecousin.reactive.data.relational.test.multipleconnections.db1.Config1;
import net.lecousin.reactive.data.relational.test.multipleconnections.db1.MultipleDbEntity1;
import net.lecousin.reactive.data.relational.test.multipleconnections.db1.MyRepository1;
import net.lecousin.reactive.data.relational.test.multipleconnections.db2.Config2;
import net.lecousin.reactive.data.relational.test.multipleconnections.db2.MultipleDbEntity2;
import net.lecousin.reactive.data.relational.test.multipleconnections.db2.MyRepository2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import reactor.core.publisher.Mono;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={Config1.class, Config2.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public abstract class TestMultipleDatabaseConnections {
    @Autowired
    private MyRepository1 repo1;
    @Autowired
    private MyRepository2 repo2;
    @Autowired
    @Qualifier(value="db1DatabaseConnectionFactory")
    private ConnectionFactory factory1;
    @Autowired
    @Qualifier(value="db2DatabaseConnectionFactory")
    private ConnectionFactory factory2;

    @Test
    public void test() {
        this.repo1.getLcClient().dropCreateSchemaContent(this.repo1.getLcClient().buildSchemaFromEntities(Arrays.asList(MultipleDbEntity1.class))).block();
        this.repo2.getLcClient().dropCreateSchemaContent(this.repo2.getLcClient().buildSchemaFromEntities(Arrays.asList(MultipleDbEntity2.class))).block();
        MultipleDbEntity1 e1 = new MultipleDbEntity1();
        e1.setValue("db1");
        this.repo1.save(e1).block();
        MultipleDbEntity2 e2 = new MultipleDbEntity2();
        e2.setValue("second db");
        this.repo2.save(e2).block();
        Assertions.assertEquals((long)1L, (Long)((Long)this.repo1.count().block()));
        Assertions.assertEquals((Object)"db1", (Object)((MultipleDbEntity1)this.repo1.findAll().next().block()).getValue());
        Assertions.assertEquals((long)1L, (Long)((Long)this.repo2.count().block()));
        Assertions.assertEquals((Object)"second db", (Object)((MultipleDbEntity2)this.repo2.findAll().next().block()).getValue());
        Assertions.assertNotEquals((Object)this.repo1.getLcClient(), (Object)this.repo2.getLcClient());
        Assertions.assertEquals((Object)1L, (Object)Mono.from((Publisher)this.factory1.create()).flatMap(connection -> Mono.from((Publisher)connection.createStatement("SELECT COUNT(*) FROM multiple_db_entity1").execute()).flatMap(result -> Mono.from((Publisher)result.map((r, m) -> r.get(0)))).doOnTerminate(() -> Mono.from((Publisher)connection.close()).subscribe())).block());
        Assertions.assertEquals((Object)1L, (Object)Mono.from((Publisher)this.factory2.create()).flatMap(connection -> Mono.from((Publisher)connection.createStatement("SELECT COUNT(*) FROM multiple_db_entity2").execute()).flatMap(result -> Mono.from((Publisher)result.map((r, m) -> r.get(0)))).doOnTerminate(() -> Mono.from((Publisher)connection.close()).subscribe())).block());
        Assertions.assertThrows(R2dbcBadGrammarException.class, () -> Mono.from((Publisher)this.factory1.create()).flatMap(connection -> Mono.from((Publisher)connection.createStatement("SELECT COUNT(*) FROM multiple_db_entity2").execute()).flatMap(result -> Mono.from((Publisher)result.map((r, m) -> r.get(0)))).doOnTerminate(() -> Mono.from((Publisher)connection.close()).subscribe())).block());
        Assertions.assertThrows(R2dbcBadGrammarException.class, () -> Mono.from((Publisher)this.factory2.create()).flatMap(connection -> Mono.from((Publisher)connection.createStatement("SELECT COUNT(*) FROM multiple_db_entity1").execute()).flatMap(result -> Mono.from((Publisher)result.map((r, m) -> r.get(0)))).doOnTerminate(() -> Mono.from((Publisher)connection.close()).subscribe())).block());
    }

    public static interface DbUrls {
        @Bean
        @Qualifier(value="db1Url")
        public String getFirstDbConnectionUrl();

        @Bean
        @Qualifier(value="db2Url")
        public String getSecondDbConnectionUrl();
    }
}

