/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.manytomanymodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.manytomanymodel.Entity1;
import net.lecousin.reactive.data.relational.test.manytomanymodel.Entity1Repository;
import net.lecousin.reactive.data.relational.test.manytomanymodel.Entity2;
import net.lecousin.reactive.data.relational.test.manytomanymodel.Entity3;
import net.lecousin.reactive.data.relational.test.manytomanymodel.Entity3Repository;
import net.lecousin.reactive.data.relational.test.manytomanymodel.Entity4;
import net.lecousin.reactive.data.relational.test.manytomanymodel.JoinEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractTestManyToManyModel
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private Entity1Repository repo1;
    @Autowired
    private Entity3Repository repo3;

    @Override
    protected Collection<Class<?>> usedEntities() {
        return Arrays.asList(Entity1.class, Entity2.class, JoinEntity.class, Entity3.class, Entity4.class);
    }

    @Test
    public void testManualJoin() {
        Entity1 e1_1 = new Entity1();
        e1_1.setValue("1.1");
        e1_1.setLinks(new LinkedList<JoinEntity>());
        Entity1 e1_2 = new Entity1();
        e1_2.setValue("1.2");
        e1_2.setLinks(new LinkedList<JoinEntity>());
        Entity1 e1_3 = new Entity1();
        e1_3.setValue("1.3");
        e1_3.setLinks(new LinkedList<JoinEntity>());
        Entity1 e1_4 = new Entity1();
        e1_4.setValue("1.4");
        e1_4.setLinks(new LinkedList<JoinEntity>());
        Entity1 e1_5 = new Entity1();
        e1_5.setValue("1.5");
        e1_5.setLinks(new LinkedList<JoinEntity>());
        Entity2 e2_1 = new Entity2();
        e2_1.setValue("2.1");
        e2_1.setLinks(new LinkedList<JoinEntity>());
        Entity2 e2_2 = new Entity2();
        e2_2.setValue("2.2");
        e2_2.setLinks(new LinkedList<JoinEntity>());
        Entity2 e2_3 = new Entity2();
        e2_3.setValue("2.3");
        e2_3.setLinks(new LinkedList<JoinEntity>());
        JoinEntity j_1_1 = new JoinEntity();
        j_1_1.setEntity1(e1_1);
        j_1_1.setEntity2(e2_1);
        e1_1.getLinks().add(j_1_1);
        e2_1.getLinks().add(j_1_1);
        JoinEntity j_2_1 = new JoinEntity();
        j_2_1.setEntity1(e1_2);
        j_2_1.setEntity2(e2_1);
        e1_2.getLinks().add(j_2_1);
        e2_1.getLinks().add(j_2_1);
        JoinEntity j_3_2 = new JoinEntity();
        j_3_2.setEntity1(e1_3);
        j_3_2.setEntity2(e2_2);
        e1_3.getLinks().add(j_3_2);
        e2_2.getLinks().add(j_3_2);
        JoinEntity j_4_3 = new JoinEntity();
        j_4_3.setEntity1(e1_4);
        j_4_3.setEntity2(e2_3);
        e1_4.getLinks().add(j_4_3);
        e2_3.getLinks().add(j_4_3);
        JoinEntity j_5_3 = new JoinEntity();
        j_5_3.setEntity1(e1_5);
        j_5_3.setEntity2(e2_3);
        e1_5.getLinks().add(j_5_3);
        e2_3.getLinks().add(j_5_3);
        JoinEntity j_1_3 = new JoinEntity();
        j_1_3.setEntity1(e1_1);
        j_1_3.setEntity2(e2_3);
        e1_1.getLinks().add(j_1_3);
        e2_3.getLinks().add(j_1_3);
        List list1 = (List)this.repo1.saveAll(Arrays.asList(e1_1, e1_2, e1_3, e1_4, e1_5)).collectList().block();
        Assertions.assertEquals((int)5, (int)list1.size());
        list1 = (List)this.repo1.findByEntity1Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((Object)"1.3", (Object)((Entity1)list1.get(0)).getValue());
        Assertions.assertEquals((int)1, (int)((Entity1)list1.get(0)).getLinks().size());
        Assertions.assertEquals((Object)"2.2", (Object)((Entity1)list1.get(0)).getLinks().get(0).getEntity2().getValue());
        list1 = (List)this.repo1.findByEntity1Value("1.5").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((Object)"1.5", (Object)((Entity1)list1.get(0)).getValue());
        Assertions.assertEquals((int)1, (int)((Entity1)list1.get(0)).getLinks().size());
        Assertions.assertEquals((Object)"2.3", (Object)((Entity1)list1.get(0)).getLinks().get(0).getEntity2().getValue());
        Assertions.assertEquals((int)3, (int)((List)((Entity1)list1.get(0)).getLinks().get(0).getEntity2().lazyGetLinks().collectList().block()).size());
        list1 = (List)this.repo1.findByEntity2Value("2.3").collectList().block();
        Assertions.assertEquals((int)3, (int)list1.size());
        list1 = (List)this.repo1.findByLinkedEntity1Value("1.1").collectList().block();
        Assertions.assertEquals((int)4, (int)list1.size());
        Assertions.assertEquals((long)4L, (Long)((Long)this.repo1.countByLinkedEntity1Value("1.1").block()));
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Entity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(Entity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)6, (int)((List)SelectQuery.from(JoinEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        list1 = (List)this.repo1.findWithLinks().collectList().block();
        Assertions.assertEquals((int)5, (int)list1.size());
        e1_3 = list1.stream().filter(e -> "1.3".equals(e.getValue())).findFirst().get();
        JoinEntity link = e1_3.getLinks().stream().filter(l -> "2.2".equals(l.getEntity2().getValue())).findFirst().get();
        e1_3.getLinks().remove(link);
        this.repo1.save(e1_3).block();
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Entity1.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(Entity2.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(JoinEntity.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
    }

    @Test
    public void testAutomaticJoin() {
        Entity3 e1_1 = new Entity3();
        e1_1.setValue("1.1");
        e1_1.setLinks(new HashSet<Entity4>());
        Entity3 e1_2 = new Entity3();
        e1_2.setValue("1.2");
        e1_2.setLinks(new HashSet<Entity4>());
        Entity3 e1_3 = new Entity3();
        e1_3.setValue("1.3");
        e1_3.setLinks(new HashSet<Entity4>());
        Entity3 e1_4 = new Entity3();
        e1_4.setValue("1.4");
        e1_4.setLinks(new HashSet<Entity4>());
        Entity3 e1_5 = new Entity3();
        e1_5.setValue("1.5");
        e1_5.setLinks(new HashSet<Entity4>());
        Entity4 e2_1 = new Entity4();
        e2_1.setValue("2.1");
        e2_1.setLinks(new HashSet<Entity3>());
        Entity4 e2_2 = new Entity4();
        e2_2.setValue("2.2");
        e2_2.setLinks(new HashSet<Entity3>());
        Entity4 e2_3 = new Entity4();
        e2_3.setValue("2.3");
        e2_3.setLinks(new HashSet<Entity3>());
        e1_1.getLinks().add(e2_1);
        e2_1.getLinks().add(e1_1);
        e1_2.getLinks().add(e2_1);
        e2_1.getLinks().add(e1_2);
        e1_3.getLinks().add(e2_2);
        e2_2.getLinks().add(e1_3);
        e1_4.getLinks().add(e2_3);
        e2_3.getLinks().add(e1_4);
        e1_5.getLinks().add(e2_3);
        e2_3.getLinks().add(e1_5);
        e1_1.getLinks().add(e2_3);
        e2_3.getLinks().add(e1_1);
        List list1 = (List)this.repo3.saveAll(Arrays.asList(e1_1, e1_2, e1_3, e1_4, e1_5)).collectList().block();
        Assertions.assertEquals((int)5, (int)list1.size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Entity3.class, (String)"e").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(Entity4.class, (String)"e").execute(this.lcClient).collectList().block()).size());
        list1 = (List)this.repo3.findByEntity3Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((Object)"1.3", (Object)((Entity3)list1.get(0)).getValue());
        Assertions.assertEquals((int)1, (int)((Entity3)list1.get(0)).getLinks().size());
        Set<Entity4> links = ((Entity3)list1.get(0)).getLinks();
        Entity4 e4 = links.iterator().next();
        Assertions.assertEquals((Object)"2.2", (Object)e4.getValue());
        Assertions.assertFalse((boolean)links.isEmpty());
        Assertions.assertTrue((boolean)links.contains(e4));
        Assertions.assertFalse((boolean)links.contains(null));
        Assertions.assertFalse((boolean)links.contains(new Object()));
        Assertions.assertTrue((boolean)links.containsAll(Arrays.asList(e4)));
        Assertions.assertFalse((boolean)links.containsAll(Arrays.asList(e4, new Object())));
        Assertions.assertFalse((boolean)links.containsAll(Arrays.asList(new Object(), e4)));
        Assertions.assertFalse((boolean)links.containsAll(Arrays.asList(e4, null)));
        Assertions.assertEquals((int)1, (int)links.toArray().length);
        Assertions.assertEquals((Object)e4, (Object)links.toArray()[0]);
        Assertions.assertEquals((int)1, (int)links.toArray(new Object[0]).length);
        Assertions.assertEquals((Object)e4, (Object)links.toArray(new Object[10])[0]);
        Assertions.assertFalse((boolean)links.add(e4));
        Assertions.assertEquals((int)1, (int)links.size());
        Assertions.assertFalse((boolean)links.remove(new Object()));
        Assertions.assertEquals((int)1, (int)links.size());
        Assertions.assertFalse((boolean)links.retainAll(Arrays.asList(e4)));
        Assertions.assertTrue((boolean)((Entity3)list1.get(0)).getLinks().remove(((Entity3)list1.get(0)).getLinks().iterator().next()));
        Assertions.assertEquals((int)0, (int)((Entity3)list1.get(0)).getLinks().size());
        this.repo3.save((Entity3)list1.get(0)).block();
        list1 = (List)this.repo3.findByEntity3Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((int)0, (int)((Entity3)list1.get(0)).getLinks().size());
        ((Entity3)list1.get(0)).getLinks().add(e2_2);
        this.repo3.save((Entity3)list1.get(0)).block();
        list1 = (List)this.repo3.findByEntity3Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((int)1, (int)((Entity3)list1.get(0)).getLinks().size());
        ((Entity3)list1.get(0)).getLinks().removeAll(Arrays.asList(null, ((Entity3)list1.get(0)).getLinks().iterator().next(), new Object()));
        this.repo3.save((Entity3)list1.get(0)).block();
        list1 = (List)this.repo3.findByEntity3Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((int)0, (int)((Entity3)list1.get(0)).getLinks().size());
        ((Entity3)list1.get(0)).getLinks().addAll(Arrays.asList(e2_2));
        this.repo3.save((Entity3)list1.get(0)).block();
        list1 = (List)this.repo3.findByEntity3Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((int)1, (int)((Entity3)list1.get(0)).getLinks().size());
        ((Entity3)list1.get(0)).getLinks().retainAll(Arrays.asList(null, new Object()));
        this.repo3.save((Entity3)list1.get(0)).block();
        list1 = (List)this.repo3.findByEntity3Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((int)0, (int)((Entity3)list1.get(0)).getLinks().size());
        ((Entity3)list1.get(0)).getLinks().add(e2_2);
        this.repo3.save((Entity3)list1.get(0)).block();
        list1 = (List)this.repo3.findByEntity3Value("1.3").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((int)1, (int)((Entity3)list1.get(0)).getLinks().size());
        list1 = (List)this.repo3.findByEntity3Value("1.5").collectList().block();
        Assertions.assertEquals((int)1, (int)list1.size());
        Assertions.assertEquals((Object)"1.5", (Object)((Entity3)list1.get(0)).getValue());
        Assertions.assertEquals((int)1, (int)((Entity3)list1.get(0)).getLinks().size());
        Assertions.assertEquals((Object)"2.3", (Object)((Entity3)list1.get(0)).getLinks().iterator().next().getValue());
        Assertions.assertEquals((int)3, (int)((List)((Entity3)list1.get(0)).getLinks().iterator().next().lazyGetLinks().collectList().block()).size());
        list1 = (List)this.repo3.findByEntity4Value("2.3").collectList().block();
        Assertions.assertEquals((int)3, (int)list1.size());
        list1 = (List)this.repo3.findByLinkedEntity3Value("1.1").collectList().block();
        Assertions.assertEquals((int)4, (int)list1.size());
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Entity3.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(Entity4.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        list1 = (List)this.repo3.findWithLinks().collectList().block();
        Assertions.assertEquals((int)5, (int)list1.size());
        Assertions.assertEquals((int)2, (int)list1.stream().filter(e -> "1.1".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)1, (int)list1.stream().filter(e -> "1.2".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)1, (int)list1.stream().filter(e -> "1.3".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)1, (int)list1.stream().filter(e -> "1.4".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)1, (int)list1.stream().filter(e -> "1.5".equals(e.getValue())).findFirst().get().getLinks().size());
        for (Object e2 : list1) {
            Assertions.assertTrue((boolean)((Boolean)((Entity3)e2).lazyGetLinks().all(linked -> linked instanceof Entity4).block()));
        }
        List list2 = (List)SelectQuery.from(Entity4.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)3, (int)list2.size());
        Assertions.assertEquals((int)2, (int)((List)list2.stream().filter(e -> "2.1".equals(e.getValue())).findFirst().get().lazyGetLinks().collectList().block()).size());
        Assertions.assertEquals((int)1, (int)((List)list2.stream().filter(e -> "2.2".equals(e.getValue())).findFirst().get().lazyGetLinks().collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)list2.stream().filter(e -> "2.3".equals(e.getValue())).findFirst().get().lazyGetLinks().collectList().block()).size());
        for (Entity4 e3 : list2) {
            Assertions.assertTrue((boolean)((Boolean)e3.lazyGetLinks().all(linked -> linked instanceof Entity3).block()));
        }
        e1_3 = list1.stream().filter(e -> "1.3".equals(e.getValue())).findFirst().get();
        Entity4 link = e1_3.getLinks().stream().filter(l -> "2.2".equals(l.getValue())).findFirst().get();
        e1_3.getLinks().remove(link);
        this.repo3.save(e1_3).block();
        Assertions.assertEquals((int)5, (int)((List)SelectQuery.from(Entity3.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)SelectQuery.from(Entity4.class, (String)"entity").execute(this.lcClient).collectList().block()).size());
        list1 = (List)this.repo3.findWithLinks().collectList().block();
        Assertions.assertEquals((int)5, (int)list1.size());
        e1_3 = list1.stream().filter(e -> "1.3".equals(e.getValue())).findFirst().get();
        Assertions.assertEquals((int)0, (int)((List)e1_3.lazyGetLinks().collectList().block()).size());
        e2_2 = ((List)SelectQuery.from(Entity4.class, (String)"entity").execute(this.lcClient).collectList().block()).stream().filter(e -> "2.2".equals(e.getValue())).findFirst().get();
        Assertions.assertEquals((int)0, (int)((List)e2_2.lazyGetLinks().collectList().block()).size());
        Assertions.assertEquals((int)2, (int)list1.stream().filter(e -> "1.1".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)1, (int)list1.stream().filter(e -> "1.2".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)0, (int)list1.stream().filter(e -> "1.3".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)1, (int)list1.stream().filter(e -> "1.4".equals(e.getValue())).findFirst().get().getLinks().size());
        Assertions.assertEquals((int)1, (int)list1.stream().filter(e -> "1.5".equals(e.getValue())).findFirst().get().getLinks().size());
        list2 = (List)SelectQuery.from(Entity4.class, (String)"entity").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)3, (int)list2.size());
        Assertions.assertEquals((int)2, (int)((List)list2.stream().filter(e -> "2.1".equals(e.getValue())).findFirst().get().lazyGetLinks().collectList().block()).size());
        Assertions.assertEquals((int)0, (int)((List)list2.stream().filter(e -> "2.2".equals(e.getValue())).findFirst().get().lazyGetLinks().collectList().block()).size());
        Assertions.assertEquals((int)3, (int)((List)list2.stream().filter(e -> "2.3".equals(e.getValue())).findFirst().get().lazyGetLinks().collectList().block()).size());
    }
}

