/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test.arraycolumns;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.criteria.Criteria;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.arraycolumns.EntityWithArrays;
import net.lecousin.reactive.data.relational.test.arraycolumns.EntityWithArraysRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractTestArrayColumns
extends AbstractLcReactiveDataRelationalTest {
    @Autowired
    private EntityWithArraysRepository repo1;

    @Override
    protected Collection<Class<?>> usedEntities() {
        return Arrays.asList(EntityWithArrays.class);
    }

    @Test
    public void testEmptyArrays() {
        EntityWithArrays entity = new EntityWithArrays();
        this.repo1.save(entity).block();
        entity = (EntityWithArrays)this.repo1.findAll().blockFirst();
        Assertions.assertTrue((entity.getIntegers() == null || entity.getIntegers().length == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((entity.getPrimitiveIntegers() == null || entity.getPrimitiveIntegers().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testArraysWithOneElement() {
        EntityWithArrays entity = new EntityWithArrays();
        entity.setBooleans(new Boolean[]{Boolean.TRUE});
        entity.setPrimitiveBooleans(new boolean[]{false});
        entity.setBooleanList(Arrays.asList(Boolean.TRUE));
        entity.setShorts(new Short[]{(short)11});
        entity.setPrimitiveShorts(new short[]{111});
        entity.setShortList(Arrays.asList((short)1111));
        entity.setIntegers(new Integer[]{51});
        entity.setPrimitiveIntegers(new int[]{61});
        entity.setIntegerList(Arrays.asList(71));
        entity.setLongs(new Long[]{22L});
        entity.setPrimitiveLongs(new long[]{222L});
        entity.setLongList(Arrays.asList(2222L));
        entity.setFloats(new Float[]{Float.valueOf(1.1f)});
        entity.setPrimitiveFloats(new float[]{2.2f});
        entity.setFloatList(Arrays.asList(Float.valueOf(1.2f)));
        entity.setDoubles(new Double[]{3.3});
        entity.setPrimitiveDoubles(new double[]{4.4});
        entity.setDoubleList(Arrays.asList(4.5));
        entity.setStrings(new String[]{"test1"});
        entity.setStringList(Arrays.asList("test2"));
        this.repo1.save(entity).block();
        entity = (EntityWithArrays)this.repo1.findAll().blockFirst();
        Assertions.assertNotNull((Object)entity.getBooleans());
        Assertions.assertEquals((int)1, (int)entity.getBooleans().length);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)entity.getBooleans()[0]);
        Assertions.assertNotNull((Object)entity.getPrimitiveBooleans());
        Assertions.assertEquals((int)1, (int)entity.getPrimitiveBooleans().length);
        Assertions.assertFalse((boolean)entity.getPrimitiveBooleans()[0]);
        Assertions.assertNotNull(entity.getBooleanList());
        Assertions.assertEquals((int)1, (int)entity.getBooleanList().size());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)entity.getBooleanList().get(0));
        Assertions.assertNotNull((Object)entity.getShorts());
        Assertions.assertEquals((int)1, (int)entity.getShorts().length);
        Assertions.assertEquals((Short)11, (Short)entity.getShorts()[0]);
        Assertions.assertNotNull((Object)entity.getPrimitiveShorts());
        Assertions.assertEquals((int)1, (int)entity.getPrimitiveShorts().length);
        Assertions.assertEquals((short)111, (short)entity.getPrimitiveShorts()[0]);
        Assertions.assertNotNull(entity.getShortList());
        Assertions.assertEquals((int)1, (int)entity.getShortList().size());
        Assertions.assertEquals((Short)1111, (Short)entity.getShortList().get(0));
        Assertions.assertNotNull((Object)entity.getIntegers());
        Assertions.assertEquals((int)1, (int)entity.getIntegers().length);
        Assertions.assertEquals((int)51, (Integer)entity.getIntegers()[0]);
        Assertions.assertNotNull((Object)entity.getPrimitiveIntegers());
        Assertions.assertEquals((int)1, (int)entity.getPrimitiveIntegers().length);
        Assertions.assertEquals((int)61, (int)entity.getPrimitiveIntegers()[0]);
        Assertions.assertNotNull(entity.getIntegerList());
        Assertions.assertEquals((int)1, (int)entity.getIntegerList().size());
        Assertions.assertEquals((Integer)71, (Integer)entity.getIntegerList().get(0));
        Assertions.assertNotNull((Object)entity.getLongs());
        Assertions.assertEquals((int)1, (int)entity.getLongs().length);
        Assertions.assertEquals((long)22L, (Long)entity.getLongs()[0]);
        Assertions.assertNotNull((Object)entity.getPrimitiveLongs());
        Assertions.assertEquals((int)1, (int)entity.getPrimitiveLongs().length);
        Assertions.assertEquals((long)222L, (long)entity.getPrimitiveLongs()[0]);
        Assertions.assertNotNull(entity.getLongList());
        Assertions.assertEquals((int)1, (int)entity.getLongList().size());
        Assertions.assertEquals((Long)2222L, (Long)entity.getLongList().get(0));
        Assertions.assertNotNull((Object)entity.getFloats());
        Assertions.assertEquals((int)1, (int)entity.getFloats().length);
        Assertions.assertEquals((float)1.1f, (Float)entity.getFloats()[0]);
        Assertions.assertNotNull((Object)entity.getPrimitiveFloats());
        Assertions.assertEquals((int)1, (int)entity.getPrimitiveFloats().length);
        Assertions.assertEquals((float)2.2f, (float)entity.getPrimitiveFloats()[0]);
        Assertions.assertNotNull(entity.getFloatList());
        Assertions.assertEquals((int)1, (int)entity.getFloatList().size());
        Assertions.assertEquals((Float)Float.valueOf(1.2f), (Float)entity.getFloatList().get(0));
        Assertions.assertNotNull((Object)entity.getDoubles());
        Assertions.assertEquals((int)1, (int)entity.getDoubles().length);
        Assertions.assertEquals((double)3.3, (Double)entity.getDoubles()[0]);
        Assertions.assertNotNull((Object)entity.getPrimitiveDoubles());
        Assertions.assertEquals((int)1, (int)entity.getPrimitiveDoubles().length);
        Assertions.assertEquals((double)4.4, (double)entity.getPrimitiveDoubles()[0]);
        Assertions.assertNotNull(entity.getDoubleList());
        Assertions.assertEquals((int)1, (int)entity.getDoubleList().size());
        Assertions.assertEquals((Double)4.5, (Double)entity.getDoubleList().get(0));
        Assertions.assertNotNull((Object)entity.getStrings());
        Assertions.assertEquals((int)1, (int)entity.getStrings().length);
        Assertions.assertEquals((Object)"test1", (Object)entity.getStrings()[0]);
        Assertions.assertNotNull(entity.getStringList());
        Assertions.assertEquals((int)1, (int)entity.getStringList().size());
        Assertions.assertEquals((Object)"test2", (Object)entity.getStringList().get(0));
        entity.getIntegers()[0] = 12345;
        this.repo1.save(entity).block();
        entity = (EntityWithArrays)this.repo1.findAll().blockFirst();
        Assertions.assertNotNull((Object)entity.getIntegers());
        Assertions.assertEquals((int)1, (int)entity.getIntegers().length);
        Assertions.assertEquals((int)12345, (Integer)entity.getIntegers()[0]);
    }

    @Test
    public void testArraysWithThreeElements() {
        EntityWithArrays entity = new EntityWithArrays();
        entity.setIntegers(new Integer[]{10, 20, 30});
        entity.setPrimitiveIntegers(new int[]{100, 200, 300});
        entity.setStrings(new String[]{"test1", "test2", "test3"});
        this.repo1.save(entity).block();
        entity = (EntityWithArrays)this.repo1.findAll().blockFirst();
        Assertions.assertNotNull((Object)entity.getIntegers());
        Assertions.assertEquals((int)3, (int)entity.getIntegers().length);
        Assertions.assertEquals((int)10, (Integer)entity.getIntegers()[0]);
        Assertions.assertEquals((int)20, (Integer)entity.getIntegers()[1]);
        Assertions.assertEquals((int)30, (Integer)entity.getIntegers()[2]);
        Assertions.assertNotNull((Object)entity.getPrimitiveIntegers());
        Assertions.assertEquals((int)3, (int)entity.getPrimitiveIntegers().length);
        Assertions.assertEquals((int)100, (int)entity.getPrimitiveIntegers()[0]);
        Assertions.assertEquals((int)200, (int)entity.getPrimitiveIntegers()[1]);
        Assertions.assertEquals((int)300, (int)entity.getPrimitiveIntegers()[2]);
        Assertions.assertEquals((int)3, (int)entity.getStrings().length);
        Assertions.assertEquals((Object)"test1", (Object)entity.getStrings()[0]);
        Assertions.assertEquals((Object)"test2", (Object)entity.getStrings()[1]);
        Assertions.assertEquals((Object)"test3", (Object)entity.getStrings()[2]);
    }

    @Test
    public void testSearchEntityHavingAnArrayContaining() {
        EntityWithArrays entity1 = new EntityWithArrays();
        entity1.setIntegers(new Integer[]{10, 20, 30});
        EntityWithArrays entity2 = new EntityWithArrays();
        entity2.setIntegers(new Integer[]{20, 40, 60});
        this.repo1.saveAll(Arrays.asList(entity1, entity2)).collectList().block();
        List list = (List)SelectQuery.from(EntityWithArrays.class, (String)"e").where(Criteria.property((String)"e", (String)"integers").arrayContains((Object)10)).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((int)10, (Integer)((EntityWithArrays)list.get(0)).getIntegers()[0]);
        list = (List)SelectQuery.from(EntityWithArrays.class, (String)"e").where(Criteria.property((String)"e", (String)"integers").arrayContains((Object)20)).execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)2, (int)list.size());
    }
}

