/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.reactive.data.relational.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.lecousin.reactive.data.relational.LcReactiveDataRelationalClient;
import net.lecousin.reactive.data.relational.enhance.Enhancer;
import net.lecousin.reactive.data.relational.enhance.EntityState;
import net.lecousin.reactive.data.relational.model.ModelAccessException;
import net.lecousin.reactive.data.relational.model.ModelException;
import net.lecousin.reactive.data.relational.model.metadata.EntityMetadata;
import net.lecousin.reactive.data.relational.query.SelectQuery;
import net.lecousin.reactive.data.relational.query.SqlQuery;
import net.lecousin.reactive.data.relational.repository.LcR2dbcRepositoryFactoryBean;
import net.lecousin.reactive.data.relational.schema.Column;
import net.lecousin.reactive.data.relational.schema.RelationalDatabaseSchema;
import net.lecousin.reactive.data.relational.schema.SchemaBuilderFromEntities;
import net.lecousin.reactive.data.relational.schema.SchemaException;
import net.lecousin.reactive.data.relational.schema.Table;
import net.lecousin.reactive.data.relational.schema.dialect.RelationalDatabaseSchemaDialect;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatement;
import net.lecousin.reactive.data.relational.schema.dialect.SchemaStatements;
import net.lecousin.reactive.data.relational.test.AbstractLcReactiveDataRelationalTest;
import net.lecousin.reactive.data.relational.test.EntityWithNonNullProperty;
import net.lecousin.reactive.data.relational.test.EntityWithTransientFields;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.repository.config.EnableR2dbcRepositories;

@EnableR2dbcRepositories(repositoryFactoryBeanClass=LcR2dbcRepositoryFactoryBean.class)
public abstract class AbstractBasicTest
extends AbstractLcReactiveDataRelationalTest {
    @Override
    protected Collection<Class<?>> usedEntities() {
        return new LinkedList();
    }

    protected abstract Class<? extends RelationalDatabaseSchemaDialect> expectedDialect();

    @Test
    public void testDialect() {
        Assertions.assertEquals(this.expectedDialect(), this.lcClient.getSchemaDialect().getClass());
        Assertions.assertEquals(this.expectedDialect(), RelationalDatabaseSchemaDialect.getDialect((R2dbcDialect)this.lcClient.getDialect()).getClass());
        Assertions.assertTrue((boolean)this.lcClient.getSchemaDialect().isCompatible(this.lcClient.getDialect()));
    }

    @Test
    public void testEnhanceAgain() throws Exception {
        Collection<Class<?>> entities = this.getAllCompatibleEntities();
        try {
            Enhancer.enhance(Arrays.asList(entities.iterator().next().getName()));
            throw new AssertionError();
        }
        catch (Throwable throwable) {
            try {
                Enhancer.enhance(Arrays.asList(entities.iterator().next().getName()));
                throw new AssertionError();
            }
            catch (Throwable throwable2) {
                return;
            }
        }
    }

    @Test
    public void testEnhanceNonEntityClass() {
        try {
            Enhancer.enhance(Arrays.asList(this.getClass().getName()));
            throw new AssertionError((Object)"Error expected");
        }
        catch (ModelException modelException) {
            return;
        }
    }

    @Test
    public void testGetEntityStateError() throws Exception {
        EntityWithTransientFields entity = new EntityWithTransientFields();
        try {
            EntityState.get((Object)entity, (EntityMetadata)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            EntityState.get((Object)entity, (LcReactiveDataRelationalClient)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testEntityTransientFields() throws Exception {
        RelationalDatabaseSchema schema = this.lcClient.buildSchemaFromEntities(Arrays.asList(EntityWithTransientFields.class));
        this.lcClient.dropCreateSchemaContent(schema).block();
        EntityWithTransientFields entity = new EntityWithTransientFields();
        entity.setStr("aTest");
        entity.setTextNotSaved("should be null");
        entity.setDefaultHello("world");
        this.lcClient.save((Object)entity).block();
        List list = (List)SelectQuery.from(EntityWithTransientFields.class, (String)"e").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)1, (int)list.size());
        entity = (EntityWithTransientFields)list.get(0);
        Assertions.assertEquals((Object)"aTest", (Object)entity.getStr());
        Assertions.assertNull((Object)entity.getTextNotSaved());
        Assertions.assertNull((Object)entity.getDefaultHello());
        Assertions.assertNull((Object)entity.getClient());
        this.lcClient.delete((Object)entity).block();
        list = (List)SelectQuery.from(EntityWithTransientFields.class, (String)"e").execute(this.lcClient).collectList().block();
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testEntityWithNonNullableProperty() {
        RelationalDatabaseSchema schema = this.lcClient.buildSchemaFromEntities(Arrays.asList(EntityWithNonNullProperty.class));
        this.lcClient.dropCreateSchemaContent(schema).block();
        EntityWithNonNullProperty entity1 = new EntityWithNonNullProperty();
        Assertions.assertThrows(DataIntegrityViolationException.class, () -> this.lcClient.save((Object)entity1).block());
        entity1.setNonNullable(Boolean.TRUE);
        this.lcClient.save((Object)entity1).block();
        EntityWithNonNullProperty entity2 = (EntityWithNonNullProperty)SelectQuery.from(EntityWithNonNullProperty.class, (String)"e").execute(this.lcClient).blockFirst();
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)entity2.getNonNullable());
        entity2.setNonNullable(null);
        Assertions.assertThrows(DataIntegrityViolationException.class, () -> this.lcClient.save((Object)entity2).block());
    }

    @Test
    public void testPrintSchema() {
        RelationalDatabaseSchema schema = SchemaBuilderFromEntities.build((Collection)this.lcClient.getEntities(this.getAllCompatibleEntities()));
        this.lcClient.getSchemaDialect().createSchemaContent(schema).print(System.out);
    }

    @Test
    public void testSchema() {
        RelationalDatabaseSchema schema = SchemaBuilderFromEntities.build((Collection)this.lcClient.getEntities(this.getAllCompatibleEntities()));
        try {
            schema.getTable("Toto");
            throw new AssertionError();
        }
        catch (NoSuchElementException noSuchElementException) {
            Table table = schema.getTable("basic");
            table.getColumn("str");
            try {
                table.getColumn("toto");
                throw new AssertionError();
            }
            catch (NoSuchElementException noSuchElementException2) {
                return;
            }
        }
    }

    @Test
    public void testInvalidSchemaStatement() {
        SchemaStatement statement = new SchemaStatement("THIS IS INVALID");
        SchemaStatements statements = new SchemaStatements();
        statements.add(statement);
        try {
            statements.execute(this.lcClient).block();
            throw new AssertionError();
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testSchemaDialect() {
        RelationalDatabaseSchema schema = SchemaBuilderFromEntities.build((Collection)this.lcClient.getEntities(this.getAllCompatibleEntities()));
        Table table = schema.getTable("basic");
        Column col = table.getColumn("str");
        try {
            this.lcClient.getSchemaDialect().getColumnType(col, this.getClass(), null);
            throw new AssertionError();
        }
        catch (SchemaException schemaException) {
            return;
        }
    }

    @Test
    public void testInvalidQuery() {
        SqlQuery q = new SqlQuery(this.lcClient);
        q.setQuery((Object)1);
        Assertions.assertEquals((int)1, (Integer)((Integer)q.getQuery()));
        try {
            q.execute().fetch().all().collectList().block();
            throw new AssertionError();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void testGetNonEntity() {
        Assertions.assertThrows(ModelAccessException.class, () -> this.lcClient.getRequiredEntity(String.class));
    }

    @Test
    public void testSaveAndDeleteNonEntity() {
        Assertions.assertThrows(ModelAccessException.class, () -> this.lcClient.save((Object)"hello").block());
        Assertions.assertThrows(ModelAccessException.class, () -> this.lcClient.save(Arrays.asList("invalid")).blockFirst());
        this.lcClient.save(Arrays.asList(new Object[0])).blockFirst();
        this.lcClient.saveAll(Arrays.asList(new Object[0])).block();
        Assertions.assertThrows(ModelAccessException.class, () -> this.lcClient.delete((Object)"hello").block());
        Assertions.assertThrows(ModelAccessException.class, () -> this.lcClient.delete(Arrays.asList("invalid")).block());
        this.lcClient.delete(Arrays.asList(new Object[0])).block();
    }
}

