/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.network.mime.transfer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.util.AsyncConsumer;
import net.lecousin.framework.concurrent.util.PartialAsyncConsumer;
import net.lecousin.framework.network.mime.header.MimeHeaders;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValue;
import net.lecousin.framework.network.mime.header.ParameterizedHeaderValues;
import net.lecousin.framework.network.mime.transfer.ChunkedTransfer;
import net.lecousin.framework.network.mime.transfer.ContentDecoderFactory;
import net.lecousin.framework.network.mime.transfer.IdentityTransfer;

public final class TransferEncodingFactory {
    private TransferEncodingFactory() {
    }

    public static PartialAsyncConsumer<ByteBuffer, IOException> create(MimeHeaders headers, AsyncConsumer<ByteBuffer, IOException> consumer) throws IOException {
        String transfer = "identity";
        LinkedList<String> encoding = new LinkedList<String>();
        transfer = TransferEncodingFactory.encodingAndTransferFromHeader(headers, "Transfer-Encoding", encoding, transfer);
        transfer = TransferEncodingFactory.encodingAndTransferFromHeader(headers, "Content-Transfer-Encoding", encoding, transfer);
        TransferEncodingFactory.addEncodingFromHeader(headers, "Content-Encoding", encoding);
        AsyncConsumer<ByteBuffer, IOException> decoder = consumer;
        for (String coding : encoding) {
            decoder = ContentDecoderFactory.createDecoder(decoder, coding);
        }
        if ("chunked".equals(transfer)) {
            return new ChunkedTransfer.Receiver(headers, decoder);
        }
        return new IdentityTransfer.Receiver(headers, decoder);
    }

    public static String encodingAndTransferFromHeader(MimeHeaders headers, String headerName, LinkedList<String> encoding, String defaultValue) {
        if (!TransferEncodingFactory.addEncodingFromHeader(headers, headerName, encoding)) {
            return defaultValue;
        }
        String s = encoding.getLast();
        if ("identity".equals(s)) {
            encoding.removeLast();
        } else if ("chunked".equals(s)) {
            encoding.removeLast();
            return s;
        }
        return defaultValue;
    }

    public static boolean addEncodingFromHeader(MimeHeaders headers, String headerName, LinkedList<String> encoding) {
        ParameterizedHeaderValues values;
        try {
            values = headers.getFirstValue(headerName, ParameterizedHeaderValues.class);
        }
        catch (Exception e) {
            values = null;
        }
        if (values == null) {
            return false;
        }
        boolean changed = false;
        for (ParameterizedHeaderValue value : values.getValues()) {
            String e = value.getMainValue();
            if (e == null || (e = e.trim().toLowerCase()).isEmpty()) continue;
            encoding.add(e);
            changed = true;
        }
        return changed;
    }
}

